/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class IdValidator
extends AbstractValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private String fieldPath;
    private String id;
    private boolean checkWhitelist;
    private boolean checkUppercase;
    private int minLength;
    private int maxLength;
    private ApiMessageKey blankIdMessageKey = ApiMessageKey.id_blank_violation;
    private Object[] blankIdMessageParams = new Object[0];

    public IdValidator(String id, boolean checkWhitelist, boolean checkUppercase, String fieldPath) {
        this.id = id;
        this.checkWhitelist = checkWhitelist;
        this.checkUppercase = checkUppercase;
        this.fieldPath = fieldPath;
    }

    public IdValidator(String id, boolean checkWhitelist, boolean checkUppercase, int minLength, int maxLength, String fieldPath) {
        this.id = id;
        this.checkWhitelist = checkWhitelist;
        this.checkUppercase = checkUppercase;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.fieldPath = fieldPath;
    }

    public void setBlankIdMessageKey(ApiMessageKey blankIdMessageKey) {
        this.blankIdMessageKey = blankIdMessageKey;
    }

    public void setBlankIdMessageParams(Object ... blankIdMessageParams) {
        if (blankIdMessageParams != null) {
            this.blankIdMessageParams = blankIdMessageParams;
        }
    }

    public boolean validate() {
        if (this.id != null) {
            if (StringUtils.isBlank((String)this.id)) {
                this.appendError(this.errorFactory.create(this.blankIdMessageKey, this.fieldPath, this.blankIdMessageParams));
            } else if (this.checkWhitelist && !this.isWhitelisted(this.id)) {
                this.appendError(this.errorFactory.create(ApiMessageKey.id_whitelist_violation, this.fieldPath));
            } else if (this.checkUppercase && !this.id.toLowerCase().equals(this.id)) {
                this.appendError(this.errorFactory.create(ApiMessageKey.id_upper_case_violation, this.fieldPath));
            } else if (this.minLength > 0 && this.id.length() < this.minLength) {
                this.appendError(this.errorFactory.create(ApiMessageKey.id_min_length_violation, this.fieldPath, new Object[]{this.minLength}));
            } else if (this.maxLength > 0 && this.id.length() > this.maxLength) {
                this.appendError(this.errorFactory.create(ApiMessageKey.id_max_length_violation, this.fieldPath, new Object[]{this.maxLength}));
            }
        }
        return !this.hasErrors();
    }

    private boolean isWhitelisted(String id) {
        String regex = "[a-zA-Z0-9_\\-\\.]+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(id);
        return matcher.matches();
    }
}

