/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Attribute;
import com.pingidentity.admin.api.model.GroupAttribute;
import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.translator.plugin.PluginEnum;
import com.pingidentity.admin.api.validator.AttributeContractValidator;
import com.pingidentity.admin.api.validator.PluginInstanceValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.sdk.IdentityStoreProvisionerDescriptor;
import com.pingidentity.sdk.provision.IdentityStoreProvisioner;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.impl.PluginSupport;

public class IdentityStoreProvisionerValidator
extends PluginInstanceValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final com.pingidentity.admin.api.model.plugin.IdentityStoreProvisioner apiProvisioner;
    private final String parentPath;

    public IdentityStoreProvisionerValidator(com.pingidentity.admin.api.model.plugin.IdentityStoreProvisioner apiInstance, boolean isCreate, ValidatorContext validatorContext) {
        this(apiInstance, isCreate, "", validatorContext);
    }

    public IdentityStoreProvisionerValidator(com.pingidentity.admin.api.model.plugin.IdentityStoreProvisioner apiInstance, boolean isCreate, String parentPath, ValidatorContext validatorContext) {
        super(apiInstance, PluginEnum.IDENTITY_STORE_PROVISIONER.getPluginManager(), isCreate, PluginEnum.IDENTITY_STORE_PROVISIONER, validatorContext);
        this.parentPath = parentPath;
        this.apiProvisioner = apiInstance;
    }

    @Override
    public boolean validate() {
        super.validate();
        if (this.isAttributeContractValidationRequired()) {
            this.doAttributeContractValidation();
        }
        if (this.isGroupAttributeContractValidationRequired()) {
            this.doGroupAttributeContractValidation();
        }
        return !this.hasErrors();
    }

    boolean isIdentityStoreProvisionerSupportGroups(IdentityStoreProvisionerDescriptor descriptor) {
        if (descriptor != null) {
            PluginSupport pluginSupport = new PluginSupport();
            String className = descriptor.getPluginClassName();
            IdentityStoreProvisioner provisioner = (IdentityStoreProvisioner)pluginSupport.createInstance(className, IdentityStoreProvisioner.class);
            return provisioner != null && provisioner.isGroupProvisioningSupported();
        }
        return false;
    }

    private boolean isAttributeContractValidationRequired() {
        boolean isValidationRequired;
        boolean hasParent = this.apiProvisioner.getParentRef() != null;
        boolean isInherited = this.getBooleanVal(this.apiProvisioner.getAttributeContract().isInherited());
        boolean bl = isValidationRequired = !isInherited || !hasParent;
        if (!hasParent && isInherited) {
            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_attribute_contract_parent_not_defined, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.AttributeContractPaths.getContractInherited())));
        }
        return isValidationRequired;
    }

    private void doAttributeContractValidation() {
        IdentityStoreProvisionerDescriptor pluginDescriptor;
        boolean pluginAllowsExtAttrs = true;
        Object coreAttrs = new HashSet();
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        String pluginTypeId = null;
        if (this.apiProvisioner.getPluginDescriptorRef() != null) {
            pluginTypeId = this.apiProvisioner.getPluginDescriptorRef().getId();
        }
        if (pluginTypeId != null && (pluginDescriptor = this.getIdentityStoreProvisionerDescriptor(pluginTypeId)) != null) {
            Set descriptorAttrs = pluginDescriptor.getAttributeContractSet();
            if (descriptorAttrs != null) {
                coreAttrs = descriptorAttrs;
            }
            pluginAllowsExtAttrs = pluginDescriptor.isSupportsExtendedContract();
        }
        int i = 0;
        for (Attribute coreAttr : this.apiProvisioner.getAttributeContract().getCoreAttributes()) {
            attributes.add(coreAttr);
            if (!StringUtils.isNotBlank((String)coreAttr.getName()) || coreAttrs.contains(coreAttr.getName())) continue;
            this.appendError(this.errorFactory.create(ApiMessageKey.attribute_contract_unknown_core_attribute, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.AttributeContractPaths.getCoreContractAttribute(i++)), new Object[]{coreAttr.getName()}));
        }
        List<Attribute> extendedAttrs = this.apiProvisioner.getAttributeContract().getExtendedAttributes();
        if (!pluginAllowsExtAttrs && extendedAttrs != null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_descriptor_ext_attrs_not_supported, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.AttributeContractPaths.getExtendedContractAttributes())));
        }
        AttributeContractValidator<Attribute> attributeContractValidator = new AttributeContractValidator<Attribute>(attributes, extendedAttrs, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.AttributeContractPaths.getAttributeContract()));
        attributeContractValidator.validate();
        this.appendErrors(attributeContractValidator.getErrors());
    }

    boolean isGroupAttributeContractValidationRequired() {
        boolean isValidationRequried;
        boolean hasParent = this.apiProvisioner.getParentRef() != null;
        boolean isInherited = this.getBooleanVal(this.apiProvisioner.getGroupAttributeContract().isInherited());
        boolean isProvisionerTypeSupportGroups = false;
        boolean bl = isValidationRequried = !isInherited || !hasParent;
        if (!hasParent && isInherited) {
            this.appendError(this.errorFactory.create(ApiMessageKey.identity_store_provisioner_group_attribute_contract_parent_not_defined, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.AttributeContractPaths.getContractInherited())));
        }
        if (this.apiProvisioner.getPluginDescriptorRef() != null) {
            String pluginTypeId = this.apiProvisioner.getPluginDescriptorRef().getId();
            IdentityStoreProvisionerDescriptor descriptor = this.getIdentityStoreProvisionerDescriptor(pluginTypeId);
            isProvisionerTypeSupportGroups = this.isIdentityStoreProvisionerSupportGroups(descriptor);
        }
        return isValidationRequried && isProvisionerTypeSupportGroups;
    }

    IdentityStoreProvisionerDescriptor getIdentityStoreProvisionerDescriptor(String pluginTypeId) {
        return this.pluginManager.getInstalledDescriptors().stream().filter(descriptor -> descriptor.getPluginClassName().equals(pluginTypeId)).findFirst().orElse(null);
    }

    void doGroupAttributeContractValidation() {
        IdentityStoreProvisionerDescriptor pluginDescriptor;
        boolean pluginAllowsExtGrpAttrs = true;
        Object coreGrpAttrs = new HashSet();
        LinkedList<GroupAttribute> grpAttrs = new LinkedList<GroupAttribute>();
        String pluginTypeId = null;
        if (this.apiProvisioner.getPluginDescriptorRef() != null) {
            pluginTypeId = this.apiProvisioner.getPluginDescriptorRef().getId();
        }
        if (pluginTypeId != null && (pluginDescriptor = this.getIdentityStoreProvisionerDescriptor(pluginTypeId)) != null) {
            Set descriptorGrpAttrs = pluginDescriptor.getGroupAttributeContractSet();
            if (descriptorGrpAttrs != null) {
                coreGrpAttrs = descriptorGrpAttrs;
            }
            pluginAllowsExtGrpAttrs = pluginDescriptor.isSupportsExtendedGroupContract();
        }
        int i = 0;
        for (GroupAttribute coreGrpAttr : this.apiProvisioner.getGroupAttributeContract().getCoreAttributes()) {
            grpAttrs.add(coreGrpAttr);
            if (!StringUtils.isNotBlank((String)coreGrpAttr.getName()) || coreGrpAttrs.contains(coreGrpAttr.getName())) continue;
            this.appendError(this.errorFactory.create(ApiMessageKey.identity_store_provisioner_group_attribute_contract_unknown_core_attribute, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.GroupAttributeContractPaths.getCoreContractAttribute(i++)), new Object[]{coreGrpAttr.getName()}));
        }
        List<GroupAttribute> extendedGrpAttrs = this.apiProvisioner.getGroupAttributeContract().getExtendedAttributes();
        if (!pluginAllowsExtGrpAttrs && extendedGrpAttrs != null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.plugin_descriptor_ext_attrs_not_supported, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.GroupAttributeContractPaths.getExtendedContractAttributes())));
        }
        AttributeContractValidator<GroupAttribute> attributeContractValidator = new AttributeContractValidator<GroupAttribute>(grpAttrs, extendedGrpAttrs, this.appendFieldPath(this.getParentPath(), PluginInstancePaths.GroupAttributeContractPaths.getGroupAttributeContract()));
        attributeContractValidator.validate();
        this.appendErrors(attributeContractValidator.getErrors());
    }

    @Override
    protected String getParentPath() {
        return this.parentPath;
    }
}

