/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.access.ExtendedPropertyAccessor;
import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.IdpAdapterContractMapping;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.IdpAdapterMappingPaths;
import com.pingidentity.admin.api.model.fieldpaths.IdpAdapterPaths;
import com.pingidentity.admin.api.model.plugin.IdpAdapter;
import com.pingidentity.admin.api.model.plugin.IdpAdapterAttribute;
import com.pingidentity.admin.api.translator.plugin.PluginEnum;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.IdpAdapterAttributeFulfillmentValidator;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class IdpAdapterAttributeMappingValidator
extends BaseAttributeDataSourceValidator {
    private final IdpAdapter idpAdapter;
    private final IdpAdapterContractMapping mapping;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();

    public IdpAdapterAttributeMappingValidator(IdpAdapter idpAdapter, ValidatorContext context) {
        this(idpAdapter, "", context);
    }

    public IdpAdapterAttributeMappingValidator(IdpAdapter idpAdapter, String parentPath, ValidatorContext context) {
        super(context);
        this.idpAdapter = idpAdapter;
        this.mapping = idpAdapter.getAttributeMapping();
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        rootSources.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.TEXT), this.createTextValBuilder());
        rootSources.put(new SourceTypeIdKey(SourceType.ADAPTER), this.createAdapterTypeBuilder(idpAdapter));
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            rootSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
        }
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        validSources.putAll(rootSources);
        if (this.mapping.getAttributeSources() != null && this.mapping.getAttributeSources().size() > 1) {
            int index = 0;
            for (AttributeSource attributeSource : this.mapping.getAttributeSources()) {
                this.addValidator((Validator)new NotBlankValidator(attributeSource.getId(), "Attribute Source ID", this.appendFieldPath(parentPath, IdpAdapterPaths.getAttributeSourceId(index))));
                ++index;
            }
        }
        this.mapDataStoreTypesToDsValidators(this.mapping, validSources);
        Set<String> allAttributeNames = this.getAllAttributeNames(idpAdapter);
        HashSet<String> substitutionVars = new HashSet<String>(allAttributeNames);
        Map extendedPropertyMap = new ExtendedPropertyAccessor().getExtendedPropertyDefinitions();
        if (!extendedPropertyMap.isEmpty()) {
            ExtendedMetadataSourceTypeValidatorBuilder extendedPropertiesValidatorBuilder = new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES);
            validSources.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES), extendedPropertiesValidatorBuilder);
            substitutionVars.addAll(extendedPropertiesValidatorBuilder.getExposedSubstitutionVariables());
        }
        if (idpAdapter.getAttributeMapping().isInherited() == null || !idpAdapter.getAttributeMapping().isInherited().booleanValue()) {
            this.addValidator((Validator)new IdpAdapterAttributeFulfillmentValidator(this.mapping, allAttributeNames, substitutionVars, "idp adapter", validSources, this.appendFieldPath(parentPath, IdpAdapterPaths.getAttributeMapping()), this.getContext()));
        }
    }

    @Override
    public boolean validate() {
        if ((this.idpAdapter.getAttributeContract().isInherited() == null || !this.idpAdapter.getAttributeContract().isInherited().booleanValue()) && this.idpAdapter.getAttributeMapping().isInherited() != null && this.idpAdapter.getAttributeMapping().isInherited().booleanValue()) {
            this.appendError(this.errorFactory.create(ApiMessageKey.attribute_mapping_required_contract_not_inherited, IdpAdapterMappingPaths.getAttributeMappingInherited()));
        }
        return super.validate();
    }

    private Set<String> getAllAttributeNames(IdpAdapter idpAdapter) {
        HashSet<String> allowedAttributeNames = new HashSet<String>();
        IdpAuthnAdapterDescriptor descriptor = this.getIdpAdapterDescriptor(idpAdapter);
        if (descriptor != null) {
            if (idpAdapter.getAttributeContract() != null && idpAdapter.getAttributeContract().isInherited() != null && idpAdapter.getAttributeContract().isInherited().booleanValue()) {
                return this.getEffectiveAttributes(idpAdapter, descriptor);
            }
            allowedAttributeNames.addAll(this.getCoreAttributes(descriptor));
            if (descriptor.isSupportsExtendedContract()) {
                List<Object> apiList = Collections.emptyList();
                if (idpAdapter.getAttributeContract().getExtendedAttributes() != null) {
                    apiList = idpAdapter.getAttributeContract().getExtendedAttributes();
                }
                ArrayList extendedAttributesList = new ArrayList(apiList);
                for (IdpAdapterAttribute extendedAttribute : extendedAttributesList) {
                    allowedAttributeNames.add(extendedAttribute.getName());
                }
            }
        }
        return allowedAttributeNames;
    }

    private Set<String> getEffectiveAttributes(IdpAdapter idpAdapter, IdpAuthnAdapterDescriptor descriptor) {
        HashSet<String> effectiveAttributes = new HashSet<String>();
        IdpAuthnAdapterInstance domain = new IdpAuthnAdapterInstance();
        domain.setParentId(idpAdapter.getParentRef().getId());
        AttributeContract contract = ConfigurationUtil.findEffectiveAttributeContract((ConfigurablePluginInstance)domain, this.getCoreAttributes(descriptor));
        effectiveAttributes.addAll(contract.getAllAttributeNames());
        effectiveAttributes.addAll(contract.getImmutableAttributeNames());
        return effectiveAttributes;
    }

    private Set<String> getCoreAttributes(IdpAuthnAdapterDescriptor pluginDescriptor) {
        if (pluginDescriptor != null) {
            return new HashSet<String>(new ArrayList(pluginDescriptor.getAttributeContractSet()));
        }
        return Collections.emptySet();
    }

    private IdpAuthnAdapterDescriptor getIdpAdapterDescriptor(IdpAdapter idpAdapter) {
        PluginManager<?, ?> pluginManager = PluginEnum.IDP_ADAPTER.getPluginManager();
        String pluginTypeId = idpAdapter.getPluginDescriptorRef().getId();
        for (IdpAuthnAdapterDescriptor pluginDescriptor : pluginManager.getInstalledDescriptors()) {
            if (!pluginDescriptor.getPluginClassName().equals(pluginTypeId)) continue;
            return pluginDescriptor;
        }
        return null;
    }

    private ContextSourceTypeValidatorBuilder createContextTypeBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForPluginContracts());
        return builder;
    }

    private TextSourceTypeValidatorBuilder createTextValBuilder() {
        TextSourceTypeValidatorBuilder textValBuilder = new TextSourceTypeValidatorBuilder();
        textValBuilder.setAcceptBlankValues(false);
        return textValBuilder;
    }

    private AttributeSetSourceTypeValidatorBuilder createAdapterTypeBuilder(IdpAdapter idpAdapter) {
        HashSet<String> srcNames = new HashSet<String>(this.getAllAttributeNames(idpAdapter));
        return new AttributeSetSourceTypeValidatorBuilder(srcNames, SourceType.ADAPTER);
    }
}

