/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.AttributeMapping;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.IdpAdapterAssertionMapping;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.SpBrowserSso;
import com.pingidentity.admin.api.model.SpBrowserSsoAttributeContract;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.plugin.IdpAdapter;
import com.pingidentity.admin.api.model.plugin.IdpAdapterAttribute;
import com.pingidentity.admin.api.model.plugin.IdpAdapterAttributeContract;
import com.pingidentity.admin.api.translator.plugin.PluginEnum;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.AuthenticationSourceMappingsValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.FailSafeAttributeValidator;
import com.pingidentity.admin.api.validator.IdpAdapterAttributeMappingValidator;
import com.pingidentity.admin.api.validator.IdpAdapterValidator;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.PluginExistsValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class IdpAdapterMappingsValidator
extends AuthenticationSourceMappingsValidator {
    public IdpAdapterMappingsValidator(SpBrowserSso browserSso, List<String> availableVirtualServerIds, ValidatorContext context) {
        super(browserSso, availableVirtualServerIds, context);
        List<IdpAdapterAssertionMapping> mappings = browserSso.getAdapterMappings();
        if (mappings.isEmpty() && browserSso.getAuthenticationPolicyContractAssertionMappings().isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_source_mappings_empty, ConnectionPaths.getAuthenticationSourceMappingsPath()));
        }
        UniqueEntriesValidator.UniqueKeyGetter<IdpAdapterAssertionMapping> idpAdapterRefKeyGetter = new UniqueEntriesValidator.UniqueKeyGetter<IdpAdapterAssertionMapping>(){

            @Override
            public String getKey(IdpAdapterAssertionMapping object) {
                if (object.hasAdapterOverride()) {
                    if (object.getAdapterOverrideSettings().getParentRef() != null && object.getAdapterOverrideSettings().getParentRef().getId() != null) {
                        return object.getAdapterOverrideSettings().getParentRef().getId().toLowerCase();
                    }
                } else if (object.getIdpAdapterRef() != null && object.getIdpAdapterRef().getId() != null) {
                    return object.getIdpAdapterRef().getId().toLowerCase();
                }
                return null;
            }
        };
        this.addValidator((Validator)new UniqueEntriesValidator<IdpAdapterAssertionMapping>(idpAdapterRefKeyGetter, mappings, ConnectionPaths.getIdpAdapterMappingsPath(), ApiMessageKey.idp_adapter_mappings_duplicate_mappings));
        this.setIdpAdapterMappingValidators(browserSso, context);
    }

    IdpAdapterMappingsValidator(SpBrowserSso browserSso) {
        this(browserSso, Collections.emptyList(), new ValidatorContext());
    }

    private void setIdpAdapterMappingValidators(SpBrowserSso browserSso, ValidatorContext validatorContext) {
        List<IdpAdapterAssertionMapping> mappings = browserSso.getAdapterMappings();
        int mappingIndex = 0;
        for (IdpAdapterAssertionMapping mapping : mappings) {
            HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
            rootSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
            rootSources.put(new SourceTypeIdKey(SourceType.TEXT), IdpAdapterMappingsValidator.createTextValBuilder());
            rootSources.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeBuilder());
            rootSources.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES), new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES));
            ExpressionManager expressionManager = ExpressionManager.getInstance();
            if (expressionManager.isEvaluateExpressionsOn()) {
                rootSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
            }
            HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
            validSources.putAll(rootSources);
            validSources.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeBuilder());
            ResourceLink idpAdapterRef = mapping.getIdpAdapterRef();
            String adapterRefFieldName = "IdP Adapter reference";
            boolean hasAdapterOverride = mapping.hasAdapterOverride();
            IdpAdapter overrideAdapter = null;
            if (hasAdapterOverride) {
                overrideAdapter = mapping.getAdapterOverrideSettings();
                if (overrideAdapter.getParentRef() != null) {
                    idpAdapterRef = overrideAdapter.getParentRef();
                    this.setOverrideAdapterWithParentAdapterInfo(overrideAdapter);
                    overrideAdapter.setId("");
                    this.addValidator((Validator)new IdpAdapterValidator(overrideAdapter, false, true, ConnectionPaths.getIdpAdapterMappingAttributeAdapterOverrideSettings(mappingIndex), validatorContext));
                    if (overrideAdapter.getAttributeMapping() != null) {
                        this.addValidator((Validator)new IdpAdapterAttributeMappingValidator(overrideAdapter, ConnectionPaths.getIdpAdapterMappingAttributeAdapterOverrideSettings(mappingIndex), this.getContext()));
                    }
                }
                adapterRefFieldName = "Adapter Override's Parent IdP Adapter reference";
                this.addValidator((Validator)new ResourceIdValidator(idpAdapterRef, adapterRefFieldName, ConnectionPaths.getIdpAdapterOverrideSettingsParentRefPath(mappingIndex)));
            } else {
                this.addValidator((Validator)new ResourceIdValidator(idpAdapterRef, adapterRefFieldName, ConnectionPaths.getIdpAdapterMappingAdapterLinkPath(mappingIndex)));
                if (idpAdapterRef != null) {
                    this.addValidator((Validator)new PluginExistsValidator((PluginManager<?, ?>)MgmtFactory.getIdpAdapterManager(), idpAdapterRef.getId(), ConnectionPaths.getIdpAdapterMappingAdapterLinkIdPath(mappingIndex), ApiMessageKey.idp_adapter_not_found, true));
                }
            }
            HashSet<String> adapterContract = new HashSet();
            if (idpAdapterRef != null && idpAdapterRef.getId() != null) {
                String adapterId = idpAdapterRef.getId();
                adapterContract = this.getAttributeContractFromAdapter(hasAdapterOverride ? overrideAdapter.getAttributeContract() : null, adapterId);
                AttributeSetSourceTypeValidatorBuilder attributeSourceTypeValidatorBuilder = new AttributeSetSourceTypeValidatorBuilder(adapterContract, SourceType.ADAPTER);
                validSources.put(new SourceTypeIdKey(SourceType.ADAPTER), attributeSourceTypeValidatorBuilder);
                rootSources.put(new SourceTypeIdKey(SourceType.ADAPTER), attributeSourceTypeValidatorBuilder);
            }
            String adapterMappingPath = ConnectionPaths.getIdpAdapterMappingsPath(mappingIndex);
            AttributeSetSourceTypeValidatorBuilder assertionSourceTypeBuilder = this.createAssertionValBuilder(browserSso);
            HashSet<String> sourceSubstitutionAttrs = new HashSet<String>();
            if (!adapterContract.isEmpty()) {
                sourceSubstitutionAttrs.addAll(adapterContract);
            }
            HashMap<String, HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>> validSourcesForAttributeSources = new HashMap<String, HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>>();
            for (AttributeSource source : mapping.getAttributeSources()) {
                HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> types = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
                if (source == null || source.getAttributeContractFulfillment() == null) continue;
                types.putAll(rootSources);
                this.mapDataStoreTypeToDsValidator(source, types);
                validSourcesForAttributeSources.put(source.getDataStoreRef().getId(), types);
            }
            if (!this.isSourceContainsFulfillment(mapping.getAttributeSources())) {
                this.mapDataStoreTypesToDsValidators(mapping, validSources);
            }
            this.addValidator((Validator)new AttributeMappingValidator(mapping, assertionSourceTypeBuilder.getAssertionAttributes(), sourceSubstitutionAttrs, "assertion", validSources, validSourcesForAttributeSources, adapterMappingPath, this.getContext()){

                @Override
                public boolean doValidateAttrSourceId(AttributeMapping mapping) {
                    return mapping.getAttributeSources().size() > 1 && !IdpAdapterMappingsValidator.this.isSourceContainsFulfillment(mapping.getAttributeSources());
                }
            });
            this.validateAttrSourceAttrContractFulfillments(mapping.getAttributeSources(), adapterMappingPath);
            if (mapping.isAbortSsoTransactionAsFailSafe()) {
                this.addValidator((Validator)new FailSafeAttributeValidator(mapping.isAbortSsoTransactionAsFailSafe(), mapping.getAttributeSources(), mapping.getIssuanceCriteria(), mapping.getAttributeContractFulfillment(), ConnectionPaths.getIdpAdapterMappingAbortSsoPath(mappingIndex)));
            }
            ++mappingIndex;
        }
    }

    private void setOverrideAdapterWithParentAdapterInfo(IdpAdapter overrideAdapter) {
        ResourceLink parentAdapterRef = overrideAdapter.getParentRef();
        IdpAuthnAdapterInstance parentAdapter = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(parentAdapterRef.getId());
        if (parentAdapter != null) {
            String typeId = parentAdapter.getDescriptor().getPluginClassName();
            String pluginDescriptorUrl = ApiUtil.getResourceUrl(PluginEnum.IDP_ADAPTER.getDescriptorsResourcePath(), typeId);
            overrideAdapter.setPluginDescriptorRef(new ResourceLink(typeId, pluginDescriptorUrl));
            overrideAdapter.setName(parentAdapter.getName() + " (with override)");
        } else {
            overrideAdapter.setPluginDescriptorRef(new ResourceLink("", ""));
            overrideAdapter.setName("");
        }
    }

    private Set<String> getAttributeContractFromAdapter(IdpAdapterAttributeContract adapterOverrideAttributeContract, String adapterId) {
        AuthnAdapterInstance idpAdapter;
        Set<String> adapterContract = new HashSet<String>();
        if (adapterOverrideAttributeContract != null) {
            LinkedList<IdpAdapterAttribute> allAttributesList = new LinkedList<IdpAdapterAttribute>();
            allAttributesList.addAll(adapterOverrideAttributeContract.getCoreAttributes());
            List<IdpAdapterAttribute> extendedAttributesList = adapterOverrideAttributeContract.getExtendedAttributes();
            if (extendedAttributesList != null) {
                allAttributesList.addAll(extendedAttributesList);
            }
            adapterContract = allAttributesList.stream().map(n -> n.getName()).collect(Collectors.toSet());
        } else if (StringUtils.isNotBlank((String)adapterId) && (idpAdapter = (AuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(adapterId)) != null) {
            adapterContract.addAll(idpAdapter.getAttributeContract().getAllAttributeNames());
        }
        return adapterContract;
    }

    @Override
    public boolean validate() {
        super.validate();
        return this.validateIdpAdapterMappings();
    }

    boolean validateIdpAdapterMappings() {
        boolean noVsidErrorFound = false;
        int mappingIndex = 0;
        for (IdpAdapterAssertionMapping adapterMapping : this.browserSso.getAdapterMappings()) {
            int vsidIndex = 0;
            if (adapterMapping.isRestrictVirtualEntityIds() && this.availableVirtualServerIds.isEmpty() && !noVsidErrorFound) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.restricted_virtual_entity_id_not_required, ConnectionPaths.getIdpAdapterMappingRestrictedVirtualEntityIdPath(mappingIndex)));
                noVsidErrorFound = true;
            } else if (!adapterMapping.isRestrictVirtualEntityIds() && !adapterMapping.getRestrictedVirtualEntityIds().isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.restricted_virtual_entity_ids_not_allowed, ConnectionPaths.getIdpAdapterMappingRestrictedVirtualEntityIdPath(mappingIndex)));
            } else if (adapterMapping.isRestrictVirtualEntityIds() && adapterMapping.getRestrictedVirtualEntityIds().isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.restricted_virtual_entity_ids_required, ConnectionPaths.getSpAdapterMappingRestrictedVirtualEntityIdPath(mappingIndex)));
            } else {
                ArrayList<String> seenEntityIds = new ArrayList<String>(adapterMapping.getRestrictedVirtualEntityIds().size());
                for (String virtualEntityId : adapterMapping.getRestrictedVirtualEntityIds()) {
                    String virtualEntityPath = ConnectionPaths.getIdpAdapterMappingRestrictedVirtualEntityIdPath(mappingIndex, vsidIndex);
                    if (seenEntityIds.contains(virtualEntityId)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.restricted_virtual_entity_id_duplicate, virtualEntityPath, new Object[]{virtualEntityId}));
                    } else if (!this.availableVirtualServerIds.contains(virtualEntityId)) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_value_invalid_virtual_entity_id, virtualEntityPath, new Object[]{virtualEntityId}));
                    }
                    seenEntityIds.add(virtualEntityId);
                }
            }
            if (adapterMapping.hasAdapterOverride() && adapterMapping.getIdpAdapterRef() != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_has_idp_adapter_ref_and_override_parent_ref, ConnectionPaths.getIdpAdapterMappingAdapterLinkPath(mappingIndex)));
            }
            if (!adapterMapping.isAbortSsoTransactionAsFailSafe()) {
                SpBrowserSsoAttributeContract attributeContract = this.browserSso.getAttributeContract();
                Map<String, AttributeFulfillmentValue> attributeContractFulfillment = adapterMapping.getAttributeContractFulfillment();
                this.validateContractFulfillmentWhenContractExists(mappingIndex, attributeContract, attributeContractFulfillment);
            }
            ++mappingIndex;
        }
        return !this.hasErrors();
    }

    private void validateContractFulfillmentWhenContractExists(int mappingIndex, SpBrowserSsoAttributeContract attributeContract, Map<String, AttributeFulfillmentValue> attributeContractFulfillment) {
        if (attributeContract != null && !attributeContract.isEmpty() && (attributeContractFulfillment == null || attributeContractFulfillment.isEmpty())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.attribute_mapping_attribute_contract_must_be_fulfilled, ConnectionPaths.getIdpAdapterMappingContractFulfillmentPath(mappingIndex)));
        }
    }

    @Override
    protected ContextSourceTypeValidatorBuilder createContextTypeBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForSpBrowserSSOWithAdapters());
        return builder;
    }
}

