/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ConnectionType;
import com.pingidentity.admin.api.model.IdpBrowserSso;
import com.pingidentity.admin.api.model.IdpBrowserSsoAttribute;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.Profile;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.ArtifactValidator;
import com.pingidentity.admin.api.validator.AttributeContractValidator;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.AuthenticationPolicyContractMappingsValidator;
import com.pingidentity.admin.api.validator.AuthnContextMappingValidator;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.EnabledProfilesValidator;
import com.pingidentity.admin.api.validator.HttpUrlValidator;
import com.pingidentity.admin.api.validator.IdpConnOAuthValidator;
import com.pingidentity.admin.api.validator.IdpSsoServiceEndpointsValidator;
import com.pingidentity.admin.api.validator.IncomingBindingsValidator;
import com.pingidentity.admin.api.validator.JitProvisioningValidator;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.OIDCClientCredentialValidator;
import com.pingidentity.admin.api.validator.OIDCProviderValidator;
import com.pingidentity.admin.api.validator.ProtocolMessageCustomizationsValidator;
import com.pingidentity.admin.api.validator.SloServiceEndpointValidator;
import com.pingidentity.admin.api.validator.SpAdapterMappingsValidator;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.UrlWhiteListValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.AssertionAttributeContract;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.Protocol;

public class IdpBrowserSsoValidator
extends BaseAttributeDataSourceValidator {
    private IdpConnection connection;
    private com.pingidentity.admin.api.model.Protocol protocol;
    private Role role;

    public IdpBrowserSsoValidator(IdpConnection connection, ConnectionBase existingConnection, ValidatorContext context) {
        super(context);
        boolean hasBrowserSso = connection.getIdpBrowserSso() != null;
        this.connection = connection;
        this.role = connection.getType().getRole();
        if (hasBrowserSso) {
            boolean isOidc = connection.getIdpBrowserSso().getProtocol() == com.pingidentity.admin.api.model.Protocol.OIDC;
            IdpBrowserSso browserSso = connection.getIdpBrowserSso();
            this.protocol = browserSso.getProtocol();
            if ((browserSso.getProtocol() == com.pingidentity.admin.api.model.Protocol.WSFED || isOidc) && browserSso.getEnabledProfiles() != null && browserSso.getEnabledProfiles().size() > 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getEnabledProfilesPropertyPath(this.role), new Object[]{ConnectionPaths.getEnabledProfilesPropertyPath(this.role)}));
            }
            if ((browserSso.getProtocol() == com.pingidentity.admin.api.model.Protocol.WSFED || isOidc) && browserSso.getIncomingBindings() != null && browserSso.getIncomingBindings().size() > 0) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getIncomingBindingsPropertyPath(this.role), new Object[]{ConnectionPaths.getIncomingBindingsPropertyPath(this.role)}));
            }
            if (browserSso.getProtocol() != com.pingidentity.admin.api.model.Protocol.WSFED && !isOidc) {
                this.addValidator((Validator)new EnabledProfilesValidator(connection));
                this.addValidator((Validator)new IncomingBindingsValidator(connection));
            }
            this.addValidator((Validator)new AuthnContextMappingValidator(connection.getIdpBrowserSso().getAuthnContextMappings(), this.protocol));
            this.addValidator((Validator)new IdpSsoServiceEndpointsValidator(connection));
            this.addValidator((Validator)new ProtocolMessageCustomizationsValidator(browserSso.getMessageCustomizations(), connection.getType(), this.protocol, context));
            this.addValidator((Validator)new HttpUrlValidator(browserSso.getDefaultTargetUrl(), true, ConnectionPaths.getDefaultTargetUrlPath(connection.getType().getRole())));
            this.addValidator((Validator)new NotNullValidator((Object)browserSso.getIdpIdentityMapping(), "Identity Mapping", ConnectionPaths.getIdpIdentityMappingPath()));
            this.addValidator((Validator)new ArtifactValidator(connection, connection.getIdpBrowserSso()));
            SloServiceEndpointValidator validator = new SloServiceEndpointValidator(connection.getIdpBrowserSso().getSloServiceEndpoints(), connection.getIdpBrowserSso().getEnabledProfiles() != null && (connection.getIdpBrowserSso().getEnabledProfiles().contains((Object)Profile.SP_INITIATED_SLO) || connection.getIdpBrowserSso().getEnabledProfiles().contains((Object)Profile.IDP_INITIATED_SLO)), connection.getBaseUrl() != null, connection.getType().getRole(), this.protocol);
            this.addValidator((Validator)validator);
            LinkedList<IdpBrowserSsoAttribute> assertionAttrs = new LinkedList<IdpBrowserSsoAttribute>();
            AssertionAttributeContract attributeContract = null;
            attributeContract = isOidc ? new AssertionAttributeContract(false, false, Protocol.OIDC) : new AssertionAttributeContract();
            for (String immutableAttr : attributeContract.getImmutableAttributeNames()) {
                IdpBrowserSsoAttribute attr = new IdpBrowserSsoAttribute();
                attr.setName(immutableAttr);
                assertionAttrs.add(attr);
            }
            List<IdpBrowserSsoAttribute> extendedAssertionAttrs = browserSso.getAttributeContract().getExtendedAttributes();
            this.addValidator((Validator)new AttributeContractValidator<IdpBrowserSsoAttribute>(assertionAttrs, extendedAssertionAttrs, ConnectionPaths.getBrowserSsoAttrContractPath(Role.IDP)));
            this.addValidator((Validator)new SpAdapterMappingsValidator(browserSso, connection.getVirtualEntityIds(), this.getContext()));
            AuthenticationPolicyContractMappingsValidator apcMappingsValidator = new AuthenticationPolicyContractMappingsValidator(browserSso, connection.getVirtualEntityIds(), MgmtFactory.getC2cContractManager(), this.getContext());
            this.addValidator((Validator)apcMappingsValidator);
            if (browserSso.getProtocol() == com.pingidentity.admin.api.model.Protocol.WSFED) {
                this.addValidator((Validator)new UrlWhiteListValidator(browserSso.getUrlWhitelistEntries(), ConnectionType.IDP));
            }
            this.addValidator((Validator)new IdpConnOAuthValidator(browserSso, apcMappingsValidator.getMappedApcIds(), this.getContext()));
            this.addValidator((Validator)new OIDCProviderValidator(connection, this.getContext()));
            this.addValidator((Validator)new OIDCClientCredentialValidator(connection));
            this.addValidator((Validator)new JitProvisioningValidator(connection, MgmtFactory.getDataSourceManager(), this.getContext()));
        }
    }

    protected static AttributeSetSourceTypeValidatorBuilder createAssertionValBuilder(IdpBrowserSso browserSso) {
        SourceType sourceType;
        AssertionAttributeContract domainAssertionContract;
        HashSet<String> assertionAttributes = new HashSet<String>();
        boolean isOidcConnection = browserSso.getProtocol() == com.pingidentity.admin.api.model.Protocol.OIDC;
        List<IdpBrowserSsoAttribute> extendedAttributes = browserSso.getAttributeContract().getExtendedAttributes();
        if (isOidcConnection) {
            domainAssertionContract = new AssertionAttributeContract(false, false, Protocol.OIDC);
            sourceType = SourceType.CLAIMS;
        } else {
            domainAssertionContract = new AssertionAttributeContract();
            sourceType = SourceType.ASSERTION;
        }
        assertionAttributes.addAll(domainAssertionContract.getImmutableAttributeNames());
        IdpBrowserSsoValidator.addAttributes(assertionAttributes, extendedAttributes);
        return new AttributeSetSourceTypeValidatorBuilder(assertionAttributes, sourceType);
    }

    private static void addAttributes(Set<String> assertionAttributes, List<IdpBrowserSsoAttribute> extendedAttributes) {
        for (IdpBrowserSsoAttribute attribute : extendedAttributes) {
            if (attribute.getName() == null) continue;
            assertionAttributes.add(attribute.getName());
        }
    }

    protected static ContextSourceTypeValidatorBuilder createContextTypeBuilder(IdpBrowserSso browserSso) {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        if (browserSso.getProtocol() != null) {
            builder.setContextSources(SourceContextType.getProtocolDependentContextTypesForIdpBrowserSSO((Protocol)Protocol.valueOf((String)browserSso.getProtocol().name())));
        } else {
            builder.setContextSources(SourceContextType.getContextTypesForIdpBrowserSSO());
        }
        return builder;
    }

    protected static TextSourceTypeValidatorBuilder createTextValBuilder() {
        TextSourceTypeValidatorBuilder textValBuilder = new TextSourceTypeValidatorBuilder();
        textValBuilder.setAcceptBlankValues(false);
        return textValBuilder;
    }

    protected static ContextSourceTypeValidatorBuilder createContextTypesForOAuthWebRedirectFlowBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForOAuthWebRedirectFlowMapping());
        return builder;
    }

    @Override
    public boolean validate() {
        boolean result = true;
        IdpBrowserSso browserSso = this.connection.getIdpBrowserSso();
        if (browserSso == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.browser_sso_required, ConnectionPaths.getBrowserSsoPropertyName(this.role)));
            return false;
        }
        if (this.protocol == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.browser_sso_protocol_null, ConnectionPaths.getBrowserSsoProtocolPath(this.role)));
            result = false;
        } else if (this.protocol == com.pingidentity.admin.api.model.Protocol.OIDC) {
            if (browserSso.isSignAuthnRequests() != null && browserSso.isSignAuthnRequests().booleanValue()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getIdpSsoSignAuthnRequests(), new Object[]{ConnectionPaths.getIdpSsoSignAuthnRequests()}));
                result = false;
            }
            if (browserSso.getUrlWhitelistEntries() != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getUrlWhiteListEntries(Role.IDP, 0), new Object[]{ConnectionPaths.getUrlWhiteListEntries(Role.IDP, 0)}));
                result = false;
            }
            if (browserSso.isAssertionsSigned() != null && browserSso.isAssertionsSigned().booleanValue()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getIdpAssertionsSigned(), new Object[]{ConnectionPaths.getIdpAssertionsSigned()}));
                result = false;
            }
            if (browserSso.isAlwaysSignArtifactResponse() != null && browserSso.isAlwaysSignArtifactResponse().booleanValue()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getAlwaysSignArtifactResponse(this.role), new Object[]{ConnectionPaths.getAlwaysSignArtifactResponse(this.role)}));
                result = false;
            }
            if (browserSso.getDecryptionPolicy() != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getDecryptionPolicy(), new Object[]{ConnectionPaths.getDecryptionPolicy()}));
                result = false;
            }
            if (this.connection.getCredentials() != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getCredentials(), new Object[]{ConnectionPaths.getCredentials()}));
                result = false;
            }
        }
        boolean parentResult = super.validate();
        return result && parentResult;
    }
}

