/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.IdpBrowserSso;
import com.pingidentity.admin.api.model.IdpIdentityMapping;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.SsoOAuthMapping;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AccountLinkSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExtendedMetadataSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.IdpBrowserSsoValidator;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.OnlyOneAttributeSourceValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;

public class IdpConnOAuthValidator
extends BaseAttributeDataSourceValidator {
    private String oauthApcId;
    private SsoOAuthMapping oauthMapping;
    private Set<String> validApcIds;

    public IdpConnOAuthValidator(IdpBrowserSso browserSso, Set<String> validApcIds, ValidatorContext context) {
        super(context);
        this.oauthApcId = browserSso.getOAuthAuthenticationPolicyContractRef() != null ? browserSso.getOAuthAuthenticationPolicyContractRef().getId() : null;
        this.oauthMapping = browserSso.getSsoOAuthMapping();
        this.validApcIds = validApcIds;
        if (this.oauthMapping != null) {
            HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> rootSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
            AttributeSetSourceTypeValidatorBuilder assertionSourceTypeBuilder = IdpBrowserSsoValidator.createAssertionValBuilder(browserSso);
            if (browserSso.getProtocol() == Protocol.OIDC) {
                rootSources.put(new SourceTypeIdKey(SourceType.CLAIMS), assertionSourceTypeBuilder);
            } else {
                rootSources.put(new SourceTypeIdKey(SourceType.ASSERTION), assertionSourceTypeBuilder);
            }
            rootSources.put(new SourceTypeIdKey(SourceType.CONTEXT), IdpBrowserSsoValidator.createContextTypesForOAuthWebRedirectFlowBuilder());
            rootSources.put(new SourceTypeIdKey(SourceType.EXTENDED_CLIENT_METADATA), new ExtendedMetadataSourceTypeValidatorBuilder());
            rootSources.put(new SourceTypeIdKey(SourceType.EXTENDED_PROPERTIES), new ExtendedMetadataSourceTypeValidatorBuilder(SourceType.EXTENDED_PROPERTIES));
            rootSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
            rootSources.put(new SourceTypeIdKey(SourceType.TEXT), IdpBrowserSsoValidator.createTextValBuilder());
            ExpressionManager expressionManager = ExpressionManager.getInstance();
            if (expressionManager.isEvaluateExpressionsOn()) {
                rootSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
            }
            HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
            validSources.putAll(rootSources);
            validSources.put(new SourceTypeIdKey(SourceType.LDAP_DATA_STORE), this.createDsValBuilder(SourceType.LDAP_DATA_STORE, this.oauthMapping));
            validSources.put(new SourceTypeIdKey(SourceType.JDBC_DATA_STORE), this.createDsValBuilder(SourceType.JDBC_DATA_STORE, this.oauthMapping));
            validSources.put(new SourceTypeIdKey(SourceType.CUSTOM_DATA_STORE), this.createDsValBuilder(SourceType.CUSTOM_DATA_STORE, this.oauthMapping));
            if (browserSso.getIdpIdentityMapping() == IdpIdentityMapping.ACCOUNT_LINKING) {
                AccountLinkSourceTypeValidatorBuilder accountLinkValBuilder = new AccountLinkSourceTypeValidatorBuilder();
                accountLinkValBuilder.setLinkingEnabled(true);
                validSources.put(new SourceTypeIdKey(SourceType.ACCOUNT_LINK), accountLinkValBuilder);
            }
            HashSet<String> validAttributeNames = new HashSet<String>();
            AttributeContract attributeContract = MgmtFactory.getAuthzServerManager().getKeyNameContract();
            if (attributeContract != null) {
                validAttributeNames.addAll(attributeContract.getAllAttributeNames());
            }
            this.addValidator((Validator)new OnlyOneAttributeSourceValidator(this.oauthMapping.getAttributeSources().size(), ApiMessageKey.oauth_attribute_mapping_multiple_attribute_source, ConnectionPaths.getIdpBrowserSsoOAttributeSources()));
            this.addValidator((Validator)new AttributeMappingValidator(this.oauthMapping, validAttributeNames, assertionSourceTypeBuilder.getAssertionAttributes(), "assertion", validSources, "", this.getContext()));
        }
    }

    @Override
    public boolean validate() {
        if (this.oauthApcId == null && this.oauthMapping == null) {
            return true;
        }
        if (this.oauthApcId != null && this.oauthMapping != null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.browser_sso_oauth_only_one_mapping, ConnectionPaths.getBrowserSsoPropertyName(Role.IDP)));
            return false;
        }
        if (this.oauthApcId != null) {
            if (!this.validApcIds.contains(this.oauthApcId)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.authentication_policy_contract_not_found, ConnectionPaths.getIdpBrowserSsoOAuthApcId(), new Object[]{this.oauthApcId}));
                return false;
            }
            return true;
        }
        return super.validate();
    }
}

