/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.IdpBrowserSsoAttribute;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.IdpOAuthAttributeContract;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AccessTokenManagerMappingValidator;
import com.pingidentity.admin.api.validator.AdditionalAllowedEntitiesConfigurationValidator;
import com.pingidentity.admin.api.validator.AttributeContractValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ConnectionBaseValidator;
import com.pingidentity.admin.api.validator.IdpAttributeQueryValidator;
import com.pingidentity.admin.api.validator.IdpBrowserSsoValidator;
import com.pingidentity.admin.api.validator.IdpCredentialsValidator;
import com.pingidentity.admin.api.validator.IdpInboundProvisioningValidator;
import com.pingidentity.admin.api.validator.IdpWsTrustValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.ValidatorRegistry;
import java.util.LinkedList;
import java.util.List;
import org.sourceid.saml20.domain.AssertionAttributeContract;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.metadata.Role;

public class IdpConnectionValidator
extends CompositeValidator {
    public IdpConnectionValidator(ConnectionBase existingConn, IdpConnection connection, ValidatorRegistry validatorRegistry, boolean fullValidationPath, ValidatorContext context) {
        Protocol protocol = null;
        boolean isUpdate = context.isUpdateRequest();
        if (connection.getBrowserSso() == null && connection.getAttributeQuery() == null && connection.getIdpOAuthGrantAttributeMapping() == null && connection.getWsTrust() == null && connection.getInboundProvisioning() == null) {
            String browserSsoAttributeQueryPaths = ConnectionPaths.getBrowserSsoPropertyName(Role.IDP) + ", " + ConnectionPaths.getAttributeQuery() + ", " + ConnectionPaths.getIdpOAuthGrantAttributeMapping() + ", " + ConnectionPaths.getWsTrust() + ", " + ConnectionPaths.getInboundProvisioning();
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.browser_sso_or_attribute_query_or_oauth_grant_or_ws_trust_or_inbound_provisioning_required, browserSsoAttributeQueryPaths));
            return;
        }
        ConnectionBaseValidator connectionBaseValidator = new ConnectionBaseValidator(isUpdate, existingConn, connection);
        connectionBaseValidator.checkIdpConnectionIdDuplicate();
        this.addValidator((Validator)connectionBaseValidator);
        if (connection.getBrowserSso() != null) {
            protocol = connection.getBrowserSso().getProtocol();
            this.addValidator((Validator)new IdpBrowserSsoValidator(connection, existingConn, context));
        }
        if (connection.getIdpOAuthGrantAttributeMapping() != null) {
            this.addIdpOAuthAttributeContractValidators(connection);
            this.addValidator((Validator)new AccessTokenManagerMappingValidator(connection.getIdpOAuthGrantAttributeMapping(), context));
        }
        this.addValidator((Validator)new IdpAttributeQueryValidator(connection));
        this.addValidator((Validator)new IdpWsTrustValidator(connection, context));
        this.addValidator((Validator)new IdpInboundProvisioningValidator(connection, context));
        if (protocol != Protocol.OIDC) {
            this.addValidator((Validator)new IdpCredentialsValidator(isUpdate, existingConn, connection, validatorRegistry, fullValidationPath));
        }
        this.addValidator((Validator)new AdditionalAllowedEntitiesConfigurationValidator(connection));
    }

    private void addIdpOAuthAttributeContractValidators(IdpConnection connection) {
        IdpOAuthAttributeContract idpOAuthAttributeContract = connection.getIdpOAuthGrantAttributeMapping().getIdpOAuthAttributeContract();
        List<IdpBrowserSsoAttribute> assertionAttrs = this.getIdpBrowserSsoAttributes();
        List<IdpBrowserSsoAttribute> extendedAssertionAttrs = idpOAuthAttributeContract.getExtendedAttributes();
        this.addValidator((Validator)new AttributeContractValidator<IdpBrowserSsoAttribute>(assertionAttrs, extendedAssertionAttrs, ConnectionPaths.getOAuthAttrContractPath(Role.IDP)));
    }

    private List<IdpBrowserSsoAttribute> getIdpBrowserSsoAttributes() {
        LinkedList<IdpBrowserSsoAttribute> assertionAttrs = new LinkedList<IdpBrowserSsoAttribute>();
        for (String immutableAttr : new AssertionAttributeContract().getImmutableAttributeNames()) {
            IdpBrowserSsoAttribute attr = new IdpBrowserSsoAttribute();
            attr.setName(immutableAttr);
            assertionAttrs.add(attr);
        }
        return assertionAttrs;
    }
}

