/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.DecryptionPolicy;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.Profile;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AbstractDecryptionKeyPairValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;

public class IdpDecryptionKeyPairValidator
extends AbstractDecryptionKeyPairValidator {
    private final IdpConnection idpConnection;
    private DecryptionPolicy policy;

    public IdpDecryptionKeyPairValidator(IdpConnection connection, boolean fullValidationPath) {
        super(connection.getCredentials(), fullValidationPath);
        this.idpConnection = connection;
    }

    @Override
    public boolean validate() {
        if (this.isDecryptionAvailable()) {
            String path;
            this.policy = this.idpConnection.getIdpBrowserSso().getDecryptionPolicy();
            if (!this.isDecryptionRequired()) {
                String path2;
                if (this.policy.isSloEncryptSubjectNameID()) {
                    path2 = ConnectionPaths.getDecryptionPolicySloEncryptSubject();
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, path2, new Object[]{path2}));
                }
                if (this.policy.isSloSubjectNameIDEncrypted()) {
                    path2 = ConnectionPaths.getDecryptionPolicySloSubjectEncrypted();
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, path2, new Object[]{path2}));
                }
                return super.validate();
            }
            if (this.policy.isAssertionEncrypted() && this.isWsFed()) {
                path = ConnectionPaths.getDecryptionPolicyAssertionEncrypted();
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, path, new Object[]{path}));
            }
            if ((!this.idpConnection.getBrowserSso().isProfileSelected(Profile.SP_INITIATED_SLO) || !this.policy.isAssertionEncrypted() && !this.policy.isSubjectNameIdEncrypted()) && this.policy.isSloEncryptSubjectNameID()) {
                path = ConnectionPaths.getDecryptionPolicySloEncryptSubject();
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, path, new Object[]{path}));
            }
            if ((!this.idpConnection.getBrowserSso().isProfileSelected(Profile.IDP_INITIATED_SLO) || !this.policy.isAssertionEncrypted() && !this.policy.isSubjectNameIdEncrypted()) && this.policy.isSloSubjectNameIDEncrypted()) {
                path = ConnectionPaths.getDecryptionPolicySloSubjectEncrypted();
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, path, new Object[]{path}));
            }
        }
        return super.validate();
    }

    private boolean isDecryptionAvailable() {
        return this.idpConnection.isBrowserSsoSaml2() || this.isWsFed();
    }

    private boolean isWsFed() {
        return this.idpConnection.getIdpBrowserSso() != null && Protocol.WSFED == this.idpConnection.getIdpBrowserSso().getProtocol();
    }

    @Override
    protected boolean isDecryptionRequired() {
        boolean required = false;
        if (this.isDecryptionAvailable()) {
            required = this.policy.isAssertionEncrypted() || this.policy.isAttributesEncrypted() || this.policy.isSubjectNameIdEncrypted();
        }
        return required | this.isAttributeQueryDecryptionRequired();
    }

    private boolean isAttributeQueryDecryptionRequired() {
        if (this.idpConnection.getAttributeQuery() != null) {
            return this.idpConnection.getAttributeQuery().getPolicy().isRequireEncryptedAssertion();
        }
        return false;
    }
}

