/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.IdpDefaultUrlPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;

public class IdpDefaultUrlValidator
extends AbstractValidator {
    private String idpSloSuccessUrl;
    private String idpErrMsg;

    public IdpDefaultUrlValidator(Builder builder) {
        this.idpSloSuccessUrl = builder.idpSloSuccessUrl;
        this.idpErrMsg = builder.idpErrMsg;
    }

    public boolean validate() {
        if (!StringUtils.isBlank((String)this.idpSloSuccessUrl) && !ValidationUtil.isValidHttpOrHttpsUrl((String)this.idpSloSuccessUrl)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.idp_default_url_invalid_successful_slo_url, IdpDefaultUrlPaths.getIdpSloSuccessUrl()));
        }
        if (StringUtils.isBlank((String)this.idpErrMsg)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.idp_default_url_err_msg_required, IdpDefaultUrlPaths.getIdpErrMsg()));
        }
        return !this.hasErrors();
    }

    public static class Builder {
        private String idpSloSuccessUrl;
        private String idpErrMsg;

        public Builder setIdpSloSuccessUrl(String idpSloSuccessUrl) {
            this.idpSloSuccessUrl = idpSloSuccessUrl;
            return this;
        }

        public Builder setIdpErrMsg(String idpErrMsg) {
            this.idpErrMsg = idpErrMsg;
            return this;
        }

        public IdpDefaultUrlValidator build() {
            return new IdpDefaultUrlValidator(this);
        }
    }
}

