/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.DecryptionPolicy;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.Profile;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.EncryptionSettingsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class IdpEncryptionValidator
extends EncryptionSettingsValidator {
    private DecryptionPolicy policy;
    private final IdpConnection connection;
    private boolean attributeQueryEncryption;

    public IdpEncryptionValidator(IdpConnection connection, boolean fullValidationPath) {
        super(connection.getCredentials(), fullValidationPath);
        this.connection = connection;
        if (connection.isBrowserSsoSaml2()) {
            this.policy = connection.getIdpBrowserSso().getDecryptionPolicy();
        }
        if (connection.getAttributeQuery() != null) {
            this.attributeQueryEncryption = connection.getAttributeQuery().getPolicy().isEncryptNameId();
        }
    }

    @Override
    public boolean validate() {
        if (this.connection.isBrowserSsoSaml2()) {
            if (!this.policy.isAssertionEncrypted() && !this.policy.isSubjectNameIdEncrypted()) {
                String path;
                if (this.policy.isSloEncryptSubjectNameID()) {
                    path = ConnectionPaths.getDecryptionPolicySloEncryptSubject();
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, path, new Object[]{path}));
                }
                if (this.policy.isSloSubjectNameIDEncrypted()) {
                    path = ConnectionPaths.getDecryptionPolicySloSubjectEncrypted();
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, path, new Object[]{path}));
                }
                if (this.hasErrors()) {
                    return false;
                }
            }
            this.handleDecryptionPolicyNotRequired();
        } else if (this.isWsFed() && this.policy != null && this.policy.isAssertionEncrypted()) {
            String path = ConnectionPaths.getDecryptionPolicyAssertionEncrypted();
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, path, new Object[]{path}));
        }
        return super.validate();
    }

    private void handleDecryptionPolicyNotRequired() {
        String path;
        if (this.policy.isSloEncryptSubjectNameID() && (this.connection.getIdpBrowserSso().getEnabledProfiles() == null || !this.connection.getIdpBrowserSso().getEnabledProfiles().contains((Object)Profile.SP_INITIATED_SLO)) || this.isWsFed()) {
            path = ConnectionPaths.getDecryptionPolicySloEncryptSubject();
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, path, new Object[]{path}));
        }
        if (this.policy.isSloSubjectNameIDEncrypted() && (this.connection.getIdpBrowserSso().getEnabledProfiles() == null || !this.connection.getIdpBrowserSso().getEnabledProfiles().contains((Object)Profile.IDP_INITIATED_SLO) || this.isWsFed())) {
            path = ConnectionPaths.getDecryptionPolicySloSubjectEncrypted();
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, path, new Object[]{path}));
        }
    }

    @Override
    boolean isEncryptionRequired() {
        return this.connection.isBrowserSsoSaml2() && this.policy.isSloEncryptSubjectNameID() || this.attributeQueryEncryption;
    }

    @Override
    boolean isExistingRSA() {
        org.sourceid.saml20.domain.IdpConnection idpConn = MgmtFactory.getConnectionManager().getIdpConnection(this.connection.getId());
        if (idpConn != null) {
            return "http://www.w3.org/2001/04/xmlenc#rsa-1_5".equals(idpConn.getEncryptionSettings().getEncryptionPolicy().getKeyTransportAlgorithm());
        }
        return false;
    }

    private boolean isWsFed() {
        if (this.connection.getBrowserSso() == null) {
            return false;
        }
        return Protocol.WSFED == this.connection.getBrowserSso().getProtocol();
    }
}

