/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Attribute;
import com.pingidentity.admin.api.model.AttributeFulfillmentValue;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.SchemaAttribute;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.sso.idp.IdpInboundProvisioning;
import com.pingidentity.admin.api.model.sso.idp.IdpInboundProvisioningAttributeContract;
import com.pingidentity.admin.api.model.sso.idp.InboundProvisioningUserRepositoryType;
import com.pingidentity.admin.api.model.sso.idp.LdapInboundProvisioningUserRepository;
import com.pingidentity.admin.api.model.sso.idp.ReadGroups;
import com.pingidentity.admin.api.model.sso.idp.ReadUsers;
import com.pingidentity.admin.api.model.sso.idp.Scim2SchemaAttribute;
import com.pingidentity.admin.api.model.sso.idp.Scim2SchemaSubAttribute;
import com.pingidentity.admin.api.model.sso.idp.WriteGroups;
import com.pingidentity.admin.api.model.sso.idp.WriteUsers;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.DsSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.IdpInboundProvisioningReadAttributeContractValidator;
import com.pingidentity.admin.api.validator.InboundProvisioningCustomScim2AttributeValidator;
import com.pingidentity.admin.api.validator.InboundProvisioningCustomScimAttributeValidator;
import com.pingidentity.admin.api.validator.InboundProvisioningScim2ServiceProviderConfigValidator;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NotNullValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.UserRepositoryAttributeFulfillmentValidator;
import com.pingidentity.admin.api.validator.UserRepositoryValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sourceid.saml20.domain.GroupConstants;
import org.sourceid.saml20.domain.ScimUserConstants;
import org.sourceid.saml20.domain.ScimUserConstantsFactory;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.scim.ScimVersion;
import org.sourceid.saml20.domain.scim.util.CustomAttributesUtil;

public class IdpInboundProvisioningValidator
extends CompositeValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private final IdpInboundProvisioning inboundProvisioning;
    private final ValidatorContext context;
    private ScimVersion scimVersion = ScimVersion.SCIM11;
    private final ScimUserConstants userConstants;

    public IdpInboundProvisioningValidator(IdpConnection connection, ValidatorContext context) {
        boolean hasInboundProvisioning;
        this.context = context;
        this.inboundProvisioning = connection.getInboundProvisioning();
        boolean bl = hasInboundProvisioning = connection.getInboundProvisioning() != null;
        if (hasInboundProvisioning && this.inboundProvisioning.getUserRepository() != null && InboundProvisioningUserRepositoryType.LDAP.equals((Object)this.inboundProvisioning.getUserRepository().getType())) {
            this.addValidator((Validator)new NotNullValidator((Object)this.inboundProvisioning.getActionOnDelete(), "Scim Delete Users Behavior", ConnectionPaths.InboundProvisionPaths.getScimDeleteUsersBehavior()));
        }
        if (this.inboundProvisioning != null && this.inboundProvisioning.getScimVersion() != null) {
            this.scimVersion = this.inboundProvisioning.getScimVersion().getCorrespondingDomainScimVersion();
        }
        this.userConstants = ScimUserConstantsFactory.getScimUserConstants((ScimVersion)this.scimVersion);
    }

    @Override
    public boolean validate() {
        boolean isValid = super.validate();
        if (isValid) {
            if (this.inboundProvisioning == null) {
                return true;
            }
            if (!MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableInboundProvisioning()) {
                this.appendError(this.errorFactory.create(ApiMessageKey.inbound_provisioning_not_enabled, ConnectionPaths.getInboundProvisioning()));
                return false;
            }
            if (this.inboundProvisioning.getUserRepository() == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.inbound_provisioning_user_repository_required, ConnectionPaths.InboundProvisionPaths.getUserRepository()));
                return false;
            }
            this.validateUserRepository();
            if (this.inboundProvisioning.getCustomSchema() != null) {
                this.validateCustomSchema();
            }
            if (this.inboundProvisioning.getCustomScim2Schema() != null) {
                this.validateCustomScim2Schema();
            }
            if (this.inboundProvisioning.getServiceProviderConfig() != null) {
                this.validateScim2ServiceProviderConfig();
            }
            if (this.inboundProvisioning.getUsers() == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.inbound_provisioning_users_required, ConnectionPaths.InboundProvisionPaths.getUsers()));
                return false;
            }
            this.validateUsers();
            if (this.inboundProvisioning.isGroupSupport()) {
                if (com.pingidentity.admin.api.model.ScimVersion.SCIM20.equals((Object)this.inboundProvisioning.getScimVersion())) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.inbound_provisioning_groups_not_supported_in_scim2, ConnectionPaths.InboundProvisionPaths.getGroupSupport()));
                } else {
                    if (this.inboundProvisioning.getGroups() == null) {
                        this.appendError(this.errorFactory.create(ApiMessageKey.inbound_provisioning_groups_required, ConnectionPaths.InboundProvisionPaths.getGroups()));
                        return false;
                    }
                    this.validateGroups();
                }
            }
        }
        return !this.hasErrors();
    }

    private void validateUserRepository() {
        List availableUserVars = this.userConstants.getAllMappableIdsForWriteUsers();
        List availableGroupVars = GroupConstants.getAllMappableIdsForWriteGroups();
        Validator validator = UserRepositoryValidator.getInstance(this.inboundProvisioning.getUserRepository(), availableUserVars, availableGroupVars, this.inboundProvisioning.isGroupSupport(), this.context);
        if (validator == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.inbound_provisioning_user_repository_unsupported, ConnectionPaths.InboundProvisionPaths.getUserRepository(), new Object[]{this.inboundProvisioning.getUserRepository()}));
        } else {
            validator.validate();
            this.appendErrors(validator.getErrors());
        }
    }

    private void validateCustomSchema() {
        if (!com.pingidentity.admin.api.model.ScimVersion.SCIM11.equals((Object)this.inboundProvisioning.getScimVersion())) {
            this.appendError(this.errorFactory.create(ApiMessageKey.provisioning_wrong_version_for_custom_schema, ConnectionPaths.InboundProvisionPaths.getScimVersion(), new Object[]{ConnectionPaths.InboundProvisionPaths.getCustomSchema(), com.pingidentity.admin.api.model.ScimVersion.SCIM11.name()}));
        }
        if (this.inboundProvisioning.getCustomSchema().getAttributes() == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.field_required, ConnectionPaths.InboundProvisionPaths.getCustomSchemaAttribute(), new Object[]{ConnectionPaths.InboundProvisionPaths.getCustomSchemaAttribute()}));
        } else {
            HashSet<String> attributeNames = new HashSet<String>();
            int index = 0;
            for (SchemaAttribute attribute : this.inboundProvisioning.getCustomSchema().getAttributes()) {
                if (attributeNames.contains(attribute.getName())) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.provisioning_custom_attr_name_exists, ConnectionPaths.InboundProvisionPaths.getCustomSchema(), new Object[]{attribute.getName()}));
                } else {
                    InboundProvisioningCustomScimAttributeValidator validator = new InboundProvisioningCustomScimAttributeValidator(this.inboundProvisioning.getCustomSchema().getNamespace(), attribute, new ArrayList<String>(), ConnectionPaths.InboundProvisionPaths.getCustomSchemaAttribute(index));
                    validator.validate();
                    this.appendErrors(validator.getErrors());
                    attributeNames.add(attribute.getName());
                }
                ++index;
            }
        }
    }

    private void validateCustomScim2Schema() {
        if (!com.pingidentity.admin.api.model.ScimVersion.SCIM20.equals((Object)this.inboundProvisioning.getScimVersion())) {
            this.appendError(this.errorFactory.create(ApiMessageKey.provisioning_wrong_version_for_custom_schema, ConnectionPaths.InboundProvisionPaths.getScimVersion(), new Object[]{ConnectionPaths.InboundProvisionPaths.getCustomScim2Schema(), com.pingidentity.admin.api.model.ScimVersion.SCIM20.name()}));
        }
        if (this.inboundProvisioning.getCustomScim2Schema().getAttributes() == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.field_required, ConnectionPaths.InboundProvisionPaths.getCustomScim2SchemaAttribute(), new Object[]{ConnectionPaths.InboundProvisionPaths.getCustomScim2SchemaAttribute()}));
        } else {
            HashSet<String> attributeNames = new HashSet<String>();
            int index = 0;
            for (Scim2SchemaAttribute attribute : this.inboundProvisioning.getCustomScim2Schema().getAttributes()) {
                if (attributeNames.contains(attribute.getName())) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.provisioning_custom_attr_name_exists, ConnectionPaths.InboundProvisionPaths.getCustomScim2Schema(), new Object[]{attribute.getName()}));
                } else {
                    InboundProvisioningCustomScim2AttributeValidator validator = new InboundProvisioningCustomScim2AttributeValidator(this.inboundProvisioning.getCustomScim2Schema().getNamespace(), attribute, ConnectionPaths.InboundProvisionPaths.getCustomSchemaAttribute(index));
                    validator.validate();
                    this.appendErrors(validator.getErrors());
                    attributeNames.add(attribute.getName());
                }
                ++index;
            }
        }
    }

    private void validateScim2ServiceProviderConfig() {
        if (!com.pingidentity.admin.api.model.ScimVersion.SCIM20.equals((Object)this.inboundProvisioning.getScimVersion())) {
            this.appendError(this.errorFactory.create(ApiMessageKey.provisioning_wrong_version_for_service_provider_config, ConnectionPaths.InboundProvisionPaths.getScimVersion(), new Object[]{com.pingidentity.admin.api.model.ScimVersion.SCIM20.name()}));
        } else {
            InboundProvisioningScim2ServiceProviderConfigValidator validator = new InboundProvisioningScim2ServiceProviderConfigValidator(this.inboundProvisioning.getServiceProviderConfig().getDocumentationUri());
            validator.validate();
            this.appendErrors(validator.getErrors());
        }
    }

    private void validateUsers() {
        this.validateWriteUsers();
        this.validateReadUsers();
    }

    private void validateWriteUsers() {
        WriteUsers writeUsers = this.inboundProvisioning.getUsers().getWriteUsers();
        if (writeUsers == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.inbound_provisioning_write_users_required, ConnectionPaths.InboundProvisionPaths.getWriteUsers()));
            return;
        }
        if (writeUsers.getAttributeFulfillment() != null && !writeUsers.getAttributeFulfillment().isEmpty()) {
            UserRepositoryAttributeFulfillmentValidator validator = new UserRepositoryAttributeFulfillmentValidator(this.inboundProvisioning.getUsers().getWriteUsers().getAttributeFulfillment(), this.getWriteUsersValidSourceTypes(), this.getWriteUsersValidSources(), ConnectionPaths.InboundProvisionPaths.getWriteUsersAttributeFulfillment(), this.context);
            validator.validate();
            this.appendErrors(validator.getErrors());
        } else {
            this.appendError(this.errorFactory.create(ApiMessageKey.inbound_provisioning_write_users_attribute_fulfillment_required, ConnectionPaths.InboundProvisionPaths.getWriteUsersAttributeFulfillment()));
        }
    }

    private void validateReadUsers() {
        ReadUsers readUsers = this.inboundProvisioning.getUsers().getReadUsers();
        WriteUsers writeUSers = this.inboundProvisioning.getUsers().getWriteUsers();
        if (readUsers == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.inbound_provisioning_read_users_required, ConnectionPaths.InboundProvisionPaths.getReadUsers()));
            return;
        }
        this.validateAttributeContract(readUsers);
        this.validateAttributeFulfillment(readUsers);
        this.validateAttributeContractFulfillment(writeUSers, readUsers);
    }

    void validateAttributeContractFulfillment(WriteUsers writeUsers, ReadUsers readUsers) {
        HashSet expectedAttributes = new HashSet();
        if (writeUsers != null) {
            ((Collection)Optional.of(writeUsers).map(WriteUsers::getAttributeFulfillment).map(Map::values).orElse(Collections.emptyList())).stream().filter(val -> SourceType.SCIM_USER.equals((Object)val.getSource().getType())).map(AttributeFulfillmentValue::getValue).forEach(expectedAttributes::add);
        }
        Optional.ofNullable(readUsers).map(ReadUsers::getAttributeContract).ifPresent(attributeContract -> {
            attributeContract.getCoreAttributes().stream().map(Attribute::getName).forEach(expectedAttributes::add);
            attributeContract.getExtendedAttributes().stream().map(Attribute::getName).forEach(expectedAttributes::add);
        });
        Map contractFulfillmentMap = Optional.ofNullable(readUsers).map(ReadUsers::getAttributeFulfillment).orElse(Collections.emptyMap());
        for (String attrName : expectedAttributes) {
            if (attrName == null || contractFulfillmentMap.containsKey(attrName)) continue;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.inbound_provisioning_read_users_attribute_fulfillment_missing_attribute, ConnectionPaths.InboundProvisionPaths.getReadUsersAttributeFulfillment(), new Object[]{attrName}));
        }
    }

    private void validateAttributeContract(ReadUsers readUsers) {
        IdpInboundProvisioningAttributeContract attributeContract = readUsers.getAttributeContract();
        if (attributeContract != null) {
            if (attributeContract.getExtendedAttributes() != null && !attributeContract.getExtendedAttributes().isEmpty()) {
                for (Attribute attribute : attributeContract.getExtendedAttributes()) {
                    List<String> allowedAttributes = this.getReadUsersAllowedAttributes();
                    if (allowedAttributes.isEmpty() || allowedAttributes.contains(attribute.getName())) continue;
                    this.appendError(this.errorFactory.create(ApiMessageKey.inbound_provisioning_unsupported_attribute, ConnectionPaths.InboundProvisionPaths.getReadUsersAttributeContract(), new Object[]{attribute.getName()}));
                }
            }
            IdpInboundProvisioningReadAttributeContractValidator attributeContractValidator = new IdpInboundProvisioningReadAttributeContractValidator(attributeContract.getCoreAttributes(), attributeContract.getExtendedAttributes(), ConnectionPaths.InboundProvisionPaths.getReadUsersAttributeContract());
            attributeContractValidator.validate();
            this.appendErrors(attributeContractValidator.getErrors());
        }
    }

    private void validateAttributeFulfillment(ReadUsers readUsers) {
        if (readUsers.getAttributeFulfillment() != null && !readUsers.getAttributeFulfillment().isEmpty()) {
            UserRepositoryAttributeFulfillmentValidator attributeFulfillmentValidator = null;
            switch (this.inboundProvisioning.getUserRepository().getType()) {
                case LDAP: {
                    attributeFulfillmentValidator = new UserRepositoryAttributeFulfillmentValidator(readUsers.getAttributeFulfillment(), this.getReadUsersLdapValidSourceTypes(), this.getLdapValidSources(readUsers), ConnectionPaths.InboundProvisionPaths.getReadUsersAttributeFulfillment(), this.context);
                    attributeFulfillmentValidator.validate();
                    this.appendErrors(attributeFulfillmentValidator.getErrors());
                    break;
                }
                case IDENTITY_STORE: {
                    attributeFulfillmentValidator = new UserRepositoryAttributeFulfillmentValidator(readUsers.getAttributeFulfillment(), this.getReadUsersIspValidSourceTypes(), this.getIspValidSources(this.inboundProvisioning.getUsers().getWriteUsers()), ConnectionPaths.InboundProvisionPaths.getReadUsersAttributeFulfillment(), this.context);
                    attributeFulfillmentValidator.validate();
                    this.appendErrors(attributeFulfillmentValidator.getErrors());
                    break;
                }
            }
        } else {
            this.appendError(this.errorFactory.create(ApiMessageKey.inbound_provisioning_read_users_attribute_fulfillment_required, ConnectionPaths.InboundProvisionPaths.getReadUsersAttributeFulfillment()));
        }
    }

    private List<String> getReadUsersAllowedAttributes() {
        ArrayList<String> allAllowedIds = new ArrayList<String>(this.userConstants.getAllIdsForReadUsers());
        allAllowedIds.addAll(this.getCustomSchemaAttributes());
        return allAllowedIds;
    }

    private void validateGroups() {
        this.validateWriteGroups();
        this.validateReadGroups();
    }

    private void validateWriteGroups() {
        WriteGroups writeGroups = this.inboundProvisioning.getGroups().getWriteGroups();
        if (writeGroups == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.inbound_provisioning_write_groups_required, ConnectionPaths.InboundProvisionPaths.getWriteGroups()));
            return;
        }
        if (writeGroups.getAttributeFulfillment() != null && !writeGroups.getAttributeFulfillment().isEmpty()) {
            UserRepositoryAttributeFulfillmentValidator validator = new UserRepositoryAttributeFulfillmentValidator(this.inboundProvisioning.getGroups().getWriteGroups().getAttributeFulfillment(), this.getWriteGroupsValidSourceTypes(), this.getWriteGroupsValidSources(), ConnectionPaths.InboundProvisionPaths.getWriteGroupsAttributeFulfillment(), this.context);
            validator.validate();
            this.appendErrors(validator.getErrors());
        } else {
            this.appendError(this.errorFactory.create(ApiMessageKey.inbound_provisioning_write_groups_attribute_fulfillment_required, ConnectionPaths.InboundProvisionPaths.getWriteGroupsAttributeFulfillment()));
        }
    }

    private void validateReadGroups() {
        ReadGroups readGroups = this.inboundProvisioning.getGroups().getReadGroups();
        if (readGroups == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.inbound_provisioning_read_groups_required, ConnectionPaths.InboundProvisionPaths.getReadGroups()));
            return;
        }
        this.validateAttributeContract(readGroups);
        this.validateAttributeFulfillment(readGroups);
    }

    private void validateAttributeContract(ReadGroups readGroups) {
        IdpInboundProvisioningAttributeContract attributeContract = readGroups.getAttributeContract();
        if (attributeContract != null) {
            if (attributeContract.getExtendedAttributes() != null && !attributeContract.getExtendedAttributes().isEmpty()) {
                for (Attribute attribute : attributeContract.getExtendedAttributes()) {
                    List<String> allowedAttributes = this.getReadGroupsAllowedAttributes();
                    if (allowedAttributes.isEmpty() || allowedAttributes.contains(attribute.getName())) continue;
                    this.appendError(this.errorFactory.create(ApiMessageKey.inbound_provisioning_unsupported_attribute, ConnectionPaths.InboundProvisionPaths.getReadGroupsAttributeContract(), new Object[]{attribute.getName()}));
                }
            }
            IdpInboundProvisioningReadAttributeContractValidator attributeContractValidator = new IdpInboundProvisioningReadAttributeContractValidator(attributeContract.getCoreAttributes(), attributeContract.getExtendedAttributes(), ConnectionPaths.InboundProvisionPaths.getReadGroupsAttributeContract());
            attributeContractValidator.validate();
            this.appendErrors(attributeContractValidator.getErrors());
        }
    }

    private void validateAttributeFulfillment(ReadGroups readGroups) {
        if (readGroups.getAttributeFulfillment() != null && !readGroups.getAttributeFulfillment().isEmpty()) {
            UserRepositoryAttributeFulfillmentValidator attributeFulfillmentValidator = null;
            switch (this.inboundProvisioning.getUserRepository().getType()) {
                case LDAP: {
                    attributeFulfillmentValidator = new UserRepositoryAttributeFulfillmentValidator(readGroups.getAttributeFulfillment(), this.getReadGroupsLdapValidSourceTypes(), this.getLdapValidSources(readGroups), ConnectionPaths.InboundProvisionPaths.getReadGroupsAttributeFulfillment(), this.context);
                    attributeFulfillmentValidator.validate();
                    this.appendErrors(attributeFulfillmentValidator.getErrors());
                    break;
                }
                case IDENTITY_STORE: {
                    attributeFulfillmentValidator = new UserRepositoryAttributeFulfillmentValidator(readGroups.getAttributeFulfillment(), this.getReadGroupsIspValidSourceTypes(), this.getIspValidSources(this.inboundProvisioning.getGroups().getWriteGroups()), ConnectionPaths.InboundProvisionPaths.getReadGroupsAttributeFulfillment(), this.context);
                    attributeFulfillmentValidator.validate();
                    this.appendErrors(attributeFulfillmentValidator.getErrors());
                    break;
                }
            }
        } else {
            this.appendError(this.errorFactory.create(ApiMessageKey.inbound_provisioning_read_groups_attribute_fulfillment_required, ConnectionPaths.InboundProvisionPaths.getReadGroupsAttributeFulfillment()));
        }
    }

    private List<String> getReadGroupsAllowedAttributes() {
        return GroupConstants.getAllIdsForReadGroups();
    }

    private Set<SourceType> getDefaultValidSourceTypes() {
        HashSet<SourceType> validSourceTypes = new HashSet<SourceType>();
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            validSourceTypes.add(SourceType.EXPRESSION);
        }
        validSourceTypes.add(SourceType.CONTEXT);
        validSourceTypes.add(SourceType.NO_MAPPING);
        validSourceTypes.add(SourceType.TEXT);
        return validSourceTypes;
    }

    private Set<SourceType> getWriteUsersValidSourceTypes() {
        Set<SourceType> validSourceTypes = this.getDefaultValidSourceTypes();
        validSourceTypes.add(SourceType.SCIM_USER);
        return validSourceTypes;
    }

    private Set<SourceType> getReadUsersLdapValidSourceTypes() {
        Set<SourceType> validSourceTypes = this.getDefaultValidSourceTypes();
        validSourceTypes.add(SourceType.LDAP_DATA_STORE);
        return validSourceTypes;
    }

    private Set<SourceType> getReadUsersIspValidSourceTypes() {
        Set<SourceType> validSourceTypes = this.getDefaultValidSourceTypes();
        validSourceTypes.add(SourceType.IDENTITY_STORE_USER);
        return validSourceTypes;
    }

    private Set<SourceType> getWriteGroupsValidSourceTypes() {
        Set<SourceType> validSourceTypes = this.getDefaultValidSourceTypes();
        validSourceTypes.add(SourceType.SCIM_GROUP);
        return validSourceTypes;
    }

    private Set<SourceType> getReadGroupsLdapValidSourceTypes() {
        Set<SourceType> validSourceTypes = this.getDefaultValidSourceTypes();
        validSourceTypes.add(SourceType.LDAP_DATA_STORE);
        return validSourceTypes;
    }

    private Set<SourceType> getReadGroupsIspValidSourceTypes() {
        Set<SourceType> validSourceTypes = this.getDefaultValidSourceTypes();
        validSourceTypes.add(SourceType.IDENTITY_STORE_GROUP);
        return validSourceTypes;
    }

    private Map<SourceTypeIdKey, SourceTypeValidatorBuilder> getDefaultValidSources() {
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            validSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.context));
        }
        validSources.put(new SourceTypeIdKey(SourceType.CONTEXT), this.createContextTypeBuilder());
        validSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
        validSources.put(new SourceTypeIdKey(SourceType.TEXT), new TextSourceTypeValidatorBuilder());
        return validSources;
    }

    private Map<SourceTypeIdKey, SourceTypeValidatorBuilder> getWriteUsersValidSources() {
        Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = this.getDefaultValidSources();
        List<String> scimUserAttributes = new ArrayList<String>();
        switch (this.inboundProvisioning.getUserRepository().getType()) {
            case LDAP: {
                scimUserAttributes = this.userConstants.getAllMappableIdsForWriteUsers();
                break;
            }
            case IDENTITY_STORE: {
                scimUserAttributes = this.userConstants.getAllMappableIdsForIdentityStorePluginWriteUsers();
            }
        }
        scimUserAttributes.addAll(this.getCustomSchemaAttributes());
        HashSet<String> validWriteScimUserAttributes = new HashSet<String>(scimUserAttributes);
        AttributeSetSourceTypeValidatorBuilder writeScimUserAttributeBuilder = new AttributeSetSourceTypeValidatorBuilder(validWriteScimUserAttributes, SourceType.SCIM_USER);
        validSources.put(new SourceTypeIdKey(SourceType.SCIM_USER), writeScimUserAttributeBuilder);
        return validSources;
    }

    private List<String> getCustomSchemaAttributes() {
        ArrayList<String> customScimAttributes;
        block4: {
            block3: {
                customScimAttributes = new ArrayList<String>();
                if (this.inboundProvisioning.getCustomScim2Schema() == null || this.inboundProvisioning.getCustomScim2Schema().getAttributes() == null) break block3;
                List<Scim2SchemaAttribute> attributes = this.inboundProvisioning.getCustomScim2Schema().getAttributes();
                for (Scim2SchemaAttribute attribute : attributes) {
                    List<Object> subAttributes = new ArrayList();
                    if (attribute.getSubAttributes() != null) {
                        subAttributes = attribute.getSubAttributes().stream().map(Scim2SchemaSubAttribute::getName).collect(Collectors.toList());
                    }
                    customScimAttributes.addAll(CustomAttributesUtil.getCustomAttributeIdsWithDotNotation((String)attribute.getName(), attribute.getCanonicalValues(), subAttributes, (boolean)attribute.isMultiValued()));
                }
                break block4;
            }
            if (this.inboundProvisioning.getCustomSchema() == null || this.inboundProvisioning.getCustomSchema().getAttributes() == null) break block4;
            List<SchemaAttribute> attributes = this.inboundProvisioning.getCustomSchema().getAttributes();
            for (SchemaAttribute attribute : attributes) {
                customScimAttributes.addAll(CustomAttributesUtil.getCustomAttributeIdsWithDotNotation((String)attribute.getName(), attribute.getTypes(), attribute.getSubAttributes(), (boolean)attribute.isMultiValued()));
            }
        }
        return customScimAttributes;
    }

    private Map<SourceTypeIdKey, SourceTypeValidatorBuilder> getLdapValidSources(ReadUsers readUsers) {
        Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = this.getDefaultValidSources();
        Set<String> expectedAttributes = readUsers.getAttributes().stream().map(Attribute::getName).collect(Collectors.toSet());
        validSources.put(new SourceTypeIdKey(SourceType.LDAP_DATA_STORE), this.createLdapTypeBuilder(expectedAttributes));
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            SourceTypeValidatorBuilder builder = validSources.get(new SourceTypeIdKey(SourceType.EXPRESSION));
            Set<String> subVars = readUsers.getAttributes().stream().map(a -> "ds." + a.getName()).collect(Collectors.toSet());
            builder.setSubstitutionVariables(subVars);
        }
        return validSources;
    }

    private Map<SourceTypeIdKey, SourceTypeValidatorBuilder> getIspValidSources(WriteUsers writeUsers) {
        Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = this.getDefaultValidSources();
        Set<String> immutableAttributeNames = writeUsers.getAttributeFulfillment().keySet();
        AttributeSetSourceTypeValidatorBuilder writeIdentityStoreUserAttributeBuilder = new AttributeSetSourceTypeValidatorBuilder(immutableAttributeNames, SourceType.IDENTITY_STORE_USER);
        validSources.put(new SourceTypeIdKey(SourceType.IDENTITY_STORE_USER), writeIdentityStoreUserAttributeBuilder);
        return validSources;
    }

    private Map<SourceTypeIdKey, SourceTypeValidatorBuilder> getWriteGroupsValidSources() {
        Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = this.getDefaultValidSources();
        List scimGroupAttributes = Collections.emptyList();
        switch (this.inboundProvisioning.getUserRepository().getType()) {
            case LDAP: {
                scimGroupAttributes = GroupConstants.getAllMappableIdsForWriteGroups();
                break;
            }
            case IDENTITY_STORE: {
                scimGroupAttributes = GroupConstants.getAllMappableIdsForIdentityStorePluginWriteGroups();
            }
        }
        HashSet<String> validWriteScimGroupAttributes = new HashSet<String>(scimGroupAttributes);
        AttributeSetSourceTypeValidatorBuilder writeScimGroupAttributeBuilder = new AttributeSetSourceTypeValidatorBuilder(validWriteScimGroupAttributes, SourceType.SCIM_GROUP);
        validSources.put(new SourceTypeIdKey(SourceType.SCIM_GROUP), writeScimGroupAttributeBuilder);
        return validSources;
    }

    private Map<SourceTypeIdKey, SourceTypeValidatorBuilder> getLdapValidSources(ReadGroups readGroups) {
        Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = this.getDefaultValidSources();
        Set<String> expectedAttributes = readGroups.getAttributes().stream().map(Attribute::getName).collect(Collectors.toSet());
        validSources.put(new SourceTypeIdKey(SourceType.LDAP_DATA_STORE), this.createLdapTypeBuilder(expectedAttributes));
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            SourceTypeValidatorBuilder builder = validSources.get(new SourceTypeIdKey(SourceType.EXPRESSION));
            Set<String> subVars = readGroups.getAttributes().stream().map(a -> "ds." + a.getName()).collect(Collectors.toSet());
            builder.setSubstitutionVariables(subVars);
        }
        return validSources;
    }

    private Map<SourceTypeIdKey, SourceTypeValidatorBuilder> getIspValidSources(WriteGroups writeGroups) {
        Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = this.getDefaultValidSources();
        Set<String> immutableAttributeNames = writeGroups.getAttributeFulfillment().keySet();
        AttributeSetSourceTypeValidatorBuilder writeIdentityStoreUserAttributeBuilder = new AttributeSetSourceTypeValidatorBuilder(immutableAttributeNames, SourceType.IDENTITY_STORE_GROUP);
        validSources.put(new SourceTypeIdKey(SourceType.IDENTITY_STORE_GROUP), writeIdentityStoreUserAttributeBuilder);
        return validSources;
    }

    private ContextSourceTypeValidatorBuilder createContextTypeBuilder() {
        ContextSourceTypeValidatorBuilder builder = new ContextSourceTypeValidatorBuilder();
        builder.setContextSources(SourceContextType.getContextTypesForInboundProv());
        return builder;
    }

    private SourceTypeValidatorBuilder createLdapTypeBuilder(Set<String> expectedAttributes) {
        DsSourceTypeValidatorBuilder builder = new DsSourceTypeValidatorBuilder(this.context);
        AttributeSource attributeSource = new AttributeSource();
        LdapInboundProvisioningUserRepository userRepository = (LdapInboundProvisioningUserRepository)this.inboundProvisioning.getUserRepository();
        attributeSource.setId(userRepository.getDataStoreRef().getId());
        attributeSource.setDataStoreRef(userRepository.getDataStoreRef());
        builder.setAttributeSource(attributeSource);
        builder.setSourceType(SourceType.LDAP_DATA_STORE);
        builder.setExpectedAttributes(expectedAttributes);
        return builder;
    }
}

