/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.AttributeSource;
import com.pingidentity.admin.api.model.IdpToSpAdapterMapping;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.model.fieldpaths.IdpToSpAdapterMappingPaths;
import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.validator.AttributeMappingValidator;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.BaseAttributeDataSourceValidator;
import com.pingidentity.admin.api.validator.ContextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.ExpressionSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.HttpUrlValidator;
import com.pingidentity.admin.api.validator.NoMappingTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.TextSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class IdpToSpAdapterMappingValidator
extends BaseAttributeDataSourceValidator {
    private IdpToSpAdapterMapping apiInstance;
    private boolean isUpdate;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();

    public IdpToSpAdapterMappingValidator(IdpToSpAdapterMapping apiInstance, boolean isUpdate, ValidatorContext context) {
        super(context);
        this.apiInstance = apiInstance;
        this.isUpdate = isUpdate;
    }

    @Override
    public boolean validate() {
        HttpUrlValidator applicationIconUrlValidator;
        HttpUrlValidator httpValidator;
        Object manager;
        AuthnAdapterInstance targetAdapter;
        IdpAuthnAdapterInstance sourceAdapter = (IdpAuthnAdapterInstance)MgmtFactory.getIdpAdapterManager().getInstance(this.apiInstance.getSourceId());
        if (sourceAdapter == null || !sourceAdapter.getId().equals(this.apiInstance.getSourceId())) {
            this.appendError(this.errorFactory.create(ApiMessageKey.idp_to_sp_adapter_mappings_source_doesnt_exist, PluginInstancePaths.getId(), new Object[]{this.apiInstance.getSourceId()}));
        }
        if ((targetAdapter = (AuthnAdapterInstance)MgmtFactory.getSpAdapterManager().getInstance(this.apiInstance.getTargetId())) == null || !targetAdapter.getId().equals(this.apiInstance.getTargetId())) {
            this.appendError(this.errorFactory.create(ApiMessageKey.idp_to_sp_adapter_mappings_target_doesnt_exist, PluginInstancePaths.getId(), new Object[]{this.apiInstance.getTargetId()}));
        }
        if (this.hasErrors()) {
            return !this.hasErrors();
        }
        if (!this.isUpdate && (manager = MgmtFactory.getAdapter2AdapterManager()).getMapping(this.apiInstance.getSourceId(), this.apiInstance.getTargetId()) != null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.idp_to_sp_adapter_mappings_duplicate_mappings, PluginInstancePaths.getId(), new Object[]{this.apiInstance.getSourceId(), this.apiInstance.getTargetId()}));
        }
        for (String attr : targetAdapter.getAttributeContract().getAllAttributeNames()) {
            if (this.apiInstance.getAttributeContractFulfillment().keySet().contains(attr)) continue;
            this.appendError(this.errorFactory.create(ApiMessageKey.idp_to_sp_adapter_mappings_attr_source_doesnt_exist, PluginInstancePaths.getId(), new Object[]{this.apiInstance.getSourceId(), attr}));
        }
        IdpToSpAdapterMapping mapping = this.apiInstance;
        Set validAttributeNames = targetAdapter.getAttributeContract().getAllAttributeNames();
        HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources = new HashMap<SourceTypeIdKey, SourceTypeValidatorBuilder>();
        AttributeSetSourceTypeValidatorBuilder b = new AttributeSetSourceTypeValidatorBuilder(sourceAdapter.getAttributeContract().getAllAttributeNames(), SourceType.ADAPTER);
        validSources.put(new SourceTypeIdKey(SourceType.ADAPTER), b);
        validSources.put(new SourceTypeIdKey(SourceType.NO_MAPPING), new NoMappingTypeValidatorBuilder());
        validSources.put(new SourceTypeIdKey(SourceType.TEXT), new TextSourceTypeValidatorBuilder());
        int index = 0;
        for (AttributeSource attributeSource : mapping.getAttributeSources()) {
            NotBlankValidator descVal;
            NotBlankValidator idVal = new NotBlankValidator(attributeSource.getId(), "Attribute Source ID", ConnectionPaths.getAttributeSourceIdPath(ConnectionPaths.getAttributeSourcePath(IdpToSpAdapterMappingPaths.getAttributeMapping(), index)));
            if (!idVal.validate()) {
                super.getErrors().addAll(idVal.getErrors());
            }
            if (!(descVal = new NotBlankValidator(attributeSource.getDescription(), "Attribute Source Description", ConnectionPaths.getAttributeSourceDescriptionPath(ConnectionPaths.getAttributeSourcePath(IdpToSpAdapterMappingPaths.getAttributeMapping(), index)))).validate()) {
                super.getErrors().addAll(descVal.getErrors());
            }
            ++index;
        }
        this.mapDataStoreTypesToDsValidators(this.apiInstance, validSources);
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            validSources.put(new SourceTypeIdKey(SourceType.EXPRESSION), new ExpressionSourceTypeValidatorBuilder(this.getContext()));
        }
        ContextSourceTypeValidatorBuilder cstb = new ContextSourceTypeValidatorBuilder();
        cstb.setContextSources(SourceContextType.getContextTypesForA2A());
        validSources.put(new SourceTypeIdKey(SourceType.CONTEXT), cstb);
        AttributeMappingValidator validator = new AttributeMappingValidator(mapping, validAttributeNames, this.getSourceCoreSubstitutionVariables((AuthnAdapterInstance)sourceAdapter), null, validSources, IdpToSpAdapterMappingPaths.getAttributeMapping(), this.getContext());
        if (!validator.validate()) {
            super.getErrors().addAll(validator.getErrors());
        }
        if (!(httpValidator = new HttpUrlValidator(this.apiInstance.getDefaultTargetResource(), true, IdpToSpAdapterMappingPaths.getDefaultTargetResource())).validate()) {
            super.getErrors().addAll(httpValidator.getErrors());
        }
        if (!(applicationIconUrlValidator = new HttpUrlValidator(this.apiInstance.getApplicationIconUrl(), true, IdpToSpAdapterMappingPaths.getApplicationIconUrl())).validate()) {
            super.getErrors().addAll(applicationIconUrlValidator.getErrors());
        }
        return !this.hasErrors();
    }

    private Set<String> getSourceCoreSubstitutionVariables(AuthnAdapterInstance targetAdapter) {
        return new HashSet<String>(targetAdapter.getAttributeContract().getAllAttrNamesSorted());
    }
}

