/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.IdpWsTrustAttribute;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AttributeContractValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.List;
import org.sourceid.saml20.protocol.AssertionMapKeys;

public class IdpWsTrustAttributeContractValidator
extends AttributeContractValidator<IdpWsTrustAttribute> {
    private List<IdpWsTrustAttribute> coreAttributes;
    private List<IdpWsTrustAttribute> extendedAttributes;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();

    IdpWsTrustAttributeContractValidator(List<IdpWsTrustAttribute> coreAttributes, List<IdpWsTrustAttribute> extendedAttributes, String contractFieldPath) {
        super(coreAttributes, extendedAttributes, contractFieldPath);
        this.coreAttributes = coreAttributes;
        this.extendedAttributes = extendedAttributes;
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        if (this.coreAttributes.size() != 1) {
            ValidationError error = this.errorFactory.create(ApiMessageKey.ws_trust_attribute_contract_core_invalid, ConnectionPaths.WsTrustPaths.getAttributeContractCore(), new Object[]{AssertionMapKeys.getGenericNameIdValueKey()});
            this.appendError(error);
        }
        for (IdpWsTrustAttribute coreAttribute : this.coreAttributes) {
            ValidationError error;
            if (!AssertionMapKeys.getGenericNameIdValueKey().equals(coreAttribute.getName())) {
                error = this.errorFactory.create(ApiMessageKey.ws_trust_attribute_contract_core_invalid, ConnectionPaths.WsTrustPaths.getAttributeContractCore(), new Object[]{AssertionMapKeys.getGenericNameIdValueKey()});
                this.appendError(error);
                continue;
            }
            if (!coreAttribute.isMasked().booleanValue()) continue;
            error = this.errorFactory.create(ApiMessageKey.ws_trust_attribute_contract_core_masked, ConnectionPaths.WsTrustPaths.getAttributeContractCore(), new Object[]{AssertionMapKeys.getGenericNameIdValueKey()});
            this.appendError(error);
        }
        int i = 0;
        for (IdpWsTrustAttribute attribute : this.extendedAttributes) {
            if (AssertionMapKeys.getNameIdValueKey().equals(attribute.getName())) {
                ValidationError error = this.errorFactory.create(ApiMessageKey.ws_trust_attribute_contract_ext_key_word, ConnectionPaths.WsTrustPaths.getAttributeContractExtended(i), new Object[]{AssertionMapKeys.getNameIdValueKey()});
                this.appendError(error);
            }
            ++i;
        }
        return !this.hasErrors();
    }
}

