/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.IdpTokenProcessorMapping;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.SpWsTrust;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdpWsTrustTokenMappingValidator;
import com.pingidentity.admin.api.validator.UniqueEntriesValidator;
import com.pingidentity.admin.api.validator.WsTrustRestrictedVirtualServerIdsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.List;

public class IdpWsTrustTokenMappingsValidator
extends CompositeValidator {
    private SpWsTrust wsTrust;
    private SpConnection spConn;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private ValidatorContext context;

    IdpWsTrustTokenMappingsValidator(SpConnection spConn, ValidatorContext context) {
        this.context = context;
        this.spConn = spConn;
        this.wsTrust = spConn.getWsTrust();
        List<IdpTokenProcessorMapping> mappings = this.wsTrust.getTokenProcessorMappings();
        if (mappings.isEmpty()) {
            ValidationError error = this.errorFactory.create(ApiMessageKey.field_required, ConnectionPaths.WsTrustPaths.getTokenProcessorMappings(), new Object[]{"Token Processor Mappings"});
            this.appendError(error);
        } else {
            UniqueEntriesValidator.UniqueKeyGetter<IdpTokenProcessorMapping> keyGetter = new UniqueEntriesValidator.UniqueKeyGetter<IdpTokenProcessorMapping>(){

                @Override
                public String getKey(IdpTokenProcessorMapping object) {
                    if (object.getIdpTokenProcessorRef() != null && object.getIdpTokenProcessorRef().getId() != null) {
                        return object.getIdpTokenProcessorRef().getId();
                    }
                    return null;
                }
            };
            this.addValidator((Validator)new UniqueEntriesValidator<IdpTokenProcessorMapping>(keyGetter, mappings, ConnectionPaths.WsTrustPaths.getTokenProcessorMappings(), ApiMessageKey.idp_token_processor_mappings_duplicate_mappings));
        }
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        List<IdpTokenProcessorMapping> mappings = this.wsTrust.getTokenProcessorMappings();
        int mappingIndex = 0;
        for (IdpTokenProcessorMapping mapping : mappings) {
            this.addValidator((Validator)new WsTrustRestrictedVirtualServerIdsValidator(this.spConn.getVirtualEntityIds(), mapping.getRestrictedVirtualEntityIds(), mappingIndex));
            IdpWsTrustTokenMappingValidator validator = new IdpWsTrustTokenMappingValidator(mapping, mappingIndex, this.wsTrust, this.context);
            this.addValidator((Validator)validator);
            ++mappingIndex;
        }
        super.validate();
        return !this.hasErrors();
    }
}

