/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.SpWsTrustTokenGeneratorMappingsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class IdpWsTrustValidator
extends CompositeValidator {
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private IdpConnection connection;
    private ValidatorContext context;

    public IdpWsTrustValidator(IdpConnection connection, ValidatorContext context) {
        this.connection = connection;
        this.context = context;
    }

    @Override
    public boolean validate() {
        if (this.connection.getWsTrust() != null) {
            LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
            boolean enabled = localSettings.isEnableWsTrustSp();
            if (!enabled) {
                ValidationError error = this.errorFactory.create(ApiMessageKey.ws_trust_not_enabled, ConnectionPaths.getWsTrust());
                this.appendError(error);
                return false;
            }
            if (this.connection.getBrowserSso() != null && Protocol.OIDC == this.connection.getBrowserSso().getProtocol()) {
                ValidationError error = this.errorFactory.create(ApiMessageKey.oidc_protocol_not_allowed, ConnectionPaths.getWsTrust());
                this.appendError(error);
                return false;
            }
            SpWsTrustTokenGeneratorMappingsValidator mappingsValidator = new SpWsTrustTokenGeneratorMappingsValidator(this.connection, this.context);
            this.addValidator((Validator)mappingsValidator);
            super.validate();
        }
        return !this.hasErrors();
    }
}

