/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.UsernamePasswordCredentials;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.PasswordValidator;
import com.pingidentity.admin.api.validator.UsernamePasswordCredentialsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class InboundBackChannelBasicAuthValidator
extends UsernamePasswordCredentialsValidator {
    private final Connection conn;
    private final String username;

    public InboundBackChannelBasicAuthValidator(UsernamePasswordCredentials creds, Connection conn) {
        super(creds.getUsername(), creds.getPassword(), creds.getEncryptedPassword(), ConnectionPaths.getInboundBackChannelAuthBasicUsername(), ConnectionPaths.getInboundBackChannelAuthBasicPassword(), ConnectionPaths.getInboundBackChannelAuthBasicEncryptedPassword());
        this.conn = conn;
        this.username = creds.getUsername();
    }

    @Override
    public boolean validate() {
        super.validate();
        if (!this.hasErrors()) {
            PasswordValidator passwordValidator;
            ConnectionManager connMgr;
            String usedBy;
            if (!StringUtils.isBlank((String)this.username) && this.username.contains(":")) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.basicauth_no_colon, ConnectionPaths.getInboundBackChannelAuthBasicUsername()));
            }
            if (StringUtils.isNotBlank((String)(usedBy = (connMgr = MgmtFactory.getConnectionManager()).basicAuthInUserNameUsedBy(this.username, this.conn.getId())))) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.usernamepassword_username_in_use, ConnectionPaths.getInboundBackChannelAuthBasicUsername(), new Object[]{usedBy}));
            }
            if (!(passwordValidator = new PasswordValidator(this.decryptedPassword, this.passwordPath, "Password")).validate()) {
                this.appendErrors(passwordValidator.getErrors());
            }
        }
        return !this.hasErrors();
    }
}

