/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.InboundBackChannelAuth;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.AbstractBackChannelValidator;
import com.pingidentity.admin.api.validator.InboundBackChannelAuthTypeValidator;
import com.pingidentity.admin.api.validator.InboundBackChannelBasicAuthValidator;
import com.pingidentity.admin.api.validator.InboundBackChannelVerificationSettingsValidator;
import com.pingidentity.admin.api.validator.SslClientVerificationCertValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.Cert;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.pf.common.api.validator.ValidatorRegistry;
import java.security.cert.CertificateException;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;

public class InboundBackChannelValidator
extends AbstractBackChannelValidator {
    private final boolean isUpdate;
    private final ConnectionBase existingConn;
    private final ValidatorRegistry validatorRegistry;
    private boolean fullValidationPath;

    public InboundBackChannelValidator(Connection connection, ConnectionBase existingConn, boolean isUpdate, ValidatorRegistry validatorRegistry, boolean fullValidationPath) {
        this.connection = connection;
        this.isUpdate = isUpdate;
        this.existingConn = existingConn;
        this.validatorRegistry = validatorRegistry;
        this.fullValidationPath = fullValidationPath;
        if (this.isBackChannelAuthenticationNeeded() && this.isOutboundArtifactSelected()) {
            if (connection.getCredentials().getInboundBackChannelAuth() == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, ConnectionPaths.getInboundBackChannelAuth(), new Object[]{ConnectionPaths.getInboundBackChannelAuth()}));
            }
        } else if (connection.getCredentials().getInboundBackChannelAuth() != null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_not_required, ConnectionPaths.getInboundBackChannelAuth(), new Object[]{ConnectionPaths.getInboundBackChannelAuth()}));
        }
    }

    public boolean validate() {
        if (this.hasErrors()) {
            return false;
        }
        if (!this.isBackChannelAuthenticationNeeded() || !this.isOutboundArtifactSelected()) {
            return true;
        }
        boolean isDigitalSignatureOrAttributeQueryOnly = this.connection.getCredentials().getInboundBackChannelAuth().isDigitalSignature();
        boolean needAtLeastBasicOrCert = false;
        if (this.connection.getType().getRole() == Role.SP) {
            SpConnection spConn = (SpConnection)this.connection;
            if (spConn.getBrowserSso() == null && spConn.getAttributeQuery() != null && !this.isCertAuthMethod() && this.connection.getCredentials().getInboundBackChannelAuth().getHttpBasicCredentials() == null) {
                isDigitalSignatureOrAttributeQueryOnly = true;
            }
            if (this.connection.getBrowserSso() != null && Protocol.isSaml1x(this.connection.getBrowserSso().getProtocol())) {
                needAtLeastBasicOrCert = true;
            }
        }
        InboundBackChannelAuthTypeValidator authValidator = new InboundBackChannelAuthTypeValidator(this.isCertAuthMethod(), this.connection.getCredentials().getInboundBackChannelAuth().getHttpBasicCredentials() != null, isDigitalSignatureOrAttributeQueryOnly, needAtLeastBasicOrCert);
        authValidator.validate();
        this.appendErrors(authValidator.getErrors());
        if (this.hasErrors()) {
            return false;
        }
        InboundBackChannelAuth auth = this.connection.getCredentials().getInboundBackChannelAuth();
        if (StringUtils.isNotBlank((String)auth.getVerificationSubjectDN()) && auth.getCerts() != null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.inbound_backchannel_anchored_or_unanchored, ConnectionPaths.getInboundBackChannelAuth()));
        }
        if (this.hasErrors()) {
            return false;
        }
        if (auth.getHttpBasicCredentials() != null) {
            InboundBackChannelBasicAuthValidator basicValidator = new InboundBackChannelBasicAuthValidator(auth.getHttpBasicCredentials(), this.connection);
            basicValidator.validate();
            this.appendErrors(basicValidator.getErrors());
        }
        SslClientVerificationCertValidator sslClientCertValidator = null;
        if (auth.getCerts() != null) {
            sslClientCertValidator = new SslClientVerificationCertValidator(this.isUpdate, this.existingConn, this.connection.getCredentials().getInboundBackChannelAuth().getCerts(), this.fullValidationPath);
            this.validatorRegistry.register(SslClientVerificationCertValidator.class, (Validator)sslClientCertValidator);
            sslClientCertValidator.validate();
            this.appendErrors(sslClientCertValidator.getErrors());
            ConnectionManager connManager = MgmtFactory.getConnectionManager();
            for (int i = 0; i < auth.getCerts().size(); ++i) {
                if (!Boolean.TRUE.equals(auth.getCerts().get(i).isPrimaryVerificationCert())) continue;
                try {
                    Cert cert = Cert.importCert((String)auth.getCerts().get(i).getX509File().getFileData());
                    String usedBy = connManager.certAuthInCertUsedBy(cert, this.connection.getId());
                    if (usedBy == null) continue;
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.inbound_backchannel_cert_in_use, ConnectionPaths.getInboundBackChannelCert(i), new Object[]{usedBy}));
                    continue;
                }
                catch (CertificateException certParsingEx) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.cert_import_error_importing_file, ConnectionPaths.getInboundBackChannelCert(i)));
                }
            }
        }
        if (StringUtils.isNotBlank((String)auth.getVerificationSubjectDN())) {
            InboundBackChannelVerificationSettingsValidator verificationSettingsValidator = new InboundBackChannelVerificationSettingsValidator(this.connection, sslClientCertValidator, this.fullValidationPath);
            verificationSettingsValidator.validate();
            this.appendErrors(verificationSettingsValidator.getErrors());
        }
        return !this.hasErrors();
    }

    private boolean isCertAuthMethod() {
        boolean isCert = this.connection.getCredentials().getInboundBackChannelAuth().getCerts() != null && !this.connection.getCredentials().getInboundBackChannelAuth().getCerts().isEmpty();
        return isCert |= StringUtils.isNotBlank((String)this.connection.getCredentials().getInboundBackChannelAuth().getVerificationSubjectDN());
    }

    public boolean isOutboundArtifactSelected() {
        boolean selected = false;
        selected = this.isArtifactSsoSlo();
        selected |= this.isInboundSoap();
        if (Role.SP == this.connection.getType().getRole()) {
            SpConnection spConn = (SpConnection)this.connection;
            selected |= spConn.getAttributeQuery() != null;
        }
        if (Role.IDP == this.connection.getType().getRole()) {
            IdpConnection idpConn = (IdpConnection)this.connection;
            selected |= idpConn.getInboundProvisioning() != null;
        }
        return selected;
    }
}

