/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.Connection;
import com.pingidentity.admin.api.model.ConnectionCert;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.VerificationCertValidator;
import com.pingidentity.admin.api.validator.VerificationSettingsValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class InboundBackChannelVerificationSettingsValidator
extends VerificationSettingsValidator {
    private String subjectDn;
    private String issuerDn;

    public InboundBackChannelVerificationSettingsValidator(Connection connection, VerificationCertValidator validator, boolean fullValidationPath) {
        super(connection, validator, fullValidationPath);
        if (connection.getCredentials() != null && connection.getCredentials().getInboundBackChannelAuth() != null) {
            this.subjectDn = connection.getCredentials().getInboundBackChannelAuth().getVerificationSubjectDN();
            this.issuerDn = connection.getCredentials().getInboundBackChannelAuth().getVerificationIssuerDN();
        }
    }

    @Override
    public boolean validate() {
        String ctxId;
        ConnectionManager connManager;
        String usedBy;
        super.validate();
        if (ValidationUtil.isValidSubjectDN((String)this.getSubjectDN()) && (usedBy = (connManager = MgmtFactory.getConnectionManager()).certAuthInSubjectDbUsedBy(this.subjectDn, ctxId = this.connection.getId())) != null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.inbound_backchannel_dn_in_use, this.getSubjectDNPath(), new Object[]{usedBy}));
        }
        return !this.hasErrors();
    }

    @Override
    protected String getSubjectDN() {
        return this.subjectDn;
    }

    @Override
    protected String getIssuerDN() {
        return this.issuerDn;
    }

    @Override
    protected String getSubjectDNPath() {
        return ConnectionPaths.getInboundBackChannelVerificationSubjectDN();
    }

    @Override
    protected String getIssuerDNPath() {
        return ConnectionPaths.getInboundBackChannelVerificationIssuerDN();
    }

    @Override
    protected String getCredentialsPath() {
        return ConnectionPaths.getInboundBackChannelAuth();
    }

    protected List<ConnectionCert> getAuthCerts() {
        if (this.connection.getCredentials() != null && this.connection.getCredentials().getInboundBackChannelAuth() != null) {
            return this.connection.getCredentials().getInboundBackChannelAuth().getCerts();
        }
        return new ArrayList<ConnectionCert>();
    }
}

