/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.Scim2UserConstants;
import org.sourceid.saml20.domain.ScimUserConstantsFactory;
import org.sourceid.saml20.domain.scim.ScimVersion;

public class InboundProvisioningCustomScim2AttributesValidator
extends AbstractValidator {
    protected String attributeName;
    protected String schema;

    public InboundProvisioningCustomScim2AttributesValidator() {
    }

    public InboundProvisioningCustomScim2AttributesValidator(Builder builder) {
        this.attributeName = builder.attributeName;
        this.schema = builder.schema;
    }

    public boolean validate() {
        this.validateSchema();
        this.validateAttributeName();
        this.validateCustomAttributeIdDoesNotMatchAnyCoreAttributeIds(this.attributeName);
        return false;
    }

    protected void validateSchema() {
        if (this.schema != null && StringUtils.isWhitespace((String)this.schema)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_attr_schema_invalid, "inbound_provisioning_custom_attribute_name"));
        }
    }

    protected void validateAttributeName() {
        if (StringUtils.isEmpty((String)this.attributeName)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_attr_name_required, "inbound_provisioning_custom_attribute_name"));
        } else if (StringUtils.isWhitespace((String)this.attributeName)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_attr_name_invalid_blank_not_allowed, "inbound_provisioning_custom_attribute_name"));
        } else if (!StringUtils.isWhitespace((String)this.attributeName) && !StringUtils.isAlphanumeric((String)this.attributeName)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_attr_name_invalid_alphanumeric_only, "inbound_provisioning_custom_attribute_name"));
        }
    }

    protected void validateCustomAttributeIdDoesNotMatchAnyCoreAttributeIds(String customAttributeId) {
        HashSet allCoreIds = new HashSet();
        Scim2UserConstants scim2UserConstants = (Scim2UserConstants)ScimUserConstantsFactory.getScimUserConstants((ScimVersion)ScimVersion.SCIM20);
        allCoreIds.addAll(scim2UserConstants.getAllIds());
        allCoreIds.addAll(scim2UserConstants.getRootAttributeNames());
        for (String coreAttributeId : allCoreIds) {
            if (!customAttributeId.equals(coreAttributeId)) continue;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_attr_name_must_not_match_core_attr_id, "inbound_provisioning_custom_attribute_id", new Object[]{customAttributeId}));
        }
    }

    public static class Builder {
        private String attributeName;
        private String schema;

        public Builder setAttributeName(String name) {
            this.attributeName = name;
            return this;
        }

        public Builder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public InboundProvisioningCustomScim2AttributesValidator build() {
            return new InboundProvisioningCustomScim2AttributesValidator(this);
        }
    }
}

