/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.GroupConstants;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.UserConstants;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.scim.model.SchemaAttribute;

public class InboundProvisioningCustomScimAttributesValidator
extends AbstractValidator {
    protected String attributeName;
    protected String schema;
    protected String idpConnEntityId;
    protected List<String> theOtherAttributeNames;

    public InboundProvisioningCustomScimAttributesValidator() {
    }

    public InboundProvisioningCustomScimAttributesValidator(AttributesBuilder attributesBuilder) {
        this.attributeName = attributesBuilder.attributeName;
        this.schema = attributesBuilder.schema;
        this.idpConnEntityId = attributesBuilder.idpConnEntityId;
        this.theOtherAttributeNames = attributesBuilder.theOtherAttributeNames;
    }

    public boolean validate() {
        this.validateSchema();
        this.validateAttributeName();
        this.validateCustomAttributeIdDoesNotMatchAnyCoreAttributeIds(this.attributeName);
        return !this.hasErrors();
    }

    protected void validateSchema() {
        if (this.schema != null && StringUtils.isWhitespace((String)this.schema)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_attr_schema_invalid, "inbound_provisioning_custom_attribute_name"));
        }
    }

    protected void validateAttributeName() {
        block2: {
            block5: {
                block4: {
                    block3: {
                        if (this.attributeName == null) break block2;
                        if (!StringUtils.isWhitespace((String)this.attributeName)) break block3;
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_attr_name_invalid_blank_not_allowed, "inbound_provisioning_custom_attribute_name"));
                        break block2;
                    }
                    if (StringUtils.isWhitespace((String)this.attributeName) || StringUtils.isAlphanumeric((String)this.attributeName)) break block4;
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_attr_name_invalid_alphanumeric_only, "inbound_provisioning_custom_attribute_name"));
                    break block2;
                }
                if (this.theOtherAttributeNames != null) break block5;
                ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
                IdpConnection idpConnection = connectionManager.getIdpConnection(this.idpConnEntityId);
                if (idpConnection.getInboundProvisioning().getCustomScim() == null || idpConnection.getInboundProvisioning().getCustomScim().getAttributes() == null) break block2;
                List schemaAttributes = idpConnection.getInboundProvisioning().getCustomScim().getAttributes();
                this.theOtherAttributeNames = new ArrayList<String>();
                for (SchemaAttribute schemaAttribute : schemaAttributes) {
                    this.theOtherAttributeNames.add(schemaAttribute.getName());
                }
                break block2;
            }
            for (String theOtherAttributeName : this.theOtherAttributeNames) {
                if (!this.attributeName.equals(theOtherAttributeName)) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_attr_name_exists, "inbound_provisioning_custom_attribute_name", new Object[]{this.attributeName}));
            }
        }
    }

    protected void validateCustomAttributeIdDoesNotMatchAnyCoreAttributeIds(String customAttributeId) {
        HashSet<String> allCoreIds = new HashSet<String>();
        allCoreIds.addAll(UserConstants.getAllIds());
        allCoreIds.addAll(GroupConstants.getAllIds());
        allCoreIds.add("members");
        for (String coreAttributeId : allCoreIds) {
            if (!customAttributeId.equals(coreAttributeId)) continue;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.provisioning_custom_attr_name_must_not_match_core_attr_id, "inbound_provisioning_custom_attribute_id", new Object[]{customAttributeId}));
        }
    }

    public static class AttributesBuilder {
        private String attributeName;
        private String schema;
        private String idpConnEntityId;
        private List<String> theOtherAttributeNames;

        public AttributesBuilder setAttributeName(String name) {
            this.attributeName = name;
            return this;
        }

        public AttributesBuilder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        public AttributesBuilder setIdpConnEntityId(String id) {
            this.idpConnEntityId = id;
            return this;
        }

        public AttributesBuilder setTheOtherAttributeNames(List<String> otherAttributeNames) {
            this.theOtherAttributeNames = otherAttributeNames;
            return this;
        }

        public InboundProvisioningCustomScimAttributesValidator build() {
            return new InboundProvisioningCustomScimAttributesValidator(this);
        }
    }
}

