/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.BaseBrowserSso;
import com.pingidentity.admin.api.model.Binding;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.Profile;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Set;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.Protocol;

public class IncomingBindingsValidator
extends AbstractValidator {
    private final boolean isArtifactEnabled;
    private final boolean isPostEnabled;
    private final boolean isRedirectEnabled;
    private final boolean isSoapEnabled;
    private final Role role;
    private final boolean isSomethingOtherThanIdpInitSsoEnabled;
    private final boolean isArtifactSsoOrSloUsed;
    private final Protocol protocol;
    private final boolean isApi;
    private boolean skipSaml1xValidation;

    public IncomingBindingsValidator(IdpConnection connection) {
        this(connection.getIdpBrowserSso(), connection.getType().getRole());
    }

    public IncomingBindingsValidator(SpConnection connection) {
        this(connection.getSpBrowserSso(), connection.getType().getRole());
    }

    public IncomingBindingsValidator(BaseBrowserSso browserSso, Role role) {
        Set<Profile> enabledProfiles = browserSso.getEnabledProfiles();
        Set<Binding> inBindings = browserSso.getIncomingBindings();
        this.isPostEnabled = inBindings != null && inBindings.contains((Object)Binding.POST);
        this.isRedirectEnabled = inBindings != null && inBindings.contains((Object)Binding.REDIRECT);
        this.isArtifactEnabled = inBindings != null && inBindings.contains((Object)Binding.ARTIFACT);
        this.isSoapEnabled = inBindings != null && inBindings.contains((Object)Binding.SOAP);
        this.role = role;
        this.isSomethingOtherThanIdpInitSsoEnabled = enabledProfiles == null ? false : (enabledProfiles.contains((Object)Profile.IDP_INITIATED_SSO) ? enabledProfiles.size() > 1 : !enabledProfiles.isEmpty());
        this.isArtifactSsoOrSloUsed = browserSso.isArtifactSsoSloUsed();
        this.protocol = browserSso.getProtocol() == null ? null : Protocol.valueOf((String)browserSso.getProtocol().name());
        this.isApi = true;
    }

    public IncomingBindingsValidator(boolean isArtifactEnabled, boolean isPostEnabled, boolean isRedirectEnabled, boolean isSoapEnabled, Role role, boolean isSomethingOtherThanIdpInitSsoEnabled, boolean isArtifactSsoOrSloUsed, Protocol protocol) {
        this.isArtifactEnabled = isArtifactEnabled;
        this.isPostEnabled = isPostEnabled;
        this.isRedirectEnabled = isRedirectEnabled;
        this.isSoapEnabled = isSoapEnabled;
        this.role = role;
        this.isSomethingOtherThanIdpInitSsoEnabled = isSomethingOtherThanIdpInitSsoEnabled;
        this.isArtifactSsoOrSloUsed = isArtifactSsoOrSloUsed;
        this.protocol = protocol;
        this.isApi = false;
    }

    public void skipSaml1xValidation(boolean value) {
        this.skipSaml1xValidation = value;
    }

    public boolean validate() {
        if (!(this.skipSaml1xValidation || this.protocol != Protocol.SAML10 && this.protocol != Protocol.SAML11)) {
            if (this.role == Role.IDP && (this.isSoapEnabled || this.isRedirectEnabled)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.incoming_bindings_redirect_or_soap_invalid, ConnectionPaths.getIncomingBindingsPropertyPath(this.role)));
            }
        } else if (this.protocol == Protocol.SAML20) {
            int initNumErrors = this.getErrors().size();
            if (!(this.role != Role.SP || this.isArtifactEnabled || this.isPostEnabled || this.isRedirectEnabled || this.isSoapEnabled || !this.isSomethingOtherThanIdpInitSsoEnabled)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.incoming_bindings_saml_binding_required, ConnectionPaths.getIncomingBindingsPropertyPath(this.role)));
            }
            if (this.isArtifactSsoOrSloUsed && !this.isSoapEnabled) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.incoming_bindings_soap_required, ConnectionPaths.getIncomingBindingsPropertyPath(this.role)));
            }
            if (this.role == Role.IDP && !this.isArtifactEnabled && !this.isPostEnabled) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.incoming_bindings_artifact_and_or_post_required, ConnectionPaths.getIncomingBindingsPropertyPath(this.role)));
            }
            return initNumErrors == this.getErrors().size();
        }
        return !this.hasErrors();
    }
}

