/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.HashSet;
import java.util.List;

public class JdbcColumnNamesValidator
extends AbstractValidator {
    private final List<String> columnNames;
    private final List<String> tableColumnNames;
    private final String fieldPath;

    public JdbcColumnNamesValidator(List<String> columnNames, List<String> tableColumnNames, String fieldPath) {
        this.columnNames = columnNames;
        this.tableColumnNames = tableColumnNames;
        this.fieldPath = fieldPath;
    }

    public boolean validate() {
        HashSet<String> columnNameSet = new HashSet<String>(this.columnNames);
        if (columnNameSet.size() != this.columnNames.size()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_attribute_source_column_name_duplicate, this.fieldPath));
        }
        columnNameSet.forEach(columnName -> {
            if (!this.tableColumnNames.contains(columnName)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_attribute_source_column_name_invalid, this.fieldPath, new Object[]{columnName}));
            }
        });
        return !this.hasErrors();
    }
}

