/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.DataStoreFilterBaseValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.Substituter;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class JdbcFilterValidator
extends DataStoreFilterBaseValidator {
    private final String filter;
    private final Collection<String> validSubstitutionVars;
    private final String substitutionVarSourceName;
    private final String baseFieldPath;
    private final boolean isBypassExternalValidation;

    public JdbcFilterValidator(String filter, String baseFieldPath) {
        this.filter = filter;
        this.validSubstitutionVars = null;
        this.substitutionVarSourceName = null;
        this.baseFieldPath = baseFieldPath;
        this.isBypassExternalValidation = false;
    }

    public JdbcFilterValidator(String filter, Collection<String> validSubstitutionVars, String substitutionVarSourceName, String baseFieldPath, boolean isBypassExternalValidation) {
        this.filter = filter;
        this.validSubstitutionVars = validSubstitutionVars;
        this.substitutionVarSourceName = substitutionVarSourceName;
        this.baseFieldPath = baseFieldPath;
        this.isBypassExternalValidation = isBypassExternalValidation;
    }

    public boolean validate() {
        if (StringUtils.isBlank((String)this.filter)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_attribute_source_filter_required, ConnectionPaths.getAttributeSourceJdbcDSFilterPath(this.baseFieldPath)));
        }
        if (!(this.validSubstitutionVars == null || Substituter.checkSubstituteValues((String)this.filter, this.validSubstitutionVars) || this.isBypassExternalValidation && this.areNonDsSubstitutable(this.filter, this.validSubstitutionVars))) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_attribute_source_filter_var_not_found, ConnectionPaths.getAttributeSourceJdbcDSFilterPath(this.baseFieldPath), new Object[]{this.substitutionVarSourceName}));
        }
        return !this.hasErrors();
    }
}

