/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.websso.profiles.sp.provisioning.JdbcExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.handlers.SqlServerDataTypeCoersionHandler;

public class JdbcStoredProcedureValidator
extends AbstractValidator {
    private final String schema;
    private final String storedProcedure;
    private List<ResultInfo> availableStoredProcedureColumnsWithMetadata;
    private final JdbcDataSource jdbcDs;
    private final String baseFieldPath;
    private final boolean isExpressProvisioning;

    public JdbcStoredProcedureValidator(String schema, String storedProcedure, List<ResultInfo> availableStoredProcedureColumnsWithMetadata, JdbcDataSource jdbcDs, boolean isExpressProvisioning, String baseFieldPath) {
        this.schema = schema;
        this.storedProcedure = storedProcedure;
        this.availableStoredProcedureColumnsWithMetadata = availableStoredProcedureColumnsWithMetadata;
        this.jdbcDs = jdbcDs;
        this.baseFieldPath = baseFieldPath;
        this.isExpressProvisioning = isExpressProvisioning;
    }

    public boolean validate() {
        if (StringUtils.isBlank((String)this.storedProcedure)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_attribute_source_stored_procedure_required, ConnectionPaths.getAttributeSourceJdbcDSStoredProcedurePath(this.baseFieldPath)));
        } else {
            Object fullStoredProcedureName = this.schema != null ? this.schema + "." + this.storedProcedure : this.storedProcedure;
            if (this.availableStoredProcedureColumnsWithMetadata == null) {
                this.availableStoredProcedureColumnsWithMetadata = this.jdbcDs.getUnsortedStoredProcedureColumnsWithMetadata(this.schema, this.storedProcedure);
            }
            if (this.availableStoredProcedureColumnsWithMetadata.isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_attribute_source_stored_procedure_not_found, ConnectionPaths.getAttributeSourceJdbcDSTablePath(this.baseFieldPath), new Object[]{fullStoredProcedureName}));
            } else {
                boolean expressionNotEnabled = false;
                Iterator<ResultInfo> iterator = this.availableStoredProcedureColumnsWithMetadata.iterator();
                while (iterator.hasNext()) {
                    SqlServerDataTypeCoersionHandler handler = new SqlServerDataTypeCoersionHandler(null, JdbcExpressProvisioningProcessor.OPERATION.INSERT, true);
                    ResultInfo info = iterator.next();
                    String bannedColumnTypeName = handler.doesColumnHaveBannedType(info);
                    if (bannedColumnTypeName != null) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_attribute_source_stored_procedure_not_allowed, ConnectionPaths.getAttributeSourceJdbcDSTablePath(this.baseFieldPath), new Object[]{fullStoredProcedureName, bannedColumnTypeName}));
                    }
                    ExpressionManager expressionManager = ExpressionManager.getInstance();
                    if (!this.isExpressProvisioning || expressionNotEnabled || !info.isDatetimeColumn() || info.isNullable() || expressionManager.isEvaluateExpressionsOn()) continue;
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_attribute_source_expressions_required, ConnectionPaths.getAttributeSourceJdbcDSTablePath(this.baseFieldPath), new Object[]{fullStoredProcedureName}));
                    expressionNotEnabled = true;
                }
            }
        }
        return !this.hasErrors();
    }
}

