/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.ResultInfo;
import org.sourceid.websso.profiles.sp.provisioning.JdbcExpressProvisioningProcessor;
import org.sourceid.websso.profiles.sp.provisioning.handlers.SqlServerDataTypeCoersionHandler;

public class JdbcTableValidator
extends AbstractValidator {
    private String schema;
    private String table;
    private List<ResultInfo> availableColumnsMetadata;
    private JdbcDataSource jdbcDs;
    private String baseFieldPath;
    private boolean isExpressProvisioning;

    public JdbcTableValidator(String schema, String table, JdbcDataSource jdbcDs, boolean isExpressProvisioning, String fieldPath) {
        this.schema = schema;
        this.table = table;
        this.jdbcDs = jdbcDs;
        this.baseFieldPath = fieldPath;
    }

    public JdbcTableValidator(String schema, String table, List<ResultInfo> availableColumnsMetadata, boolean isExpressProvisioning, String baseFieldPath) {
        this.schema = schema;
        this.table = table;
        this.availableColumnsMetadata = availableColumnsMetadata;
        this.baseFieldPath = baseFieldPath;
        this.isExpressProvisioning = isExpressProvisioning;
    }

    public boolean validate() {
        if (StringUtils.isBlank((String)this.table)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_attribute_source_table_required, ConnectionPaths.getAttributeSourceJdbcDSTablePath(this.baseFieldPath)));
        } else {
            Object fullTableName = this.schema != null ? this.schema + "." + this.table : this.table;
            if (this.availableColumnsMetadata == null) {
                this.availableColumnsMetadata = this.jdbcDs.getUnsortedColumnsWithMetadata(this.schema, this.table);
            }
            if (this.availableColumnsMetadata.isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_attribute_source_table_not_found, ConnectionPaths.getAttributeSourceJdbcDSTablePath(this.baseFieldPath), new Object[]{fullTableName}));
            } else {
                boolean expressionNotEnabled = false;
                Iterator<ResultInfo> iterator = this.availableColumnsMetadata.iterator();
                while (iterator.hasNext()) {
                    SqlServerDataTypeCoersionHandler handler = new SqlServerDataTypeCoersionHandler(null, JdbcExpressProvisioningProcessor.OPERATION.INSERT, true);
                    ResultInfo info = iterator.next();
                    String bannedColumnTypeName = handler.doesColumnHaveBannedType(info);
                    if (bannedColumnTypeName != null) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_attribute_source_table_not_allowed, ConnectionPaths.getAttributeSourceJdbcDSTablePath(this.baseFieldPath), new Object[]{fullTableName, bannedColumnTypeName}));
                    }
                    ExpressionManager expressionManager = ExpressionManager.getInstance();
                    if (!this.isExpressProvisioning || expressionNotEnabled || !info.isDatetimeColumn() || info.isNullable() || expressionManager.isEvaluateExpressionsOn()) continue;
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_attribute_source_expressions_required, ConnectionPaths.getAttributeSourceJdbcDSTablePath(this.baseFieldPath), new Object[]{fullTableName}));
                    expressionNotEnabled = true;
                }
            }
        }
        return !this.hasErrors();
    }
}

