/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.JdbcTagPaths;
import com.pingidentity.admin.api.validator.DataSourceTagConfigValidator;
import com.pingidentity.admin.api.validator.JdbcConnectionUrlValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.datasource.tag.JdbcTagConfig;

public class JdbcTagConfigValidator
extends DataSourceTagConfigValidator<JdbcTagConfig> {
    public JdbcTagConfigValidator(List<JdbcTagConfig> jdbcTagConfigs) {
        super(jdbcTagConfigs, JdbcTagPaths.getTagPath());
        if (this.tagConfigList != null) {
            int index = 0;
            for (JdbcTagConfig tagConfig : this.tagConfigList) {
                String connectionUrl = null;
                if (tagConfig.getIdentifier() != null) {
                    connectionUrl = tagConfig.getIdentifier().getJdbcUrl();
                }
                this.addValidator((Validator)new JdbcConnectionUrlValidator(connectionUrl, JdbcTagPaths.getConnectionUrlPath(index)));
                ++index;
            }
        }
    }

    @Override
    Set<String> hasDuplicateDataStoreIdentifier() {
        HashSet<String> existingJdbcUrl = new HashSet<String>();
        HashSet<String> duplicateJdbcUrl = new HashSet<String>();
        if (this.tagConfigList != null) {
            for (JdbcTagConfig tagConfig : this.tagConfigList) {
                String tagConfigJdbcUrl = null;
                if (tagConfig.getIdentifier() != null) {
                    tagConfigJdbcUrl = tagConfig.getIdentifier().getJdbcUrl();
                }
                if (existingJdbcUrl.contains(tagConfigJdbcUrl)) {
                    duplicateJdbcUrl.add(tagConfigJdbcUrl);
                    continue;
                }
                existingJdbcUrl.add(tagConfigJdbcUrl);
            }
        }
        return duplicateJdbcUrl;
    }

    @Override
    void validateDefaultSet() {
        boolean hasFoundDefault = false;
        if (this.tagConfigList != null) {
            for (JdbcTagConfig tagConfig : this.tagConfigList) {
                if (!tagConfig.isDefaultSource()) continue;
                if (!hasFoundDefault) {
                    hasFoundDefault = true;
                    continue;
                }
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_data_store_multiple_default_connection_urls, JdbcTagPaths.getTagArrayPath()));
                break;
            }
        }
        if (!hasFoundDefault) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_data_store_missing_default_connection_url, JdbcTagPaths.getTagArrayPath()));
        }
    }

    @Override
    public boolean validate() {
        Set<String> duplicateJdbcUrls;
        super.validate();
        if (this.validateDuplicateDataStoreIdentifier && !(duplicateJdbcUrls = this.hasDuplicateDataStoreIdentifier()).isEmpty()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_data_store_duplicate_connection_url, JdbcTagPaths.getConnectionUrlPath(), new Object[]{"'" + StringUtils.join(duplicateJdbcUrls, (String)"', '") + "'"}));
        }
        return !this.hasErrors();
    }

    @Override
    void appendMultipleEmptyTagError() {
        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jdbc_data_store_multiple_empty_tags, JdbcTagPaths.getTagArrayPath()));
    }
}

