/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class JdbcUniqueIdColumnValidator
extends AbstractValidator {
    private final String uniqueIdColumn;
    private final Collection<String> validSubstitutionVars;
    private final String substitutionVarSourceName;
    private final String baseFieldPath;
    private final boolean isBypassExternalValidation;

    public JdbcUniqueIdColumnValidator(String uniqueIdColumn, Collection<String> validSubstitutionVars, String substitutionVarSourceName, String baseFieldPath, boolean isBypassExternalValidation) {
        this.uniqueIdColumn = uniqueIdColumn;
        this.validSubstitutionVars = validSubstitutionVars;
        this.substitutionVarSourceName = substitutionVarSourceName;
        this.baseFieldPath = baseFieldPath;
        this.isBypassExternalValidation = isBypassExternalValidation;
    }

    public boolean validate() {
        if (StringUtils.isBlank((String)this.uniqueIdColumn)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jit_provisioning_user_repository_sql_method_table_unique_id_column_required, ConnectionPaths.getJitProvisioningTableUniqueIdColumn()));
        } else if (this.validSubstitutionVars != null && !this.validSubstitutionVars.contains(this.uniqueIdColumn)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.jit_provisioning_user_repository_sql_method_table_unique_id_column_invalid, ConnectionPaths.getJitProvisioningTableUniqueIdColumn(), new Object[]{this.uniqueIdColumn}));
        }
        return !this.hasErrors();
    }
}

