/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.KerberosKeySet;
import com.pingidentity.admin.api.model.fieldpaths.KerberosRealmPaths;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.FieldObfuscator;
import com.pingidentity.common.util.KerberosConfigUtil;
import com.pingidentity.common.util.ObfuscationException;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.KerberosConnectionType;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.KerberosRealmManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.KerberosKeySetUtil;

public class KerberosRealmValidator
extends CompositeValidator {
    private final String kerberosRealmId;
    private final String kerberosRealmName;
    private final List<String> keyDistributionCenters;
    private final String kerberosUsername;
    private final String kerberosPassword;
    private final String kerberosEncryptedPassword;
    private final List<KerberosKeySet> keySets;
    private final boolean isCreate;
    private final KerberosConnectionType connectionType;
    private final String ldapGatewayDataStoreId;
    private final Boolean isRetainPreviousKeysOnPasswordChange;
    private final Boolean isSuppressDomainNameConcatenation;

    public KerberosRealmValidator(Builder builder) {
        this.kerberosRealmId = builder.kerberosRealmId;
        this.kerberosRealmName = builder.kerberosRealmName;
        this.keyDistributionCenters = builder.keyDistributionCenters;
        this.kerberosUsername = builder.kerberosUsername;
        this.kerberosPassword = builder.kerberosPassword;
        this.kerberosEncryptedPassword = builder.kerberosEncryptedPassword;
        this.keySets = builder.keySets;
        this.isCreate = builder.isCreate;
        this.connectionType = builder.connectionType;
        this.ldapGatewayDataStoreId = builder.ldapGatewayDataStoreId;
        this.isRetainPreviousKeysOnPasswordChange = builder.isRetainPreviousKeysOnPasswordChange;
        this.isSuppressDomainNameConcatenation = builder.isSuppressDomainNameConcatenation;
    }

    @Override
    public boolean validate() {
        if (this.isCreate && this.kerberosRealmId != null) {
            this.addValidator((Validator)new IdValidator(this.kerberosRealmId, true, false, 0, 52, KerberosRealmPaths.getId()));
            super.validate();
        }
        this.validateRealmNameAndId();
        this.validateRealmUsername();
        this.validatePasswordPresent();
        this.validateEncryptedPassword();
        this.validateKeyDistributionCenters();
        this.validateKeySets();
        this.validatePingOneGateway();
        this.validateRetainPreviousKeysOnPasswordChange();
        this.validateSuppressDomainNameConcatenation();
        return !this.hasErrors();
    }

    private void validateRealmNameAndId() {
        if (StringUtils.isBlank((String)this.kerberosRealmName)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_name_required, KerberosRealmPaths.getKerberosRealmName()));
            return;
        }
        KerberosRealmManager kerberosRealmManager = MgmtFactory.getKerberosRealmManager();
        Collection kerberosRealms = kerberosRealmManager.getKerberosRealms();
        for (KerberosRealm kerberosRealm : kerberosRealms) {
            if (this.isCreate && kerberosRealm.getId().equals(this.kerberosRealmId)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_id_exists, KerberosRealmPaths.getKerberosRealmName()));
            }
            if (kerberosRealm.getId().equals(this.kerberosRealmId) || !this.kerberosRealmName.equals(kerberosRealm.getKerberosRealmName())) continue;
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_name_exists, KerberosRealmPaths.getKerberosRealmName()));
        }
    }

    private void validateRealmUsername() {
        if (StringUtils.isBlank((String)this.kerberosUsername) && (this.isDirectConnection() || this.isLocalValidationConnection())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_username_required, KerberosRealmPaths.getKerberosUsername()));
        } else if (StringUtils.isNotBlank((String)this.kerberosUsername) && this.isLdapGatewayConnection()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_username_not_required, KerberosRealmPaths.getKerberosUsername()));
        }
    }

    private void validatePasswordPresent() {
        if (StringUtils.isBlank((String)this.kerberosPassword) && StringUtils.isBlank((String)this.kerberosEncryptedPassword) && (this.isDirectConnection() || this.isLocalValidationConnection())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_password_required, KerberosRealmPaths.getKerberosPassword()));
        } else if (StringUtils.isNotBlank((String)this.kerberosPassword) && this.isLdapGatewayConnection()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_password_not_required, KerberosRealmPaths.getKerberosPassword()));
        }
    }

    private void validateEncryptedPassword() {
        if (StringUtils.isBlank((String)this.kerberosPassword) && StringUtils.isNotEmpty((String)this.kerberosEncryptedPassword) && (this.isDirectConnection() || this.isLocalValidationConnection())) {
            try {
                String obfuscatedString = FieldObfuscator.REAL.deobfuscate(this.kerberosEncryptedPassword);
                if (obfuscatedString == null || obfuscatedString.isEmpty()) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_invalid_encrypted_password, KerberosRealmPaths.getKerberosEncryptedPassword()));
                }
            }
            catch (ObfuscationException e) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_invalid_encrypted_password, KerberosRealmPaths.getKerberosEncryptedPassword()));
            }
        } else if (StringUtils.isNotBlank((String)this.kerberosEncryptedPassword) && this.isLdapGatewayConnection()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_password_not_required, KerberosRealmPaths.getKerberosEncryptedPassword()));
        }
    }

    private void validateKeyDistributionCenters() {
        if (this.keyDistributionCenters != null && this.isDirectConnection()) {
            if (!KerberosConfigUtil.isAutoGenerateKrb5ConfFile()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_no_visibility_for_kdc, KerberosRealmPaths.getKeyDistributionCenters()));
            }
            if (!this.keyDistributionCenters.isEmpty()) {
                for (String keyDistCenter : this.keyDistributionCenters) {
                    if (keyDistCenter != null && !keyDistCenter.isEmpty()) continue;
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_kdc_invalid, KerberosRealmPaths.getKeyDistributionCenters()));
                }
                HashSet<String> set = new HashSet<String>(this.keyDistributionCenters);
                if (set.size() < this.keyDistributionCenters.size()) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_kdc_duplicate_names, KerberosRealmPaths.getKeyDistributionCenters()));
                }
            }
        } else if (this.keyDistributionCenters != null && (this.isLdapGatewayConnection() || this.isLocalValidationConnection())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_kdc_not_required, KerberosRealmPaths.getKeyDistributionCenters()));
        }
    }

    private void validateKeySets() {
        if (this.keySets != null && (this.isDirectConnection() || this.isLocalValidationConnection())) {
            int index = 0;
            for (KerberosKeySet keySet : this.keySets) {
                if (keySet == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.list_cannot_contain_empty_entries, KerberosRealmPaths.getEncryptedKeySet(index)));
                } else if (keySet.getEncryptedKeySet() == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_encrypted_key_set_required, KerberosRealmPaths.getEncryptedKeySet(index)));
                } else {
                    try {
                        KerberosKeySetUtil.fromEncryptedKeySet(null, (String)keySet.getEncryptedKeySet());
                    }
                    catch (Exception e) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_invalid_encrypted_key_set, KerberosRealmPaths.getEncryptedKeySet(index)));
                    }
                }
                ++index;
            }
        } else if (this.keySets != null && this.isLdapGatewayConnection()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_key_set_not_required, KerberosRealmPaths.getKeySets()));
        }
    }

    private void validatePingOneGateway() {
        if (StringUtils.isBlank((String)this.ldapGatewayDataStoreId) && this.isLdapGatewayConnection()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_ldap_gateway_required, KerberosRealmPaths.getLdapGatewayDateStoreRef()));
        } else if (StringUtils.isNotBlank((String)this.ldapGatewayDataStoreId)) {
            if (this.isDirectConnection() || this.isLocalValidationConnection()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_ldap_gateway_not_required, KerberosRealmPaths.getLdapGatewayDateStoreRef()));
            } else {
                LdapDataSource ldapDataSource = MgmtFactory.getDataSourceManager().getLdapDataSource(this.ldapGatewayDataStoreId);
                if (ldapDataSource == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_ldap_datastore_not_found, KerberosRealmPaths.getLdapGatewayDateStoreRef(), new Object[]{this.ldapGatewayDataStoreId}));
                } else if (!ldapDataSource.isGatewayEnabled()) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_ldap_datastore_not_gateway_enabled, KerberosRealmPaths.getLdapGatewayDateStoreRef(), new Object[]{this.ldapGatewayDataStoreId}));
                }
            }
        }
    }

    private void validateSuppressDomainNameConcatenation() {
        if (this.isSuppressDomainNameConcatenation != null && (this.isLdapGatewayConnection() || this.isLocalValidationConnection())) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_suppress_domain_name_concatenation_not_required, KerberosRealmPaths.getSuppressDomainNameConcatenation()));
        }
    }

    private void validateRetainPreviousKeysOnPasswordChange() {
        if (this.isRetainPreviousKeysOnPasswordChange != null && this.isLdapGatewayConnection()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realm_retain_previous_keys_on_password_change_not_required, KerberosRealmPaths.getRetainPreviousKeysOnPasswordChange()));
        }
    }

    private boolean isDirectConnection() {
        return KerberosConnectionType.DIRECT.equals((Object)this.connectionType);
    }

    private boolean isLdapGatewayConnection() {
        return KerberosConnectionType.LDAP_GATEWAY.equals((Object)this.connectionType);
    }

    private boolean isLocalValidationConnection() {
        return KerberosConnectionType.LOCAL_VALIDATION.equals((Object)this.connectionType);
    }

    public static class Builder {
        private String kerberosRealmId;
        private String kerberosRealmName;
        private List<String> keyDistributionCenters;
        private String kerberosUsername;
        private String kerberosPassword;
        private String kerberosEncryptedPassword;
        private List<KerberosKeySet> keySets;
        private boolean isCreate;
        private KerberosConnectionType connectionType;
        private String ldapGatewayDataStoreId;
        private Boolean isRetainPreviousKeysOnPasswordChange;
        private Boolean isSuppressDomainNameConcatenation;

        public Builder setKerberosRealmId(String kerberosRealmId) {
            this.kerberosRealmId = kerberosRealmId;
            return this;
        }

        public Builder setKerberosRealmName(String kerberosRealmName) {
            this.kerberosRealmName = kerberosRealmName;
            return this;
        }

        public Builder setKeyDistributionCenters(List<String> keyDistributionCenters) {
            this.keyDistributionCenters = keyDistributionCenters;
            return this;
        }

        public Builder setKerberosUsername(String kerberosUsername) {
            this.kerberosUsername = kerberosUsername;
            return this;
        }

        public Builder setKerberosPassword(String kerberosPassword) {
            this.kerberosPassword = kerberosPassword;
            return this;
        }

        public Builder setKerberosEncryptedPassword(String kerberosEncryptedPassword) {
            this.kerberosEncryptedPassword = kerberosEncryptedPassword;
            return this;
        }

        public Builder setKeySets(List<KerberosKeySet> keySets) {
            this.keySets = keySets;
            return this;
        }

        public Builder setCreate(boolean isCreate) {
            this.isCreate = isCreate;
            return this;
        }

        public Builder setConnectionType(KerberosConnectionType connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public Builder setLdapGatewayDataStoreId(String ldapGatewayDataStoreId) {
            this.ldapGatewayDataStoreId = ldapGatewayDataStoreId;
            return this;
        }

        public Builder setRetainPreviousKeysOnPasswordChange(Boolean isRetainPreviousKeysOnPasswordChange) {
            this.isRetainPreviousKeysOnPasswordChange = isRetainPreviousKeysOnPasswordChange;
            return this;
        }

        public Builder setSuppressDomainNameConcatenation(Boolean isSuppressDomainNameConcatenation) {
            this.isSuppressDomainNameConcatenation = isSuppressDomainNameConcatenation;
            return this;
        }

        public KerberosRealmValidator build() {
            return new KerberosRealmValidator(this);
        }
    }
}

