/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.KerberosRealmsSettingsPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.KerberosConfigUtil;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;

public class KerberosRealmsSettingsValidator
extends AbstractValidator {
    private static final int KDC_TIMEOUT_MIN = 1;
    private static final int KDC_TIMEOUT_MAX = 600;
    private static final int KDC_RETRIES_MIN = 1;
    private static final int KDC_RETRIES_MAX = 10;
    private static final int KEY_SET_RETENTION_PERIOD_MINS_MIN = 0;
    private static final int KEY_SET_RETENTION_PERIOD_MINS_MAX = 10080;
    private String kdcTimeout;
    private String kdcRetries;
    private Boolean forceTcp;
    private String keySetRetentionPeriodMins;

    public KerberosRealmsSettingsValidator(Builder builder) {
        this.kdcTimeout = builder.kdcTimeout;
        this.kdcRetries = builder.kdcRetries;
        this.forceTcp = builder.forceTcp;
        this.keySetRetentionPeriodMins = builder.keySetRetentionPeriodMins;
        if (this.keySetRetentionPeriodMins == null) {
            this.keySetRetentionPeriodMins = "";
        }
    }

    public boolean validate() {
        if (KerberosConfigUtil.isAutoGenerateKrb5ConfFile()) {
            this.validateKdcTimeout();
            this.validateKdcRetries();
        }
        this.validateKeySetRetentionPeriodMins();
        this.validateConditionalVisibility();
        return !this.hasErrors();
    }

    private void validateConditionalVisibility() {
        if (!KerberosConfigUtil.isAutoGenerateKrb5ConfFile()) {
            if (this.kdcTimeout != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realms_settings_no_visibility, KerberosRealmsSettingsPaths.getKdcTimeout()));
            }
            if (this.kdcRetries != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realms_settings_no_visibility, KerberosRealmsSettingsPaths.getKdcRetries()));
            }
            if (this.forceTcp != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realms_settings_no_visibility, KerberosRealmsSettingsPaths.getForceTcp()));
            }
        }
    }

    private void validateKdcTimeout() {
        if (StringUtils.isBlank((String)this.kdcTimeout)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realms_settings_kdc_timeout_required, KerberosRealmsSettingsPaths.getKdcTimeout()));
        } else {
            try {
                Integer kdcTimeoutValue = Integer.valueOf(this.kdcTimeout);
                if (kdcTimeoutValue < 1 || kdcTimeoutValue > 600) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realms_settings_kdc_timeout_format, KerberosRealmsSettingsPaths.getKdcTimeout(), new Object[]{1, 600}));
                }
            }
            catch (NumberFormatException e) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realms_settings_kdc_timeout_format, KerberosRealmsSettingsPaths.getKdcTimeout(), new Object[]{1, 600}));
            }
        }
    }

    private void validateKdcRetries() {
        if (StringUtils.isBlank((String)this.kdcRetries)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realms_settings_kdc_retries_required, KerberosRealmsSettingsPaths.getKdcRetries()));
        } else {
            try {
                Integer kdcRetriesValue = Integer.valueOf(this.kdcRetries);
                if (kdcRetriesValue < 1 || kdcRetriesValue > 10) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realms_settings_kdc_retries_format, KerberosRealmsSettingsPaths.getKdcRetries(), new Object[]{1, 10}));
                }
            }
            catch (NumberFormatException e) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realms_settings_kdc_retries_format, KerberosRealmsSettingsPaths.getKdcRetries(), new Object[]{1, 10}));
            }
        }
    }

    private void validateKeySetRetentionPeriodMins() {
        try {
            Integer keySetRetentionPeriodMinsValue = Integer.valueOf(this.keySetRetentionPeriodMins);
            if (keySetRetentionPeriodMinsValue < 0 || keySetRetentionPeriodMinsValue > 10080) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realms_settings_key_set_retention_period_format, KerberosRealmsSettingsPaths.getKeySetRetentionPeriodMins(), new Object[]{0, 10080}));
            }
        }
        catch (NumberFormatException e) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.kerberos_realms_settings_key_set_retention_period_format, KerberosRealmsSettingsPaths.getKeySetRetentionPeriodMins(), new Object[]{0, 10080}));
        }
    }

    public static class Builder {
        private String kdcTimeout;
        private String kdcRetries;
        private Boolean forceTcp;
        private String keySetRetentionPeriodMins;

        public Builder setKdcTimeout(String kdcTimeout) {
            this.kdcTimeout = kdcTimeout;
            return this;
        }

        public Builder setKdcRetries(String kdcRetries) {
            this.kdcRetries = kdcRetries;
            return this;
        }

        public Builder setForceTcp(Boolean forceTcp) {
            this.forceTcp = forceTcp;
            return this;
        }

        public Builder setKeySetRetentionPeriodMins(String keySetRetentionPeriodMins) {
            this.keySetRetentionPeriodMins = keySetRetentionPeriodMins;
            return this;
        }

        public KerberosRealmsSettingsValidator build() {
            return new KerberosRealmsSettingsValidator(this);
        }
    }
}

