/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.HashSet;
import java.util.List;

public class LdapAttributesValidator
extends AbstractValidator {
    private final List<String> providedAttributes;
    private final List<String> allLdapAttributes;
    private final String fieldPath;

    public LdapAttributesValidator(List<String> providedAttributes, List<String> allLdapAttributes, String fieldPath) {
        this.providedAttributes = providedAttributes;
        this.allLdapAttributes = allLdapAttributes;
        this.fieldPath = fieldPath;
    }

    public boolean validate() {
        HashSet<String> attributeSet = new HashSet<String>(this.providedAttributes);
        if (attributeSet.size() != this.providedAttributes.size()) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_attribute_source_search_attribute_duplicate, this.fieldPath));
        }
        this.allLdapAttributes.add("Subject DN");
        attributeSet.forEach(attribute -> {
            String[] attributeWithoutOption = attribute.split(";", 2);
            if (!this.allLdapAttributes.contains(attributeWithoutOption[0])) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_attribute_source_search_attribute_invalid, this.fieldPath, new Object[]{attribute}));
            }
        });
        return !this.hasErrors();
    }
}

