/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.LdapDataStore;
import com.pingidentity.admin.api.model.fieldpaths.LdapDataStorePaths;
import com.pingidentity.admin.api.validator.AdvancedLdapDataStoreValidator;
import com.pingidentity.admin.api.validator.DataStoreBaseValidator;
import com.pingidentity.admin.api.validator.LdapDefaultConnectionMismatchValidator;
import com.pingidentity.admin.api.validator.LdapHostnameValidator;
import com.pingidentity.admin.api.validator.LdapTagConfigValidator;
import com.pingidentity.admin.api.validator.SecretReferenceValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.pf.common.api.validator.Validator;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PingOneConnectionsManager;

public class LdapDataStoreValidator
extends DataStoreBaseValidator {
    private static final PingOneConnectionsManager connectionsMgr = MgmtFactory.getPingOneConnectionsManager();
    private final String hostnames;
    private final String authenticationMethod;
    private final boolean bindAnonymously;
    private final String userDN;
    private final String userCredentials;
    private final String clientTlsCertificate;
    private final boolean useSsl;
    private final boolean useDnsSrvRecord;
    private final boolean useSecretManager;
    private final boolean bypassExternalValidation;
    private final boolean useStartTLS;

    private LdapDataStoreValidator(Builder builder) {
        String credentials;
        this.isCreate = builder.isCreate;
        this.id = builder.id;
        this.name = builder.name;
        this.encryptedPassword = builder.encryptedPassword;
        this.hostnames = builder.hostnames;
        this.authenticationMethod = builder.authenticationMethod;
        this.bindAnonymously = builder.bindAnonymously;
        this.userDN = builder.userDN;
        this.userCredentials = builder.userCredentials;
        this.clientTlsCertificate = builder.clientTlsCertificate;
        this.useSsl = builder.useSsl;
        this.useDnsSrvRecord = builder.useDnsSrvRecord;
        this.useSecretManager = builder.useSecretManager;
        this.bypassExternalValidation = builder.bypassExternalValidation;
        this.useStartTLS = builder.useStartTLS;
        if (builder.advancedLdapDataStoreValidator != null) {
            this.addValidator((Validator)builder.advancedLdapDataStoreValidator);
        }
        if (builder.ldapDataSourceTagValidator != null) {
            this.addValidator((Validator)builder.ldapDataSourceTagValidator);
        }
        if (builder.ldapDefaultConnectionMismatchValidator != null) {
            this.addValidator((Validator)builder.ldapDefaultConnectionMismatchValidator);
        }
        if (builder.validateHostname) {
            this.addValidator((Validator)new LdapHostnameValidator(this.useDnsSrvRecord, this.useSsl, this.hostnames, LdapDataStorePaths.getHostnames()));
        }
        String string = credentials = builder.useSecretManager ? this.userCredentials : this.encryptedPassword;
        if (!builder.bindAnonymously && (SecretReferenceUtil.isSecretReference((String)credentials) || builder.useSecretManager)) {
            this.addValidator((Validator)new SecretReferenceValidator(credentials, LdapDataStorePaths.getEncryptedPassword()));
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        this.validateLdapSslTls();
        this.validateAuth();
        return !this.hasErrors();
    }

    @Override
    public boolean requirePasswordCheck() {
        return !this.bindAnonymously && this.clientTlsCertificate == null;
    }

    private void validateLdapSslTls() {
        if (this.useStartTLS && this.useSsl) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_ssl_or_start_tls, LdapDataStorePaths.getUseSsl()));
        }
    }

    private void validateAuth() {
        if (!this.bindAnonymously) {
            if (StringUtils.isNotBlank((String)this.userDN) && this.clientTlsCertificate != null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_multiple_auth_methods_provided, null));
            } else if (StringUtils.isNotBlank((String)this.userDN) || "simple".equals(this.authenticationMethod)) {
                if (StringUtils.isBlank((String)this.userDN)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_username_required, LdapDataStorePaths.getUserDN()));
                }
                if (StringUtils.isBlank((String)this.userCredentials) && StringUtils.isBlank((String)this.encryptedPassword)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_password_required, LdapDataStorePaths.getPassword()));
                }
                if (!this.useSecretManager && StringUtils.isNotBlank((String)this.userCredentials) && SecretReferenceUtil.isSecretReference((String)this.userCredentials)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_invalid_password_secret_reference, LdapDataStorePaths.getPassword()));
                }
            } else if (StringUtils.isNotBlank((String)this.clientTlsCertificate) || "clientTlsCert".equals(this.authenticationMethod)) {
                if (!this.useSsl && !this.useStartTLS) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_use_ssl_or_start_tls_required, LdapDataStorePaths.getUseSsl()));
                }
                if (StringUtils.isBlank((String)this.clientTlsCertificate)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_certificate_required, LdapDataStorePaths.getClientTlsCertificate()));
                }
                if (StringUtils.isNotBlank((String)this.clientTlsCertificate) && MgmtFactory.getSslAuthPkCertManager().getPkCert(this.clientTlsCertificate) == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_certificate_not_found, LdapDataStorePaths.getClientTlsCertificate(), new Object[]{this.clientTlsCertificate}));
                }
            } else {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_missing_auth_method, null));
            }
        }
    }

    public static class Builder {
        private boolean validateHostname = true;
        private boolean isCreate;
        private String id;
        private String hostnames;
        private String authenticationMethod;
        private boolean bindAnonymously;
        private String userDN;
        private String userCredentials;
        private String encryptedPassword;
        private String clientTlsCertificate;
        private boolean useSecretManager = false;
        private boolean useSsl;
        private boolean useDnsSrvRecord;
        private String name;
        private boolean bypassExternalValidation;
        private AdvancedLdapDataStoreValidator advancedLdapDataStoreValidator;
        private LdapTagConfigValidator ldapDataSourceTagValidator;
        private LdapDefaultConnectionMismatchValidator ldapDefaultConnectionMismatchValidator;
        private boolean useStartTLS;

        public Builder withDataStore(LdapDataStore dataStore) {
            this.id = dataStore.getId();
            this.hostnames = LDAPUtil.joinServerUrls(dataStore.getHostnames());
            this.bindAnonymously = BooleanUtils.toBooleanDefaultIfNull((Boolean)dataStore.isBindAnonymously(), (boolean)false);
            this.clientTlsCertificate = dataStore.getClientTlsCertificateRef() != null ? dataStore.getClientTlsCertificateRef().getId() : null;
            this.userDN = dataStore.getUserDN();
            this.userCredentials = dataStore.getPassword();
            this.useSsl = BooleanUtils.toBooleanDefaultIfNull((Boolean)dataStore.isUseSsl(), (boolean)false);
            this.encryptedPassword = dataStore.getEncryptedPassword();
            this.name = dataStore.getName();
            this.useStartTLS = BooleanUtils.toBooleanDefaultIfNull((Boolean)dataStore.isUseStartTLS(), (boolean)false);
            return this;
        }

        public Builder setCreate(boolean isCreate) {
            this.isCreate = isCreate;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setHostnames(String hostnames) {
            this.hostnames = hostnames;
            return this;
        }

        public Builder setAuthenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        public Builder setBindAnonymously(boolean bindAnonymously) {
            this.bindAnonymously = bindAnonymously;
            return this;
        }

        public Builder setUserDN(String userDN) {
            this.userDN = userDN;
            return this;
        }

        public Builder setUserCredentials(String userCredentials) {
            this.userCredentials = userCredentials;
            return this;
        }

        public Builder setUseSecretManager(boolean useSecretManager) {
            this.useSecretManager = useSecretManager;
            return this;
        }

        public Builder setClientTlsCertificate(String clientTlsCertificate) {
            this.clientTlsCertificate = clientTlsCertificate;
            return this;
        }

        public Builder setUseSsl(boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder setUseDnsSrvRecord(boolean useDnsSrvRecord) {
            this.useDnsSrvRecord = useDnsSrvRecord;
            return this;
        }

        public Builder setEncryptedPassword(String encryptedPassword) {
            this.encryptedPassword = encryptedPassword;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setAdvancedLdapDataStoreValidator(AdvancedLdapDataStoreValidator advancedLdapDataStoreValidator) {
            this.advancedLdapDataStoreValidator = advancedLdapDataStoreValidator;
            return this;
        }

        public Builder setLdapDataSourceTagValidator(LdapTagConfigValidator ldapDataSourceTagValidator) {
            this.ldapDataSourceTagValidator = ldapDataSourceTagValidator;
            return this;
        }

        public Builder setValidateHostname(boolean validateHostname) {
            this.validateHostname = validateHostname;
            return this;
        }

        public Builder setLdapDefaultConnectionMismatchValidator(LdapDefaultConnectionMismatchValidator ldapDefaultConnectionMismatchValidator) {
            this.ldapDefaultConnectionMismatchValidator = ldapDefaultConnectionMismatchValidator;
            return this;
        }

        public Builder setIsBypassExternalValidation(boolean bypassExternalValidation) {
            this.bypassExternalValidation = bypassExternalValidation;
            return this;
        }

        public Builder setUseStartTLS(boolean useStartTLS) {
            this.useStartTLS = useStartTLS;
            return this;
        }

        public LdapDataStoreValidator build() {
            return new LdapDataStoreValidator(this);
        }
    }
}

