/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.LdapType;
import com.pingidentity.admin.api.model.PingOneLdapGatewayDataStore;
import com.pingidentity.admin.api.model.fieldpaths.LdapDataStorePaths;
import com.pingidentity.admin.api.model.fieldpaths.PingOneLdapGatewayDataStorePaths;
import com.pingidentity.admin.api.validator.DataStoreBaseValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pingonev2.InvalidGatewayCredentialException;
import com.pingidentity.pingonev2.PingOneEnvironment;
import com.pingidentity.pingonev2.PingOneGateway;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.sourceid.saml20.domain.PingOneConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PingOneConnectionsManager;

public class LdapGatewayDataStoreValidator
extends DataStoreBaseValidator {
    private static final PingOneConnectionsManager connectionsMgr = MgmtFactory.getPingOneConnectionsManager();
    private final String pingOneConnection;
    private final String pingOneEnvironment;
    private final String pingOneGateway;
    private final boolean bypassExternalValidation;
    private final boolean isAdminUI;
    private final List<String> binaryAttributes;
    private final LdapType ldapType;
    private Boolean useSSL;
    private Boolean useStartTLS;

    private LdapGatewayDataStoreValidator(Builder builder) {
        this.isCreate = builder.isCreate;
        this.id = builder.id;
        this.name = builder.name;
        this.pingOneConnection = builder.pingOneConnection;
        this.pingOneEnvironment = builder.pingOneEnvironment;
        this.pingOneGateway = builder.pingOneGateway;
        this.bypassExternalValidation = builder.bypassExternalValidation;
        this.binaryAttributes = builder.binaryAttributes;
        this.useSSL = builder.useSSL;
        this.useStartTLS = builder.useStartTLS;
        this.ldapType = builder.ldapType;
        this.isAdminUI = builder.isAdminUI;
    }

    @Override
    public boolean validate() {
        super.validate();
        this.validatePingOne();
        this.validateBinaryAttributes();
        return !this.hasErrors();
    }

    @Override
    public boolean requirePasswordCheck() {
        return false;
    }

    public Boolean getUseSSL() {
        return this.useSSL;
    }

    public Boolean getUseStartTLS() {
        return this.useStartTLS;
    }

    private void validatePingOne() {
        if (!this.isAdminUI && StringUtils.isBlank((String)this.pingOneConnection)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_gateway_data_store_pingone_connection_required, PingOneLdapGatewayDataStorePaths.getPingOneConnectionRef()));
        }
        if (StringUtils.isBlank((String)this.pingOneEnvironment)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_gateway_data_store_pingone_environment_required, PingOneLdapGatewayDataStorePaths.getPingOneEnvironmentId()));
        }
        if (StringUtils.isBlank((String)this.pingOneGateway)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_gateway_data_store_pingone_gateway_required, PingOneLdapGatewayDataStorePaths.getPingOneLdapGatewayId()));
        }
        if (StringUtils.isNotBlank((String)this.pingOneConnection) && StringUtils.isNotBlank((String)this.pingOneEnvironment) && StringUtils.isNotBlank((String)this.pingOneGateway)) {
            PingOneConnection connection = connectionsMgr.getConnection(this.pingOneConnection);
            if (connection == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_gateway_data_store_pingone_connection_not_found, PingOneLdapGatewayDataStorePaths.getPingOneConnectionRef(), new Object[]{this.pingOneConnection}));
            } else {
                this.validateJwtClaims(connection);
                if (!connection.isActive()) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_gateway_data_store_pingone_connection_is_not_active, PingOneLdapGatewayDataStorePaths.getPingOneConnectionRef(), new Object[]{connection.getName(), this.pingOneConnection}));
                }
                if (!this.bypassExternalValidation) {
                    try {
                        Optional<PingOneEnvironment> environment = connection.getEnvironments(false).stream().filter(p -> p.getId().equals(this.pingOneEnvironment)).findFirst();
                        if (!environment.isPresent()) {
                            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_gateway_data_store_pingone_environment_not_found, PingOneLdapGatewayDataStorePaths.getPingOneEnvironmentId(), new Object[]{this.pingOneEnvironment}));
                        } else {
                            Optional<PingOneGateway> gateway = connection.getGateways(this.pingOneEnvironment, false).stream().filter(p -> p.getId().equals(this.pingOneGateway)).findFirst();
                            if (!gateway.isPresent()) {
                                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_gateway_data_store_pingone_gateway_not_found, PingOneLdapGatewayDataStorePaths.getPingOneLdapGatewayId(), new Object[]{this.pingOneGateway}));
                            } else if (!gateway.get().isLDAPGateway()) {
                                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_gateway_data_store_pingone_gateway_is_not_ldap_type, PingOneLdapGatewayDataStorePaths.getPingOneLdapGatewayId(), new Object[]{this.pingOneGateway}));
                            } else {
                                this.useSSL = this.validateSslStartTLS(this.useSSL, "TLS", gateway.get(), PingOneLdapGatewayDataStorePaths.getUseSSL(), ApiMessageKey.ldap_gateway_data_store_pingone_gateway_does_not_use_ssl, ApiMessageKey.ldap_gateway_data_store_pingone_gateway_supports_ldaps_but_usessl_flag_is_false);
                                this.useStartTLS = this.validateSslStartTLS(this.useStartTLS, "StartTLS", gateway.get(), PingOneLdapGatewayDataStorePaths.getUseStartTLS(), ApiMessageKey.ldap_gateway_data_store_pingone_gateway_does_not_use_startTLS, ApiMessageKey.ldap_gateway_data_store_pingone_gateway_supports_startTLS_but_useStartTLS_flag_is_false);
                                LdapType type = LdapType.fromPingOneVendor(gateway.get().getVendor());
                                if (!type.equals((Object)this.ldapType)) {
                                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_gateway_data_store_type_different_than_pingone_gateway, PingOneLdapGatewayDataStorePaths.getLdapType(), new Object[]{this.ldapType.name(), type.name()}));
                                }
                            }
                        }
                    }
                    catch (InvalidGatewayCredentialException | IOException throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private boolean validateSslStartTLS(Boolean secureConnection, String gatewayConnectionSecureTypeName, PingOneGateway pingOneGateway, String secureConnectionTypeApiPath, ApiMessageKey pingoneGatewayDisabledSecureConnection, ApiMessageKey pingoneGatewayEnabledSecureConnectionLdapDisabled) {
        boolean gatewayConnectionSecureEnabled = pingOneGateway.getConnectionSecurity().equals(gatewayConnectionSecureTypeName);
        if (secureConnection != null && secureConnection.booleanValue() && !gatewayConnectionSecureEnabled) {
            this.appendError(ValidationErrorFactory.getInstance().create(pingoneGatewayDisabledSecureConnection, secureConnectionTypeApiPath, new Object[]{pingOneGateway}));
        } else if (secureConnection != null && !secureConnection.booleanValue() && gatewayConnectionSecureEnabled) {
            this.appendError(ValidationErrorFactory.getInstance().create(pingoneGatewayEnabledSecureConnectionLdapDisabled, secureConnectionTypeApiPath, new Object[]{pingOneGateway}));
        } else {
            return gatewayConnectionSecureEnabled;
        }
        return secureConnection;
    }

    private void validateBinaryAttributes() {
        if (this.binaryAttributes != null) {
            int index = 0;
            for (String binaryAttribute : this.binaryAttributes) {
                if (StringUtils.isBlank((String)binaryAttribute)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_binary_attribute_blank, LdapDataStorePaths.getBinaryAttribute(index)));
                }
                ++index;
            }
        }
    }

    private void validateJwtClaims(PingOneConnection connection) {
        try {
            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().setSkipAllValidators().build();
            JwtClaims jwtClaims = jwtConsumer.processToClaims(connection.getCredential());
            if (!jwtClaims.hasClaim("directLdapUrl")) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_gateway_data_store_pingone_connection_credential_missing_claim, PingOneLdapGatewayDataStorePaths.getPingOneConnectionRef(), new Object[]{"directLdapUrl"}));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Builder {
        public LdapType ldapType;
        private boolean isCreate;
        private boolean isAdminUI;
        private String id;
        private String name;
        private String pingOneConnection;
        private String pingOneEnvironment;
        private String pingOneGateway;
        private boolean bypassExternalValidation;
        private Boolean useSSL;
        private Boolean useStartTLS;
        private List<String> binaryAttributes = null;

        public Builder withDataStore(PingOneLdapGatewayDataStore dataStore) {
            this.id = dataStore.getId();
            this.name = dataStore.getName();
            this.pingOneConnection = dataStore.getPingOneConnectionRef() != null ? dataStore.getPingOneConnectionRef().getId() : null;
            this.pingOneEnvironment = dataStore.getPingOneEnvironmentId();
            this.pingOneGateway = dataStore.getPingOneLdapGatewayId();
            return this;
        }

        public Builder setCreate(boolean isCreate) {
            this.isCreate = isCreate;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setPingOneConnection(String pingOneConnection) {
            this.pingOneConnection = pingOneConnection;
            return this;
        }

        public Builder setPingOneEnvironment(String pingOneEnvironment) {
            this.pingOneEnvironment = pingOneEnvironment;
            return this;
        }

        public Builder setPingOneGateway(String pingOneGateway) {
            this.pingOneGateway = pingOneGateway;
            return this;
        }

        public Builder setIsBypassExternalValidation(boolean bypassExternalValidation) {
            this.bypassExternalValidation = bypassExternalValidation;
            return this;
        }

        public Builder binaryAttributes(List<String> binaryAttributes) {
            this.binaryAttributes = binaryAttributes;
            return this;
        }

        public Builder useSSL(Boolean useSSL) {
            this.useSSL = useSSL;
            return this;
        }

        public Builder useStartTLS(Boolean useStartTLS) {
            this.useStartTLS = useStartTLS;
            return this;
        }

        public Builder isAdminUI(boolean isAdminUI) {
            this.isAdminUI = isAdminUI;
            return this;
        }

        public Builder ldapType(LdapType ldapType) {
            this.ldapType = ldapType;
            return this;
        }

        public LdapGatewayDataStoreValidator build() {
            return new LdapGatewayDataStoreValidator(this);
        }
    }
}

