/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.ldap.LDAPUtil;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;

public class LdapHostnameValidator
extends AbstractValidator {
    private boolean useDnsSrvRecord;
    private String hostnames;
    private boolean useSsl;
    private String fieldPath;

    public LdapHostnameValidator(boolean useDnsSrvRecord, boolean useSsl, String hostnames, String fieldPath) {
        this.useDnsSrvRecord = useDnsSrvRecord;
        this.useSsl = useSsl;
        this.hostnames = hostnames;
        this.fieldPath = fieldPath;
    }

    private boolean startsWithLdapSchema(String hostname) {
        return hostname.startsWith("ldap://") || hostname.startsWith("ldaps://");
    }

    private void validateHostNamesWithDnsSrvRecordEnabled() {
        if (StringUtils.isNotBlank((String)this.hostnames)) {
            String[] hosts = LDAPUtil.splitServerUrls((String)this.hostnames);
            if (hosts.length != 1) {
                ValidationError singleHostName = ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_hostname_single_hostname_allowed_with_dns_srv, this.fieldPath);
                this.appendError(singleHostName);
            } else if (this.startsWithLdapSchema(hosts[0])) {
                ValidationError hostNameStartWithSchema = ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_hostname_starts_with_schema, this.fieldPath, new Object[]{hosts[0]});
                this.appendError(hostNameStartWithSchema);
            }
        }
    }

    private boolean isValidUri(String url) {
        try {
            String reconstitutedUrl = this.useSsl ? "ldaps://" + url : "ldap://" + url;
            URI uri = new URI(reconstitutedUrl);
            if (StringUtils.isBlank((String)uri.getHost())) {
                return false;
            }
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    private void validateHostnames() {
        if (this.useDnsSrvRecord) {
            this.validateHostNamesWithDnsSrvRecordEnabled();
        } else if (StringUtils.isBlank((String)this.hostnames)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_hostname_invalid, this.fieldPath));
        } else {
            for (String hostname : LDAPUtil.splitServerUrls((String)this.hostnames)) {
                if (this.startsWithLdapSchema(hostname)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_hostname_starts_with_schema, this.fieldPath, new Object[]{hostname}));
                    continue;
                }
                if (StringUtils.isBlank((String)hostname)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_hostname_invalid, this.fieldPath));
                }
                if (this.isValidUri(hostname)) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_data_store_hostname_invalid, this.fieldPath));
            }
        }
    }

    public boolean validate() {
        this.validateHostnames();
        return !this.hasErrors();
    }
}

