/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.Substituter;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang.StringUtils;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;

public class LdapNameValidator
extends CompositeValidator {
    private final String name;
    private final ApiMessageKey malformedErrorKey;
    private final ApiMessageKey substitutionErrorKey;
    private final String fieldPath;
    private boolean usingSubstituteSyntax = false;
    private final Collection<String> availableAttributes;
    private static final String SUBSTITUTION_REGEX = ".*\\$\\{([^${}]*)\\}.*";
    private static final Pattern pattern = Pattern.compile(".*\\$\\{([^${}]*)\\}.*");
    private final ConfigStore config = ConfigStoreFarm.getConfig(((Object)((Object)this)).getClass());
    static final String SKIP_LDAP_NAME_SUBSTITUTION_VALIDATION = "skip-ldap-name-substitution-validation";

    public LdapNameValidator(String name, Collection<String> availableAttributes, ApiMessageKey malformedErrorKey, ApiMessageKey substitutionErrorKey, String fieldPath) {
        this.name = name;
        this.availableAttributes = availableAttributes;
        this.malformedErrorKey = malformedErrorKey;
        this.substitutionErrorKey = substitutionErrorKey;
        this.fieldPath = fieldPath;
        if (name != null) {
            Matcher matcher = pattern.matcher(name);
            this.usingSubstituteSyntax = matcher.matches();
        }
    }

    @Override
    public boolean validate() {
        super.validate();
        if (StringUtils.isNotBlank((String)this.name)) {
            if (this.usingSubstituteSyntax) {
                if (!Substituter.checkSubstituteValues((String)this.name, this.availableAttributes) && !this.config.getBooleanValue(SKIP_LDAP_NAME_SUBSTITUTION_VALIDATION, false)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(this.substitutionErrorKey, this.fieldPath));
                }
            } else {
                try {
                    new LdapName(this.name);
                }
                catch (InvalidNameException e) {
                    this.appendError(ValidationErrorFactory.getInstance().create(this.malformedErrorKey, this.fieldPath));
                }
            }
        }
        return !this.hasErrors();
    }
}

