/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.DataStoreFilterBaseValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.Substituter;
import com.pingidentity.common.util.ldap.LDAPUtil;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;

public class LdapSearchFilterValidator
extends DataStoreFilterBaseValidator {
    private final String ldapFilter;
    private final Collection<String> availableVars;
    private final String varSourceName;
    private final ApiMessageKey filterRequiredKey;
    private final ApiMessageKey filterVarInvalidKey;
    private final String fieldPath;
    private final boolean validateVars;
    private final String searchScope;
    private final boolean isBypassExternalValidation;

    public LdapSearchFilterValidator(String ldapFilter, ApiMessageKey filterRequiredKey, String fieldPath, String searchScope) {
        this.ldapFilter = ldapFilter;
        this.filterRequiredKey = filterRequiredKey;
        this.fieldPath = fieldPath;
        this.filterVarInvalidKey = null;
        this.availableVars = null;
        this.varSourceName = null;
        this.validateVars = false;
        this.searchScope = searchScope;
        this.isBypassExternalValidation = false;
    }

    public LdapSearchFilterValidator(String ldapFilter, Collection<String> availableVars, String varSourceName, ApiMessageKey filterRequiredKey, ApiMessageKey filterVarInvalidKey, String fieldPath, String searchScope, boolean isBypassExternalValidation) {
        this.ldapFilter = ldapFilter;
        this.filterRequiredKey = filterRequiredKey;
        this.fieldPath = fieldPath;
        this.filterVarInvalidKey = filterVarInvalidKey;
        this.availableVars = availableVars == null ? Collections.emptySet() : availableVars;
        this.varSourceName = varSourceName;
        this.validateVars = true;
        this.searchScope = searchScope;
        this.isBypassExternalValidation = isBypassExternalValidation;
    }

    public boolean validate() {
        if (!"OBJECT_SCOPE".equals(this.searchScope) && StringUtils.isBlank((String)this.ldapFilter)) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.filterRequiredKey, this.fieldPath));
        } else if (!(!this.validateVars || StringUtils.isBlank((String)this.ldapFilter) || Substituter.checkSubstituteValues((String)this.ldapFilter, this.availableVars) || this.isBypassExternalValidation && this.areNonDsSubstitutable(this.ldapFilter, this.availableVars))) {
            this.appendError(ValidationErrorFactory.getInstance().create(this.filterVarInvalidKey, this.fieldPath, new Object[]{this.varSourceName}));
        }
        if (!StringUtils.isBlank((String)this.ldapFilter) && !LDAPUtil.validateFilter((String)this.ldapFilter)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.ldap_attribute_source_filter_invalid, this.fieldPath));
        }
        return !this.hasErrors();
    }
}

