/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.ConnectionPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.util.license.LicenseConnectionGroup;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.license.LicenseObject;

public class LicenseConnectionValidator {
    private static LicenseConnectionValidator instance = new LicenseConnectionValidator();

    public static LicenseConnectionValidator getInstance() {
        return instance;
    }

    protected LicenseConnectionValidator() {
    }

    public List<ValidationError> validate(ConnectionBase existingConnection, String licenseConnectionGroup, boolean browserSsoProfileEnabled, boolean wsTrustStsEnabled) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (StringUtils.isNotEmpty((String)licenseConnectionGroup)) {
            if (!this.doesLicenseUseConnectionGroups()) {
                errors.add(ValidationErrorFactory.getInstance().create(ApiMessageKey.license_no_connection_groups_defined, ConnectionPaths.getLicenseConnectionGroup()));
            } else if (!this.getAvailableLicenseConnectionGroupNames(existingConnection, browserSsoProfileEnabled, wsTrustStsEnabled).contains(licenseConnectionGroup)) {
                errors.add(ValidationErrorFactory.getInstance().create(ApiMessageKey.license_connection_group_invalid, ConnectionPaths.getLicenseConnectionGroup(), new Object[]{licenseConnectionGroup}));
            }
        }
        int numOfLicenseConnectionsNeeded = this.getNumberOfLicenseConnectionsNeeded(browserSsoProfileEnabled, wsTrustStsEnabled);
        if (existingConnection == null && !this.canAddConnections(numOfLicenseConnectionsNeeded)) {
            errors.add(ValidationErrorFactory.getInstance().create(ApiMessageKey.license_not_enough_connections, null));
        }
        return errors;
    }

    public List<LicenseConnectionGroup> getAvailableLicenseConnectionGroups(ConnectionBase existingConnection, boolean browserSsoProfileEnabled, boolean wsTrustStsEnabled) {
        int numOfLicenseConnectionsNeeded = this.getNumberOfLicenseConnectionsNeeded(browserSsoProfileEnabled, wsTrustStsEnabled);
        if (numOfLicenseConnectionsNeeded == 0) {
            numOfLicenseConnectionsNeeded = 1;
        }
        return this.getAvailableLicenseConnectionGroups(existingConnection, numOfLicenseConnectionsNeeded);
    }

    protected List<String> getAvailableLicenseConnectionGroupNames(ConnectionBase existingConnection, boolean browserSsoProfileEnabled, boolean wsTrustStsEnabled) {
        List<LicenseConnectionGroup> availableGroups = this.getAvailableLicenseConnectionGroups(existingConnection, browserSsoProfileEnabled, wsTrustStsEnabled);
        ArrayList<String> result = new ArrayList<String>();
        for (LicenseConnectionGroup grp : availableGroups) {
            result.add(grp.getGroupName());
        }
        return result;
    }

    protected int getNumberOfLicenseConnectionsNeeded(boolean browserSsoProfileEnabled, boolean wsTrustStsEnabled) {
        int numOfLicenseConnectionsNeeded = 0;
        if (browserSsoProfileEnabled) {
            ++numOfLicenseConnectionsNeeded;
        }
        if (wsTrustStsEnabled) {
            ++numOfLicenseConnectionsNeeded;
        }
        return numOfLicenseConnectionsNeeded;
    }

    protected boolean doesLicenseUseConnectionGroups() {
        return LicenseManager.isConnectionGroupDefined();
    }

    protected List<LicenseConnectionGroup> getAvailableLicenseConnectionGroups(ConnectionBase conn, int numOfConnectionsNeeded) {
        return LicenseManager.getAvailableLicenseGroups((LicenseObject)conn, (int)numOfConnectionsNeeded);
    }

    protected boolean canAddConnections(int numOfConnectionsNeeded) {
        return LicenseManager.canAddConnection((int)numOfConnectionsNeeded);
    }
}

