/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.google.common.base.Charsets;
import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.LicenseFile;
import com.pingidentity.admin.api.model.fieldpaths.LicensePaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.B64;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.util.license.LicenseManager;

public class LicenseValidator
extends AbstractValidator {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String inputLicense;
    private final LicenseFile inputLicenseDocView;

    public LicenseValidator(LicenseFile inputLicenseView) {
        this.inputLicenseDocView = inputLicenseView;
    }

    public boolean validate() {
        block4: {
            ArrayList warnings;
            block3: {
                String inputBase64License = this.inputLicenseDocView.getFileData();
                ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
                if (StringUtils.isEmpty((String)inputBase64License)) {
                    this.appendError(errorFactory.create(ApiMessageKey.field_required, LicensePaths.getFileData(), new Object[]{LicensePaths.getFileData()}));
                    return !this.hasErrors();
                }
                this.inputLicense = new String(B64.decodeToString((String)inputBase64License).getBytes(Charsets.UTF_8), Charsets.UTF_8);
                ArrayList errors = new ArrayList();
                warnings = new ArrayList();
                LicenseManager.testLicenseForImport((String)this.inputLicense, errors, warnings);
                if (errors.isEmpty()) break block3;
                for (String error : errors) {
                    this.appendError(errorFactory.create(ApiMessageKey.license_invalid, LicensePaths.getFileData(), new Object[]{error}));
                }
                break block4;
            }
            if (warnings.isEmpty()) break block4;
            this.log.warn((Object)"The new license may cause any existing connections that use the unlicensed features to fail.");
            for (String warning : warnings) {
                this.log.warn((Object)warning);
            }
        }
        return !this.hasErrors();
    }

    public String getDecodedLicense() {
        return this.inputLicense;
    }
}

