/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.MetadataLifetimeSettings;
import com.pingidentity.admin.api.model.fieldpaths.ProtocolMetadataPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;

public class LifetimeSettingsValidator
extends AbstractValidator {
    private final int cacheDuration;
    private final long reloadDelay;

    public LifetimeSettingsValidator(MetadataLifetimeSettings settings) {
        this.cacheDuration = settings.getCacheDuration();
        this.reloadDelay = settings.getReloadDelay();
    }

    public boolean validate() {
        if (this.cacheDuration <= 0 || this.cacheDuration > 999999999) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.cache_duration_illegal_value, ProtocolMetadataPaths.getCacheDuration()));
        }
        if (this.reloadDelay <= 0L || this.reloadDelay > 999999999L) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.reload_delay_illegal_value, ProtocolMetadataPaths.getReloadDelay()));
        }
        return !this.hasErrors();
    }
}

