/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.oauth.LockoutMaxMaliciousActionsType;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.simple.IntegerValidator;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;

public class LockoutMaxMaliciousActionsValidator
extends AbstractValidator {
    private static final int LOCKOUT_MAX_MALICIOUS_ACTIONS_MIN_VALUE = 0;
    private static final int LOCKOUT_MAX_MALICIOUS_ACTIONS_MAX_VALUE = 65535;
    private static final String LOCKOUT_MAX_MALICIOUS_ACTIONS_TYPE_FRIENDLY_NAME = "Malicious Actions Count For Lockout Type";
    private static final String LOCKOUT_MAX_MALICIOUS_ACTIONS_FRIENDLY_NAME = "Malicious Actions Count For Lockout";
    private final ValidationErrorFactory errorFactory;
    private final String lockoutMaxMaliciousActionsType;
    private final String lockoutMaxMaliciousActions;
    private final String lockoutMaxMaliciousActionsTypeFieldPath;
    private final String lockoutMaxMaliciousActionsFieldPath;

    public static LockoutMaxMaliciousActionsValidator newInstance(String lockoutMaxMaliciousActionsType, String lockoutMaxMaliciousActions, String lockoutMaxMaliciousActionsTypeFieldPath, String lockoutMaxMaliciousActionsFieldPath) {
        return new LockoutMaxMaliciousActionsValidator(lockoutMaxMaliciousActionsType, lockoutMaxMaliciousActions, lockoutMaxMaliciousActionsTypeFieldPath, lockoutMaxMaliciousActionsFieldPath);
    }

    public static LockoutMaxMaliciousActionsValidator newClientSettingsInstance(String lockoutMaxMaliciousActionsType, String lockoutMaxMaliciousActions, String lockoutMaxMaliciousActionsTypeFieldPath, String lockoutMaxMaliciousActionsFieldPath) {
        return new LockoutMaxMaliciousActionsValidator(lockoutMaxMaliciousActionsType, lockoutMaxMaliciousActions, lockoutMaxMaliciousActionsTypeFieldPath, lockoutMaxMaliciousActionsFieldPath);
    }

    private LockoutMaxMaliciousActionsValidator(ValidationErrorFactory errorFactory, String lockoutMaxMaliciousActionsType, String lockoutMaxMaliciousActions, String lockoutMaxMaliciousActionsTypeFieldPath, String lockoutMaxMaliciousActionsFieldPath) {
        this.errorFactory = errorFactory;
        this.lockoutMaxMaliciousActionsType = lockoutMaxMaliciousActionsType;
        this.lockoutMaxMaliciousActions = lockoutMaxMaliciousActions;
        this.lockoutMaxMaliciousActionsTypeFieldPath = lockoutMaxMaliciousActionsTypeFieldPath;
        this.lockoutMaxMaliciousActionsFieldPath = lockoutMaxMaliciousActionsFieldPath;
    }

    public LockoutMaxMaliciousActionsValidator(String lockoutMaxMaliciousActionsType, String lockoutMaxMaliciousActions, String lockoutMaxMaliciousActionsTypeFieldPath, String lockoutMaxMaliciousActionsFieldPath) {
        this(ValidationErrorFactory.getInstance(), lockoutMaxMaliciousActionsType, lockoutMaxMaliciousActions, lockoutMaxMaliciousActionsTypeFieldPath, lockoutMaxMaliciousActionsFieldPath);
    }

    public boolean validate() {
        IntegerValidator maliciousActionsLengthValidator;
        NotBlankValidator lockoutMaxMaliciousActionsTypeNotBlankValidator = new NotBlankValidator(this.lockoutMaxMaliciousActionsType, LOCKOUT_MAX_MALICIOUS_ACTIONS_TYPE_FRIENDLY_NAME, this.lockoutMaxMaliciousActionsTypeFieldPath);
        if (!lockoutMaxMaliciousActionsTypeNotBlankValidator.validate()) {
            this.appendErrors(lockoutMaxMaliciousActionsTypeNotBlankValidator.getErrors());
        } else if (LockoutMaxMaliciousActionsType.getType(this.lockoutMaxMaliciousActionsType) == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_lockout_max_malicious_actions_type_invalid, this.lockoutMaxMaliciousActionsTypeFieldPath));
        }
        if (StringUtils.isNotBlank((String)this.lockoutMaxMaliciousActions) && "SERVER_DEFAULT".equals(this.lockoutMaxMaliciousActionsType)) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_lockout_max_malicious_actions_value_and_type_mismatch, this.lockoutMaxMaliciousActionsFieldPath));
        }
        if ("OVERRIDE_SERVER_DEFAULT".equals(this.lockoutMaxMaliciousActionsType) && !(maliciousActionsLengthValidator = new IntegerValidator(this.lockoutMaxMaliciousActions, LOCKOUT_MAX_MALICIOUS_ACTIONS_FRIENDLY_NAME, this.lockoutMaxMaliciousActionsFieldPath, true, 0, 65535)).validate()) {
            this.appendErrors(maliciousActionsLengthValidator.getErrors());
        }
        return !this.hasErrors();
    }
}

