/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.LogSettingsPaths;
import com.pingidentity.admin.api.model.systemsettings.LogCategorySettings;
import com.pingidentity.admin.api.model.systemsettings.LogSettings;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.HashSet;
import java.util.List;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class LogSettingsValidator
extends AbstractValidator {
    private LogSettings logSettings;

    public LogSettingsValidator(LogSettings logSettings) {
        this.logSettings = logSettings;
    }

    public boolean validate() {
        this.validateLogCategories();
        return !this.hasErrors();
    }

    private void validateLogCategories() {
        if (this.logSettings.getLogCategories() != null) {
            int index = 0;
            List existingSettingsList = MgmtFactory.getLogSettingsManager().getCategorySettings();
            HashSet<String> seenIds = new HashSet<String>();
            for (LogCategorySettings settings : this.logSettings.getLogCategories()) {
                if (settings.getId() == null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.log_settings_category_id_required, LogSettingsPaths.getLogCategoryId(index)));
                } else {
                    if (!existingSettingsList.stream().anyMatch(existing -> settings.getId().equals(existing.getId()))) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.log_settings_category_id_invalid, LogSettingsPaths.getLogCategoryId(index), new Object[]{"log4j-categories.xml"}));
                    }
                    if (seenIds.contains(settings.getId())) {
                        this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.log_settings_category_id_repeated, LogSettingsPaths.getLogCategoryId(index), new Object[]{settings.getId()}));
                    }
                    seenIds.add(settings.getId());
                }
                ++index;
            }
        }
    }
}

