/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.DistinguishedNameToIdpMap;
import com.pingidentity.admin.api.model.MetadataAttributeRequesterMapping;
import com.pingidentity.admin.api.model.fieldpaths.ProtocolMetadataPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.websso.Protocol;

public class MetadataAttributeRequesterMappingValidator
extends AbstractValidator {
    private final List<DistinguishedNameToIdpMap> issuerDNMapList;
    private final List<DistinguishedNameToIdpMap> subjectDNMapList;
    private final String defaultIdp;
    private final ConnectionManager connManager;

    public MetadataAttributeRequesterMappingValidator(MetadataAttributeRequesterMapping mapping, ConnectionManager connManager) {
        this.issuerDNMapList = mapping.getIssuerDNMapList();
        this.subjectDNMapList = mapping.getSubjectDNMapList();
        this.defaultIdp = mapping.getDefaultIdpEntityId();
        this.connManager = connManager;
    }

    public boolean validate() {
        Collection<IdpConnection> connections = this.getConnections();
        HashMap<String, String> idpMap = new HashMap<String, String>();
        HashSet<String> issuerDNs = new HashSet<String>();
        HashSet<String> subjectDNs = new HashSet<String>();
        for (IdpConnection connection : connections) {
            idpMap.put(connection.getEntityId(), connection.getName());
        }
        this.validateDNMapList(this.issuerDNMapList, issuerDNs, ProtocolMetadataPaths.getIssuerDNMapList(), idpMap);
        this.validateDNMapList(this.subjectDNMapList, subjectDNs, ProtocolMetadataPaths.getSubjectDNMapList(), idpMap);
        if (StringUtils.isBlank((CharSequence)this.defaultIdp)) {
            if (!idpMap.isEmpty()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.idp_entity_id_empty, ProtocolMetadataPaths.getDefaultIdpEntityId()));
            }
        } else if (!idpMap.containsKey(this.defaultIdp)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.idp_connection_not_found, ProtocolMetadataPaths.getDefaultIdpEntityId(), new Object[]{this.defaultIdp}));
        }
        return !this.hasErrors();
    }

    private Collection<IdpConnection> getConnections() {
        ArrayList<IdpConnection> connections = new ArrayList<IdpConnection>();
        for (IdpConnection connection : this.connManager.getFilteredSamlIdpConnections()) {
            if (connection.getProtocol() != Protocol.SAML20 || connection.getAttributeAuthority() == null || !connection.isActive()) continue;
            connections.add(connection);
        }
        connections.sort(ConnectionBase.COMPARE_BY_ENTITY_ID);
        return connections;
    }

    private void validateDNMapList(List<DistinguishedNameToIdpMap> dnMapList, HashSet<String> dnSet, String path, Map<String, String> idpMap) {
        if (dnMapList != null) {
            for (DistinguishedNameToIdpMap dnMap : dnMapList) {
                if (StringUtils.isBlank((CharSequence)dnMap.getDn())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.dn_mapping_empty, path));
                } else if (!dnSet.add(dnMap.getDn())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.duplicate_dn_mapping, path, new Object[]{dnMap.getDn(), path}));
                }
                if (StringUtils.isBlank((CharSequence)dnMap.getIdpEntityId())) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.idp_entity_id_empty, path));
                    continue;
                }
                if (idpMap.containsKey(dnMap.getIdpEntityId())) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.idp_connection_not_found, path, new Object[]{dnMap.getIdpEntityId()}));
            }
        }
    }
}

