/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.MetadataSigningSettings;
import com.pingidentity.admin.api.model.fieldpaths.ProtocolMetadataPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.crypto.CertificateGenerator;
import com.pingidentity.crypto.KeyAlgorithmInfo;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.sourceid.saml20.domain.mgmt.PkCertManager;

public class MetadataSigningSettingsValidator
extends AbstractValidator {
    private String keyAlias;
    private final String signatureAlgorithm;
    private final PkCertManager certManager;
    private final CertificateGenerator certService;

    public MetadataSigningSettingsValidator(MetadataSigningSettings settings, PkCertManager certManager, CertificateGenerator certService) {
        if (settings.getSigningKeyRef() != null) {
            this.keyAlias = settings.getSigningKeyRef().getId();
        }
        this.signatureAlgorithm = settings.getSignatureAlgorithm();
        this.certManager = certManager;
        this.certService = certService;
    }

    public boolean validate() {
        if (this.keyAlias != null) {
            if (this.certManager.getPkCert(this.keyAlias) == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.signing_key_pair_not_found, ProtocolMetadataPaths.getSigningKeyAlias(), new Object[]{this.keyAlias}));
            } else {
                String keyAlgorithm = this.certManager.getPkCert(this.keyAlias).getPublicKeyAlgorithm();
                KeyAlgorithmInfo algorithmInfo = this.certService.getKeyAlgorithmInfo(keyAlgorithm);
                if (this.signatureAlgorithm != null && !this.signatureAlgorithm.equals("SHA1withRSA") && !algorithmInfo.getSignatureAlgorithms().contains(this.signatureAlgorithm)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.illegal_signature_algorithm, ProtocolMetadataPaths.getSignatureAlgorithm()));
                }
            }
        }
        return !this.hasErrors();
    }
}

