/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.MetadataUrl;
import com.pingidentity.admin.api.model.X509File;
import com.pingidentity.admin.api.model.fieldpaths.MetadataUrlPaths;
import com.pingidentity.admin.api.validator.HttpUrlValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.mgmt.MetadataUrlManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class MetadataUrlValidator
extends AbstractValidator {
    private MetadataUrlManager metadataUrlManager = MgmtFactory.getMetadataUrlManager();
    private String url = null;
    private String name = null;
    private boolean isApiCall;
    private boolean isCreate;
    private String metadataId;
    private boolean validateSignature;
    private X509File x509FileData;

    public MetadataUrlValidator(String name, String metadataUrl, boolean isApiCall, boolean validateSignature) {
        this.name = name;
        this.url = metadataUrl;
        this.isApiCall = isApiCall;
        this.validateSignature = validateSignature;
    }

    public MetadataUrlValidator(MetadataUrl metadataUrlCert, boolean isApiCall, boolean isCreate) {
        this.name = metadataUrlCert.getName();
        this.url = metadataUrlCert.getUrl();
        this.isApiCall = isApiCall;
        this.metadataId = metadataUrlCert.getId();
        this.validateSignature = metadataUrlCert.getValidateSignature() == null ? true : metadataUrlCert.getValidateSignature();
        this.x509FileData = metadataUrlCert.getX509File();
        this.isCreate = isCreate;
    }

    public boolean validate() {
        if (this.isCreate && this.metadataId != null && this.metadataUrlManager.getMetadataUrlPair(this.metadataId) != null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.metadata_url_id_exists, MetadataUrlPaths.getId(), new Object[]{this.metadataId}));
        }
        if (StringUtils.isBlank((String)this.name)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.metadata_name_required, MetadataUrlPaths.getName()));
        } else if (this.isApiCall && this.metadataUrlManager.isMetadataUrlNameInUse(this.metadataId, this.name)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.metadata_url_name_exists, MetadataUrlPaths.getName(), new Object[]{this.name}));
        }
        HttpUrlValidator urlValidator = new HttpUrlValidator(this.url, false, MetadataUrlPaths.getUrl());
        boolean validaUrl = urlValidator.validate();
        if (validaUrl) {
            if (!this.validateSignature) {
                if (!ValidationUtil.isValidHttpsUrl((String)this.url)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.metadata_url_disabled_signature_verification_http_url, MetadataUrlPaths.getUrl()));
                }
                if (this.x509FileData != null) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.metadata_url_disabled_signature_verification_http_url, MetadataUrlPaths.getX509File()));
                }
            }
        } else {
            this.appendErrors(urlValidator.getErrors());
        }
        if (this.isApiCall && this.metadataUrlManager.urlExists(this.metadataId, this.url)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.metadata_url_exists, MetadataUrlPaths.getUrl(), new Object[]{this.url}));
        }
        return this.getErrors().isEmpty();
    }
}

