/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.MoveItemRequest;
import com.pingidentity.admin.api.model.fieldpaths.MoveItemRequestPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import org.apache.commons.lang.StringUtils;

public class MoveItemRequestValidator
extends AbstractValidator {
    private final String moveItemId;
    private final MoveItemRequest moveItemRequest;

    public MoveItemRequestValidator(String moveItemId, MoveItemRequest moveItemRequest) {
        this.moveItemId = moveItemId;
        this.moveItemRequest = new MoveItemRequest(moveItemRequest);
    }

    public boolean validate() {
        ValidationError validationError;
        if (this.moveItemRequest.getLocation() == null) {
            validationError = ValidationErrorFactory.getInstance().create(ApiMessageKey.move_item_invalid_location, MoveItemRequestPaths.getLocation());
            this.appendError(validationError);
        } else if ((this.moveItemRequest.getLocation().equals((Object)MoveItemRequest.Location.START) || this.moveItemRequest.getLocation().equals((Object)MoveItemRequest.Location.END)) && StringUtils.isNotBlank((String)this.moveItemRequest.getMoveToId())) {
            validationError = ValidationErrorFactory.getInstance().create(ApiMessageKey.move_item_expect_move_to_id_empty, MoveItemRequestPaths.moveToId());
            this.appendError(validationError);
        } else if ((this.moveItemRequest.getLocation().equals((Object)MoveItemRequest.Location.BEFORE) || this.moveItemRequest.getLocation().equals((Object)MoveItemRequest.Location.AFTER)) && StringUtils.isBlank((String)this.moveItemRequest.getMoveToId())) {
            validationError = ValidationErrorFactory.getInstance().create(ApiMessageKey.move_item_require_move_to_id, MoveItemRequestPaths.moveToId());
            this.appendError(validationError);
        }
        if (this.moveItemId != null && this.moveItemId.equals(this.moveItemRequest.getMoveToId())) {
            validationError = ValidationErrorFactory.getInstance().create(ApiMessageKey.move_item_id_and_move_to_id_same, MoveItemRequestPaths.moveToId(), new Object[]{this.moveItemId});
            this.appendError(validationError);
        }
        return !this.hasErrors();
    }
}

