/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.CryptoProvider;
import com.pingidentity.admin.api.model.NewKeyPairSettings;
import com.pingidentity.admin.api.model.fieldpaths.NewKeyPairSettingsPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.common.util.HostAddressUtils;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.crypto.CertificateGenerator;
import com.pingidentity.crypto.KeyAlgorithmInfo;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pingcommons.crypto.CertificateUtil;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import sun.security.x509.X500Name;

public class NewKeyPairSettingsValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(NewKeyPairSettingsValidator.class);
    private CertificateGenerator certService = MgmtFactory.getCertificateService();
    public static final int MIN_VALID_DAYS = 1;
    private String commonName;
    private List<String> subjectAlternativeNames;
    private String organization;
    private String organizationUnit;
    private String city;
    private String state;
    private String country;
    private String validDaysStr;
    private String keyAlgorithm;
    private String keySizeStr;
    private String signatureAlgorithm;
    private boolean validateCryptoProvider;
    private CryptoProvider cryptoProvider;
    private int keySize;
    private int validDays = -1;

    public NewKeyPairSettingsValidator(NewKeyPairSettings settings) {
        this.commonName = settings.getCommonName();
        this.subjectAlternativeNames = settings.getSubjectAlternativeNames();
        this.organization = settings.getOrganization();
        this.organizationUnit = settings.getOrganizationUnit();
        this.city = settings.getCity();
        this.state = settings.getState();
        this.country = settings.getCountry();
        this.validDaysStr = Integer.toString(settings.getValidDays());
        this.keyAlgorithm = settings.getKeyAlgorithm();
        if (settings.getKeySize() != null) {
            this.keySizeStr = settings.getKeySize().toString();
        }
        this.signatureAlgorithm = settings.getSignatureAlgorithm();
    }

    public NewKeyPairSettingsValidator(String commonName, String organization, String organizationUnit, String city, String state, String country, String validDays, String keyAlgorithm, String keySize, String signatureAlgorithm) {
        this.commonName = commonName;
        this.organization = organization;
        this.organizationUnit = organizationUnit;
        this.city = city;
        this.state = state;
        this.country = country;
        this.validDaysStr = validDays;
        this.keyAlgorithm = keyAlgorithm;
        this.keySizeStr = keySize;
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int getValidDays() {
        return this.validDays;
    }

    public boolean validate() {
        if (StringUtils.isBlank((String)this.commonName)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.new_key_pair_common_name_required, NewKeyPairSettingsPaths.getCommonName()));
        }
        if (this.subjectAlternativeNames != null && !this.subjectAlternativeNames.isEmpty()) {
            for (String name : this.subjectAlternativeNames) {
                if (HostAddressUtils.isIPV4Literal((String)name) || HostAddressUtils.isIPV6Literal((String)name) || HostAddressUtils.isValidDomainName((String)name)) continue;
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.new_key_pair_invalid_subject_alternative_name, NewKeyPairSettingsPaths.getSubjectAlternativeNames() + "@" + name));
            }
        }
        if (StringUtils.isBlank((String)this.organization)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.new_key_pair_organization_required, NewKeyPairSettingsPaths.getOrganization()));
        }
        if (StringUtils.isBlank((String)this.country)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.new_key_pair_country_required, NewKeyPairSettingsPaths.getCountry()));
        } else if (!ValidationUtil.isValidX509CountryEntry((String)this.country)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.new_key_pair_invalid_country, NewKeyPairSettingsPaths.getCountry()));
        }
        try {
            new X500Name(CertificateUtil.buildSubject((String)this.commonName, (String)this.organizationUnit, (String)this.organization, (String)this.city, (String)this.state, (String)this.country));
        }
        catch (IOException io) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.new_key_pair_invalid_x500_name, null));
            log.debug((Object)("There was an error validating the distinguished name of this certificate: " + io));
        }
        if (StringUtils.isBlank((String)this.validDaysStr)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.new_key_pair_valid_days_required, NewKeyPairSettingsPaths.getValidDays()));
        } else {
            try {
                this.validDays = Integer.parseInt(this.validDaysStr);
            }
            catch (NumberFormatException io) {
                // empty catch block
            }
            if (this.validDays < 1 || this.validDays > this.certService.getMaxValidDays()) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.new_key_pair_invalid_valid_days, NewKeyPairSettingsPaths.getValidDays(), new Object[]{1, this.certService.getMaxValidDays()}));
            }
        }
        KeyAlgorithmInfo algorithmInfo = null;
        if (StringUtils.isBlank((String)this.keyAlgorithm)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.new_key_pair_algorithm_required, NewKeyPairSettingsPaths.getKeyAlgorithm()));
        } else {
            algorithmInfo = this.certService.getKeyAlgorithmInfo(this.keyAlgorithm);
            if (algorithmInfo == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.new_key_pair_invalid_algorithm, NewKeyPairSettingsPaths.getKeyAlgorithm()));
            }
        }
        this.keySize = -1;
        if (StringUtils.isBlank((String)this.keySizeStr)) {
            if (algorithmInfo != null) {
                this.keySize = algorithmInfo.getDefaultKeySize();
            }
        } else {
            try {
                this.keySize = Integer.parseInt(this.keySizeStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.keySize == -1 || algorithmInfo != null && !algorithmInfo.getKeySizes().contains(this.keySize)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.new_key_pair_invalid_key_size, NewKeyPairSettingsPaths.getKeySize()));
            }
        }
        if (!StringUtils.isBlank((String)this.signatureAlgorithm) && algorithmInfo != null && !algorithmInfo.getSignatureAlgorithms().contains(this.signatureAlgorithm)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.new_key_pair_invalid_signature_algorithm, NewKeyPairSettingsPaths.getSignatureAlgorithm()));
        }
        if (this.validateCryptoProvider && !PropertyInfo.isHSMHybrid() && this.cryptoProvider != null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.crypto_provider_invalid, NewKeyPairSettingsPaths.getCryptoProvider()));
        }
        return !this.hasErrors();
    }

    public void setValidateCryptoProvider(boolean validateCryptoProvider) {
        this.validateCryptoProvider = validateCryptoProvider;
    }

    public void setCryptoProvider(CryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public void checkDuplicateId(String id, PkCertManager pkCertManager) {
        if (pkCertManager.getPkCert(id) != null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.new_key_pair_duplicate_id, NewKeyPairSettingsPaths.getId()));
        }
    }
}

