/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.apache.commons.lang.StringUtils;

public class NotBlankValidator
extends AbstractValidator {
    private final String fieldValue;
    private final String friendlyFieldName;
    private final String fieldPath;

    public NotBlankValidator(String fieldValue, String friendlyFieldName, String fieldPath) {
        this.fieldValue = fieldValue;
        this.friendlyFieldName = friendlyFieldName;
        this.fieldPath = fieldPath;
    }

    public boolean validate() {
        if (this.fieldValue == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_required, this.fieldPath, new Object[]{this.friendlyFieldName}));
            return false;
        }
        if (StringUtils.isBlank((String)this.fieldValue)) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.field_blank, this.fieldPath, new Object[]{this.friendlyFieldName}));
            return false;
        }
        return true;
    }
}

