/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.NotificationPublishersSettingsPath;
import com.pingidentity.admin.api.model.plugin.NotificationPublishersSettings;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import org.sourceid.saml20.domain.NotificationSenderPluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationPublisherPluginManager;

public class NotificationPublishersSettingsValidator
extends AbstractValidator {
    private static final NotificationPublisherPluginManager NOTIFICATION_PUBLISHER_PLUGIN_MGR = MgmtFactory.getNotificationPublisherPluginManager();
    private static final ValidationErrorFactory ERROR_FACTORY = ValidationErrorFactory.getInstance();
    private NotificationPublishersSettings settings = null;
    private NotificationSenderPluginInstance publisherInstanceToUpdate = null;

    public NotificationPublishersSettingsValidator(NotificationPublishersSettings settings) {
        this.settings = settings;
    }

    public boolean validate() {
        if (this.settings != null && this.settings.getDefaultNotificationPublisherRef() != null && this.settings.getDefaultNotificationPublisherRef().getId() != null) {
            String defaultInstanceId = this.settings.getDefaultNotificationPublisherRef().getId();
            this.publisherInstanceToUpdate = (NotificationSenderPluginInstance)NOTIFICATION_PUBLISHER_PLUGIN_MGR.getInstance(defaultInstanceId);
            if (this.publisherInstanceToUpdate == null) {
                this.appendError(ERROR_FACTORY.create(ApiMessageKey.notification_publisher_default_publisher_id_invalid, NotificationPublishersSettingsPath.getDefaultNotificationPublisherRefId(), new Object[]{defaultInstanceId}));
            }
        } else if (!NOTIFICATION_PUBLISHER_PLUGIN_MGR.getInstances().isEmpty()) {
            this.appendError(ERROR_FACTORY.create(ApiMessageKey.notification_publisher_default_publisher_required, NotificationPublishersSettingsPath.getDefaultNotificationPublisherRefId()));
        }
        return !this.hasErrors();
    }

    public NotificationSenderPluginInstance getDefaultInstance() {
        return this.publisherInstanceToUpdate;
    }
}

