/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.ResourceLink;
import com.pingidentity.admin.api.model.SourceType;
import com.pingidentity.admin.api.model.SourceTypeIdKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.OAuthApcMappingPaths;
import com.pingidentity.admin.api.model.oauth.ApcToPersistentGrantMapping;
import com.pingidentity.admin.api.model.oauth.SourceToUserKeyMapping;
import com.pingidentity.admin.api.validator.AttributeSetSourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.OAuthSourceToUserKeyValidator;
import com.pingidentity.admin.api.validator.SourceTypeValidatorBuilder;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthApcMappingValidator
extends OAuthSourceToUserKeyValidator {
    private static final C2cContractManager APC_MGR = MgmtFactory.getC2cContractManager();
    private C2cContract instance;
    private String mappingId;

    public OAuthApcMappingValidator(ApcToPersistentGrantMapping mapping, ValidatorContext context) {
        super(mapping, context);
        this.mappingId = mapping.getId();
    }

    @Override
    protected void init(SourceToUserKeyMapping mapping) {
        ResourceLink ref = ((ApcToPersistentGrantMapping)mapping).getAuthenticationPolicyContractRef();
        if (ref != null) {
            this.mappingId = ref.getId();
            if (this.mappingId != null) {
                this.instance = APC_MGR.getContract(this.mappingId);
            }
        }
    }

    @Override
    public boolean validate() {
        if (this.mappingId == null) {
            this.appendError(ApiMessageKey.oauth_apc_mapping_apc_id_required, OAuthApcMappingPaths.getApcRefId(), new Object[0]);
            return false;
        }
        if (this.instance == null) {
            this.appendError(ApiMessageKey.authentication_policy_contract_not_found, OAuthApcMappingPaths.getApcRefId(), this.mappingId);
            return false;
        }
        super.validate();
        return !this.hasErrors();
    }

    private AttributeSetSourceTypeValidatorBuilder createContractTypeBuilder() {
        if (this.instance == null) {
            return null;
        }
        Set srcNames = this.instance.getAllAttributeNames();
        return new AttributeSetSourceTypeValidatorBuilder(srcNames, SourceType.AUTHENTICATION_POLICY_CONTRACT);
    }

    private void appendError(ApiMessageKey errorId, String fieldPath, Object ... params) {
        this.appendError(ValidationErrorFactory.getInstance().create(errorId, fieldPath, params));
    }

    @Override
    protected Set<String> getSourceCoreSubstitutionVariables() {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getAllAttributeNames();
    }

    @Override
    protected void addAdditionalSourceValidators(Map<SourceTypeIdKey, SourceTypeValidatorBuilder> validSources) {
        AttributeSetSourceTypeValidatorBuilder builder = this.createContractTypeBuilder();
        if (builder != null) {
            validSources.put(new SourceTypeIdKey(SourceType.AUTHENTICATION_POLICY_CONTRACT), builder);
        }
    }

    @Override
    protected String getSourceName() {
        return "authentication policy contract";
    }
}

