/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientPaths;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientSettingsPaths;
import com.pingidentity.admin.api.model.oauth.ClientCertificateIssuerType;
import com.pingidentity.admin.api.model.oauth.ClientRegistrationOIDCPolicy;
import com.pingidentity.admin.api.model.oauth.ClientSettings;
import com.pingidentity.admin.api.model.oauth.DeviceFlowSettingType;
import com.pingidentity.admin.api.model.oauth.DynamicClientRegistration;
import com.pingidentity.admin.api.model.oauth.PersistentGrantLifetimeType;
import com.pingidentity.admin.api.model.oauth.PersistentGrantLifetimeUnit;
import com.pingidentity.admin.api.validator.CIBADefaultsValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.LockoutMaxMaliciousActionsValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.RefreshTokenRollingGracePeriodValidator;
import com.pingidentity.admin.api.validator.RefreshTokenRollingIntervalValidator;
import com.pingidentity.admin.api.validator.ResourceIdValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.simple.IntegerValidator;
import com.pingidentity.pf.common.api.validator.AbstractValidator;
import com.pingidentity.pf.common.api.validator.Validator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.PersistentGrantLifetimeHelper;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicies;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderInfo;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;

public class OAuthClientDefaultsValidator
extends CompositeValidator {
    private static final String PERSISTENT_GRANT_EXPIRATION_TIME = "Persistent Grant Expiration Time";
    private static final String PERSISTENT_GRANT_EXPIRATION_TIME_UNIT = "Persistent Grant Expiration Time Unit";
    private static final String PERSISTENT_GRANT_IDLE_TIMEOUT = "Persistent Grant Idle Timeout";
    private static final String PERSISTENT_GRANT_IDLE_TIMEOUT_TIME_UNIT = "Persistent Grant Idle Timeout Time Unit";
    public static final String CLIENT_AUTHENTICATION_CERTIFICATE = "Client Authentication Certificate";
    private final DynamicClientRegistration client;
    private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
    private static final int PERISTENT_GRANT_EXPIRATION_TIME_MAX = 1000;
    private static final int PERISTENT_GRANT_EXPIRATION_TIME_MIN = 0;
    private static final int PERISTENT_GRANT_IDLE_TIMEOUT_MAX = 1000;
    private static final int PERISTENT_GRANT_IDLE_TIMEOUT_MIN = 0;

    public OAuthClientDefaultsValidator(ClientSettings clientSettings) {
        this.client = clientSettings.getDynamicClientRegistration();
        this.addValidator((Validator)new GrantTimeSettingValidator(this.client.getPersistentGrantExpirationType(), this.client.getPersistentGrantExpirationTime(), this.client.getPersistentGrantExpirationTimeUnit(), 0L, 1000L, ClientSettingsPaths.getGrantExpirationTime(), PERSISTENT_GRANT_EXPIRATION_TIME, ClientSettingsPaths.getGrantExpirationTimeUnit(), PERSISTENT_GRANT_EXPIRATION_TIME_UNIT, ApiMessageKey.oauth_client_mgmt_grant_exp_range));
        this.addValidator((Validator)new GrantIdleTimeSettingValidator(this.client.getPersistentGrantExpirationType(), this.client.getPersistentGrantExpirationTime(), this.client.getPersistentGrantExpirationTimeUnit(), this.client.getPersistentGrantIdleTimeoutType(), this.client.getPersistentGrantIdleTimeout(), this.client.getPersistentGrantIdleTimeoutTimeUnit(), 0L, 1000L, ClientSettingsPaths.getGrantIdleTimeout(), PERSISTENT_GRANT_IDLE_TIMEOUT, ClientSettingsPaths.getGrantIdleTimeoutTimeUnit(), PERSISTENT_GRANT_IDLE_TIMEOUT_TIME_UNIT, ApiMessageKey.oauth_client_mgmt_grant_idle_timeout));
        this.addValidator((Validator)new DeviceFlowFieldsValidator(this.client));
        this.addValidator((Validator)new CIBADefaultsValidator(String.valueOf(this.client.getCibaPollingInterval())));
        this.addValidator((Validator)new TokenExchangeSettingsValidator(this.client));
        String refreshTokenRollingIntervalTimeUnit = this.client.getRefreshTokenRollingIntervalTimeUnit() == null ? "h" : this.client.getRefreshTokenRollingIntervalTimeUnit().getId();
        this.addValidator((Validator)new RefreshTokenRollingIntervalValidator(this.client.getRefreshTokenRollingIntervalType() == null ? null : this.client.getRefreshTokenRollingIntervalType().getId(), this.client.getRefreshTokenRollingInterval(), refreshTokenRollingIntervalTimeUnit));
        String refreshTokenRollingGracePeriodType = this.client.getRefreshTokenRollingGracePeriodType().getId();
        String refreshTokenRollingGracePeriod = this.client.getRefreshTokenRollingGracePeriod() != null ? String.valueOf(this.client.getRefreshTokenRollingGracePeriod()) : null;
        this.addValidator((Validator)RefreshTokenRollingGracePeriodValidator.newClientSettingsInstance(refreshTokenRollingGracePeriodType, refreshTokenRollingGracePeriod));
        String lockoutMaxMaliciousActionsType = this.client.getLockoutMaxMaliciousActionsType().getValue();
        String lockoutMaxMaliciousActions = this.client.getLockoutMaxMaliciousActions() != null ? String.valueOf(this.client.getLockoutMaxMaliciousActions()) : null;
        this.addValidator((Validator)LockoutMaxMaliciousActionsValidator.newClientSettingsInstance(lockoutMaxMaliciousActionsType, lockoutMaxMaliciousActions, ClientSettingsPaths.getLockoutMaxMaliciousActionsTypePath(), ClientSettingsPaths.getLockoutMaxMaliciousActionsPath()));
    }

    @Override
    public boolean validate() {
        BearerAccessTokenMgmtPluginInstance instance;
        if (this.hasErrors()) {
            return false;
        }
        super.validate();
        if (this.client.getDefaultAccessTokenManagerRef() != null && (instance = (BearerAccessTokenMgmtPluginInstance)MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstance(this.client.getDefaultAccessTokenManagerRef().getId())) == null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_default_token_manager_id_invalid, ClientSettingsPaths.getDefaultAccessTokenManager(), new Object[]{this.client.getDefaultAccessTokenManagerRef().getId()}));
        }
        if (ClientCertificateIssuerType.CERTIFICATE == this.client.getClientCertIssuerType()) {
            ResourceIdValidator resourceIdValidator = new ResourceIdValidator(this.client.getClientCertIssuerRef(), ClientSettingsPaths.getClientIssuerRef(), CLIENT_AUTHENTICATION_CERTIFICATE);
            if (resourceIdValidator.validate()) {
                String id = this.client.getClientCertIssuerRef().getId();
                if (!this.isValidIssuerDn(id)) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_clientauth_match_dn, ClientSettingsPaths.getClientIssuerRef(), new Object[]{id}));
                }
            } else {
                this.appendErrors(resourceIdValidator.getErrors());
            }
        } else if (this.client.getClientCertIssuerRef() != null) {
            this.appendError(this.errorFactory.create(ApiMessageKey.field_not_required, ClientSettingsPaths.getClientIssuerRef(), new Object[]{CLIENT_AUTHENTICATION_CERTIFICATE}));
        }
        if (this.client.getOidcPolicy() != null) {
            OpenIdConnectProviderPolicyManager connectProviderPolicyManager;
            OpenIdConnectProviderPolicy policy;
            Set supportedSigningAlgs;
            String idTokenSigningAlgorithm;
            ClientRegistrationOIDCPolicy oidcPolicy = this.client.getOidcPolicy();
            if (oidcPolicy.getIdTokenSigningAlgorithm() != null && StringUtils.isNotBlank((String)(idTokenSigningAlgorithm = oidcPolicy.getIdTokenSigningAlgorithm().getId())) && !(supportedSigningAlgs = OpenIdConnectProviderInfo.idTokenSigningAlgMapSupportedWithNoneHmac().keySet()).contains(idTokenSigningAlgorithm)) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_signing_alg_invalid, ClientSettingsPaths.getIdTokenSigningAlgorithm(), new Object[]{"ID Token", supportedSigningAlgs}));
            }
            if (oidcPolicy.getPolicyGroup() != null && (policy = (connectProviderPolicyManager = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class)).getPolicy()).getPolicyGroup(oidcPolicy.getPolicyGroup().getId()) == null) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_group_policy_invalid, ClientSettingsPaths.getPolicyGroup()));
            }
        }
        return !this.hasErrors();
    }

    private boolean isValidIssuerDn(String id) {
        TrustedCAsManager mgr = MgmtFactory.getTrustedCAsManager();
        return mgr.getCert(id) != null;
    }

    public static class TokenExchangeSettingsValidator
    extends AbstractValidator {
        private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();
        private final String tokenExchangeProcessorPolicyId;

        public TokenExchangeSettingsValidator(String tokenExchangeProcessorPolicyId) {
            this.tokenExchangeProcessorPolicyId = tokenExchangeProcessorPolicyId;
        }

        public TokenExchangeSettingsValidator(DynamicClientRegistration clientRegistration) {
            this.tokenExchangeProcessorPolicyId = clientRegistration.getTokenExchangeProcessorPolicyRef() != null ? clientRegistration.getTokenExchangeProcessorPolicyRef().getId() : null;
        }

        public boolean validate() {
            TokenExchangeProcessorPolicies policies;
            if (StringUtils.isNotEmpty((String)this.tokenExchangeProcessorPolicyId) && !(policies = MgmtFactory.getTokenExchangeProcessorPolicyManager().getTokenExchangeProcessorPolicies()).containsInstance(this.tokenExchangeProcessorPolicyId)) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_group_policy_invalid, ClientPaths.getTokenExchangeProcessorPolicy(), new Object[]{"Token Exchange Processor Policy ID"}));
            }
            return !this.hasErrors();
        }
    }

    public static class DeviceFlowFieldsValidator
    extends AbstractValidator {
        private final String deviceFlowSettingType;
        private final String userAuthzUrlOverride;
        private final String pendingAuthzTimeoutOverride;
        private final String devicePollingIntervalOverride;
        private final Boolean bypassActivationCodeConfirmationOverride;

        public DeviceFlowFieldsValidator(String deviceFlowSettingType, String userAuthzBaseUrlOverride, String pendingAuthzTimeoutOverride, String devicePollingIntervalOverride, Boolean bypassActivationCodeConfirmationOverride) {
            this.deviceFlowSettingType = deviceFlowSettingType;
            this.userAuthzUrlOverride = userAuthzBaseUrlOverride;
            this.pendingAuthzTimeoutOverride = pendingAuthzTimeoutOverride;
            this.devicePollingIntervalOverride = devicePollingIntervalOverride;
            this.bypassActivationCodeConfirmationOverride = bypassActivationCodeConfirmationOverride;
        }

        public DeviceFlowFieldsValidator(DynamicClientRegistration clientRegistration) {
            this.deviceFlowSettingType = clientRegistration.getDeviceFlowSettingType().getId();
            this.userAuthzUrlOverride = clientRegistration.getUserAuthorizationUrlOverride();
            this.pendingAuthzTimeoutOverride = clientRegistration.getPendingAuthorizationTimeoutOverride() != null ? String.valueOf(clientRegistration.getPendingAuthorizationTimeoutOverride()) : null;
            this.devicePollingIntervalOverride = clientRegistration.getDevicePollingIntervalOverride() != null ? String.valueOf(clientRegistration.getDevicePollingIntervalOverride()) : null;
            this.bypassActivationCodeConfirmationOverride = clientRegistration.getBypassActivationCodeConfirmationOverride();
        }

        public boolean validate() {
            IntegerValidator devicePollingIntervalOverrideValidator;
            IntegerValidator pendingAuthorizationTimeoutOverrideValidator;
            String deviceFlowSettingTypePath = ClientSettingsPaths.getDeviceFlowSettingTypePath();
            NotBlankValidator deviceFlowSettingNotBlankValidator = new NotBlankValidator(this.deviceFlowSettingType, "Device Flow Setting", deviceFlowSettingTypePath);
            if (!deviceFlowSettingNotBlankValidator.validate()) {
                this.appendErrors(deviceFlowSettingNotBlankValidator.getErrors());
            } else if (DeviceFlowSettingType.getType(this.deviceFlowSettingType) == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_client_mgmt_default_device_flow_setting_type_invalid, deviceFlowSettingTypePath));
            }
            if (StringUtils.isNotBlank((String)this.userAuthzUrlOverride)) {
                String path = ClientSettingsPaths.getUserAuthorizationUrlOverridePath();
                if (!ValidationUtil.isValidHttpOrHttpsUrl((String)this.userAuthzUrlOverride)) {
                    this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.malformed_url, path, new Object[]{this.userAuthzUrlOverride}));
                }
            }
            if (StringUtils.isNotBlank((String)this.pendingAuthzTimeoutOverride) && !(pendingAuthorizationTimeoutOverrideValidator = new IntegerValidator(this.pendingAuthzTimeoutOverride, "Pending Authorization Timeout Override", ClientSettingsPaths.getPendingAuthorizationTimeoutOverridePath(), false, 1, 3600)).validate()) {
                this.appendErrors(pendingAuthorizationTimeoutOverrideValidator.getErrors());
            }
            if (StringUtils.isNotBlank((String)this.devicePollingIntervalOverride) && !(devicePollingIntervalOverrideValidator = new IntegerValidator(this.devicePollingIntervalOverride, "Device Polling Interval Override", ClientSettingsPaths.getDevicePollingIntervalOverride(), false, 1, 3600)).validate()) {
                this.appendErrors(devicePollingIntervalOverrideValidator.getErrors());
            }
            if (DeviceFlowSettingType.OVERRIDE_SERVER_DEFAULT.equals((Object)DeviceFlowSettingType.getType(this.deviceFlowSettingType)) && StringUtils.isBlank((String)this.userAuthzUrlOverride) && StringUtils.isBlank((String)this.pendingAuthzTimeoutOverride) && StringUtils.isBlank((String)this.devicePollingIntervalOverride) && this.bypassActivationCodeConfirmationOverride == null) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_client_mgmt_default_device_flow_setting_require_override, deviceFlowSettingTypePath));
            }
            return !this.hasErrors();
        }
    }

    public static class GrantIdleTimeSettingValidator
    extends GrantTimeSettingValidator {
        private PersistentGrantLifetimeType maxLifetimeSettingType;
        private Long maxLifeTimeSetting;
        private PersistentGrantLifetimeUnit maxLifetimeSettingUnit;

        public GrantIdleTimeSettingValidator(PersistentGrantLifetimeType maxLifetimeSettingType, Long maxLifeTimeSetting, PersistentGrantLifetimeUnit maxLifetimeSettingUnit, PersistentGrantLifetimeType idleTimeSettingType, Long idleTimeSetting, PersistentGrantLifetimeUnit idleTimeSettingUnit, long minimumTimeSetting, long maximumTimeSetting, String timeSettingPath, String timeSettingField, String timeSettingUnitPath, String timeSettingUnitField, ApiMessageKey incorrectRangeApiMessageKey) {
            super(idleTimeSettingType, idleTimeSetting, idleTimeSettingUnit, minimumTimeSetting, maximumTimeSetting, timeSettingPath, timeSettingField, timeSettingUnitPath, timeSettingUnitField, incorrectRangeApiMessageKey);
            this.maxLifetimeSettingType = maxLifetimeSettingType;
            this.maxLifeTimeSetting = maxLifeTimeSetting;
            this.maxLifetimeSettingUnit = maxLifetimeSettingUnit;
        }

        @Override
        public boolean validate() {
            super.validate();
            if (PersistentGrantLifetimeHelper.isInvalidLocalIdleTimeoutSetting((String)this.getMaxLifetimeSettingType(), (String)this.getMaxLifetimeSetting(), (String)this.getMaxLifetimeSettingUnit(), (String)this.getIdleTimeoutSettingType(), (String)this.getIdleTimeoutSetting(), (String)this.getIdleTimeoutSettingUnit())) {
                if ("SERVER_DEFAULT".equals(this.getMaxLifetimeSettingType())) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_grant_idle_timeout_greater_than_global_max_lifetime, this.timeSettingPath, new Object[]{this.timeSettingField}));
                } else {
                    this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_grant_idle_timeout_greater_than_max_lifetime, this.timeSettingPath, new Object[]{this.timeSettingField}));
                }
            }
            return !this.hasErrors();
        }

        private String getMaxLifetimeSettingType() {
            return this.maxLifetimeSettingType == null ? null : this.maxLifetimeSettingType.getId();
        }

        private String getMaxLifetimeSetting() {
            return this.maxLifeTimeSetting == null ? null : String.valueOf(this.maxLifeTimeSetting);
        }

        private String getMaxLifetimeSettingUnit() {
            return this.maxLifetimeSettingUnit == null ? null : this.maxLifetimeSettingUnit.getId();
        }

        private String getIdleTimeoutSettingType() {
            return this.timeSettingType == null ? null : this.timeSettingType.getId();
        }

        private String getIdleTimeoutSetting() {
            return this.timeSetting == null ? null : String.valueOf(this.timeSetting);
        }

        private String getIdleTimeoutSettingUnit() {
            return this.timeSettingUnit == null ? null : this.timeSettingUnit.getId();
        }
    }

    public static class GrantIdleTimeoutValidator
    extends AbstractValidator {
        private final String idleTimeoutSettingType;
        private final Long idleTimeout;
        private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();

        public GrantIdleTimeoutValidator(String idleTimeoutSettingType, Long idleTimeout) {
            this.idleTimeoutSettingType = idleTimeoutSettingType;
            this.idleTimeout = idleTimeout;
        }

        public boolean validate() {
            if ("OVERRIDE_SERVER_DEFAULT".equals(this.idleTimeoutSettingType) && (this.idleTimeout == null || this.idleTimeout <= 0L || this.idleTimeout >= 1000L)) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_grant_idle_timeout, ClientSettingsPaths.getDefaultAccessTokenManager(), new Object[]{0, 1000}));
            }
            return !this.hasErrors();
        }
    }

    public static class GrantTimeSettingValidator
    extends AbstractValidator {
        private final PersistentGrantLifetimeType timeSettingType;
        private final Long timeSetting;
        private final PersistentGrantLifetimeUnit timeSettingUnit;
        private final long minimumTimeSetting;
        private final long maximumTimeSetting;
        private final String timeSettingPath;
        private final String timeSettingField;
        private final String timeSettingUnitPath;
        private final String timeSettingUnitField;
        private final ApiMessageKey incorrectRangeApiMessageKey;
        private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();

        public GrantTimeSettingValidator(PersistentGrantLifetimeType timeSettingType, Long timeSetting, PersistentGrantLifetimeUnit timeSettingUnit, long minimumTimeSetting, long maximumTimeSetting, String timeSettingPath, String timeSettingField, String timeSettingUnitPath, String timeSettingUnitField, ApiMessageKey incorrectRangeApiMessageKey) {
            this.timeSettingType = timeSettingType;
            this.timeSetting = timeSetting;
            this.timeSettingUnit = timeSettingUnit;
            this.minimumTimeSetting = minimumTimeSetting;
            this.maximumTimeSetting = maximumTimeSetting;
            this.timeSettingPath = timeSettingPath;
            this.timeSettingField = timeSettingField;
            this.timeSettingUnitPath = timeSettingUnitPath;
            this.timeSettingUnitField = timeSettingUnitField;
            this.incorrectRangeApiMessageKey = incorrectRangeApiMessageKey;
        }

        public boolean validate() {
            if (PersistentGrantLifetimeType.OVERRIDE_SERVER_DEFAULT.equals((Object)this.timeSettingType)) {
                if (this.timeSettingUnit == null) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.field_required, this.timeSettingUnitPath, new Object[]{this.timeSettingUnitField}));
                }
                if (this.timeSetting == null) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.field_required, this.timeSettingPath, new Object[]{this.timeSettingField}));
                } else if (this.timeSetting <= this.minimumTimeSetting || this.timeSetting >= this.maximumTimeSetting) {
                    this.appendError(this.errorFactory.create(this.incorrectRangeApiMessageKey, this.timeSettingPath, new Object[]{this.minimumTimeSetting, this.maximumTimeSetting}));
                }
            } else {
                if (this.timeSettingUnit != null) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.field_not_required, this.timeSettingUnitPath, new Object[]{this.timeSettingUnitField}));
                }
                if (this.timeSetting != null) {
                    this.appendError(this.errorFactory.create(ApiMessageKey.field_not_required, this.timeSettingPath, new Object[]{this.timeSettingField}));
                }
            }
            return !this.hasErrors();
        }
    }

    public static class GrantExpirationValidator
    extends AbstractValidator {
        private final String lifetimeType;
        private final Long expirationTime;
        private final ValidationErrorFactory errorFactory = ValidationErrorFactory.getInstance();

        public GrantExpirationValidator(String lifetimeType, Long expirationTime) {
            this.lifetimeType = lifetimeType;
            this.expirationTime = expirationTime;
        }

        public boolean validate() {
            if ("OVERRIDE_SERVER_DEFAULT".equals(this.lifetimeType) && (this.expirationTime == null || this.expirationTime <= 0L || this.expirationTime >= 1000L)) {
                this.appendError(this.errorFactory.create(ApiMessageKey.oauth_client_mgmt_grant_exp_range, ClientSettingsPaths.getDefaultAccessTokenManager(), new Object[]{0, 1000}));
            }
            return !this.hasErrors();
        }
    }
}

