/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.admin.api.validator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientPaths;
import com.pingidentity.admin.api.model.oauth.DeviceFlowSettingType;
import com.pingidentity.admin.api.model.oauth.PersistentGrantLifetimeType;
import com.pingidentity.admin.api.validator.ClientOfflineAccessRequireConsentPromptValidator;
import com.pingidentity.admin.api.validator.ClientRequireOfflineAccessScopeToIssueRefreshTokensValidator;
import com.pingidentity.admin.api.validator.ClientSecretRetentionPeriodValidator;
import com.pingidentity.admin.api.validator.CompositeValidator;
import com.pingidentity.admin.api.validator.ExtendedPropertyValueValidator;
import com.pingidentity.admin.api.validator.HttpUrlValidator;
import com.pingidentity.admin.api.validator.LockoutMaxMaliciousActionsValidator;
import com.pingidentity.admin.api.validator.NotBlankValidator;
import com.pingidentity.admin.api.validator.PartnerUrlValidatorFactory;
import com.pingidentity.admin.api.validator.RefreshTokenRollingGracePeriodValidator;
import com.pingidentity.admin.api.validator.RefreshTokenRollingIntervalValidator;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.admin.api.validator.simple.IntegerValidator;
import com.pingidentity.crypto.X500Util;
import com.pingidentity.pf.common.api.model.oauth.GrantType;
import com.pingidentity.pf.common.api.validator.Validator;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jose4j.jwa.AlgorithmFactory;
import org.jose4j.jwa.AlgorithmFactoryFactory;
import org.jose4j.jwe.KeyManagementAlgorithm;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.common.ValidationUtil;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientAuthenticationType;
import org.sourceid.oauth20.domain.ClientLogoutMode;
import org.sourceid.oauth20.domain.ClientUtil;
import org.sourceid.oauth20.domain.DynamicOAuthClient;
import org.sourceid.oauth20.domain.PersistentGrantLifetimeHelper;
import org.sourceid.oauth20.domain.ScopeUtil;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicies;
import org.sourceid.oauth20.protocol.GrantTypes;
import org.sourceid.oauth20.protocol.ResponseType;
import org.sourceid.openid.ciba.CibaDeliveryMode;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderInfo;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrustedCAsManager;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;
import org.sourceid.util.ObjectMapperFactory;

public class OAuthClientValidator
extends CompositeValidator {
    private static final int PERSISTENT_GRANT_EXPIRATION_TIME_MAX = 1000;
    private static final int PERSISTENT_GRANT_EXPIRATION_TIME_MIN = 0;
    private static final int PERSISTENT_GRANT_IDLE_TIMEOUT_MAX = 1000;
    private static final int PERSISTENT_GRANT_IDLE_TIMEOUT_MIN = 0;
    public static final int CLIENT_ID_MAX = 256;
    public static final int CLIENT_NAME_MAX = 128;
    public static final int SYMMETRIC_KEY_MIN_LENGTH = 128;
    public static final String CLIENT_SUBJECT_DN_LABEL = "Client TLS Certificate Subject DN";
    public static final String CLIENT_ISSUER_DN_LABEL = "Client TLS Certificate Issuer DN";
    public static final String REFRESH_TOKEN_TOLLING_INTERVAL = "Refresh Token Rolling Interval";
    public static final String REFRESH_TOKEN_TOLLING_INTERVAL_TYPE = "Refresh Token Rolling Interval type";
    private boolean validateSectorIdentifierUri = false;
    private static final Logger logger = LogManager.getLogger(OAuthClientValidator.class);
    private static final Map<String, String> friendlyNames = new HashMap<String, String>(){
        {
            this.put("authorization_code", "authorization code");
            this.put("password", "resource owner password credentials");
            this.put("refresh_token", "refresh token");
            this.put("implicit", "implicit");
            this.put("client_credentials", "client credentials");
            this.put("urn:pingidentity.com:oauth2:grant_type:validate_bearer", "access token validation");
            this.put("extension", "extension grants");
            this.put("urn:openid:params:grant-type:ciba", "CIBA");
        }
    };
    public static final Map<String, String> GRANT_TYPE_FRIENDLY_NAMES = Collections.unmodifiableMap(friendlyNames);
    private static final Set<String> VALID_REUSE_PERSISTENT_GRANT_TYPES = new HashSet<String>(Arrays.asList("implicit", "authorization_code", "password"));
    public static final int CIBA_POLLING_INTERVAL_MIN = 1;
    public static final int CIBA_POLLING_INTERVAL_MAX = 3600;
    private static List<Set<String>> responseTypesList = new ArrayList<Set<String>>();
    private boolean stateUIValidation = false;
    private static final String VSCHAR_PATTERN = "[a-zA-Z0-9 !\"#$%&'()*+,-./:;<=>?@\\[\\\\\\]^_`{|}~]+";
    private static final Set<String> explicitDisallowUris;
    protected final Client client;
    private final UniqueIdChecker uniqueIdChecker;
    private final String whitelist = ConfigStoreFarm.getConfig(((Object)((Object)this)).getClass()).getStringValue("client.id.whitelist", "[a-zA-Z0-9 !\"#$%&'()*+,-./:;<=>?@\\[\\\\\\]^_`{|}~]+");
    private boolean useDefaultIdTokenSigningAlgo = false;

    public OAuthClientValidator(Client client, UniqueIdChecker uniqueIdChecker) {
        this.client = client;
        this.uniqueIdChecker = uniqueIdChecker;
        HttpUrlValidator logoValidator = new HttpUrlValidator(client.getLogoUrl(), true, ClientPaths.getLogoUrl());
        this.addValidator((Validator)logoValidator);
        if (!StringUtils.isEmpty((String)this.client.getJwksUrl())) {
            this.addValidator((Validator)PartnerUrlValidatorFactory.getGenericValidator(this.client.getJwksUrl(), false, null));
        }
        ExtendedPropertyValueValidator extParamValidator = new ExtendedPropertyValueValidator(client.getExtendedParams());
        this.addValidator((Validator)extParamValidator);
        this.addValidator((Validator)new RefreshTokenRollingIntervalValidator(client.getRefreshTokenRollingIntervalType() == null ? null : client.getRefreshTokenRollingIntervalType(), client.getRefreshTokenRollingInterval(), client.getRefreshTokenRollingIntervalTimeUnit()));
        this.addValidator((Validator)new ClientSecretRetentionPeriodValidator(client.getSecondarySecretRetentionPeriodType(), client.getSecondarySecretRetentionPeriod()));
        this.addValidator((Validator)new ClientRequireOfflineAccessScopeToIssueRefreshTokensValidator(client.getRequireOfflineAccessScopeToIssueRefreshTokens(), ClientPaths.getRequireOfflineAccessScopeToIssueRefreshTokens()));
        this.addValidator((Validator)new ClientOfflineAccessRequireConsentPromptValidator(client.getOfflineAccessRequireConsentPrompt(), ClientPaths.getOfflineAccessRequireConsentPrompt()));
    }

    private String getClientPersistentGrantExpirationType(Client client) {
        return PersistentGrantLifetimeType.INDEFINITE_EXPIRY.toString().equals(client.getPersistentGrantExpirationType()) ? "NONE" : client.getPersistentGrantExpirationType();
    }

    private String getClientPersistentGrantExpiration(Client client) {
        return client.getPersistentGrantExpirationTime() == null ? null : String.valueOf(client.getPersistentGrantExpirationTime());
    }

    private String getClientPersistentGrantIdleTimeoutType(Client client) {
        return PersistentGrantLifetimeType.INDEFINITE_EXPIRY.toString().equals(client.getPersistentGrantIdleTimeoutType()) ? "NONE" : client.getPersistentGrantIdleTimeoutType();
    }

    private String getClientPersistentGrantIdleTimeout(Client client) {
        return client.getPersistentGrantIdleTimeout() == null ? null : String.valueOf(client.getPersistentGrantIdleTimeout());
    }

    @Override
    public boolean validate() {
        BearerAccessTokenMgmtPluginInstance instance;
        OpenIdConnectProviderPolicy policy;
        Map policyGroups;
        String policyGroupId;
        OpenIdConnectProviderPolicyManager connectPolicyManager;
        block99: {
            Set supportedSigningAlgs;
            String userInfoSigningAlgorithm;
            block98: {
                Set supportedSigningAlgs2;
                Object idleTimeout;
                Long time;
                super.validate();
                String clientId = this.client.getClientId();
                if (StringUtils.isBlank((String)clientId)) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_id_required, ClientPaths.getClientId(), new Object[0]);
                    return false;
                }
                if (clientId.length() > 256) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_id_length, ClientPaths.getClientId(), 256);
                } else if (!this.uniqueIdChecker.isUnique(clientId)) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_id_inuse, ClientPaths.getClientId(), new Object[0]);
                }
                if (!clientId.matches(this.whitelist)) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_id_invalid_chars, ClientPaths.getClientId(), new Object[0]);
                }
                if (this.client.getAllowAuthenticationApiInit()) {
                    if (!this.client.isBypassApprovalPage()) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_approval_page_bypass_required, ClientPaths.getBypassApprovalPage(), new Object[0]);
                    }
                    if (!this.client.isRestrictScopes()) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_restrict_scopes_required, ClientPaths.getRestrictScopes(), new Object[0]);
                    }
                } else {
                    List applications = InUseDetectionUtil.getInstance().getAuthnApiApplicationsUsingClient(this.client.getClientId());
                    if (!applications.isEmpty()) {
                        AuthnApiApplication app = (AuthnApiApplication)applications.get(0);
                        this.appendError(ApiMessageKey.oauth_client_mgmt_client_referenced_by_authentication_api_application, ClientPaths.getAllowAuthenticationApiInit(), app.getName());
                    }
                }
                if (this.client.isRestrictScopes() && this.client.getRestrictedScopes().size() > 0) {
                    for (Object scope : this.client.getRestrictedScopes()) {
                        if (ScopeUtil.getScopeAndGroupNames().contains(scope)) continue;
                        this.appendError(ApiMessageKey.oauth_client_mgmt_scope_invalid, ClientPaths.getRestrictedScopes(), scope);
                    }
                }
                if (this.client.isAllowedExclusiveScopes()) {
                    List exclusiveScopes = this.client.getExclusiveScopes();
                    if (exclusiveScopes == null || exclusiveScopes.isEmpty()) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_exclusive_scope_at_least_one, ClientPaths.getExclusiveScopes(), new Object[0]);
                    } else {
                        for (Object scope : exclusiveScopes) {
                            if (ScopeUtil.getExclusiveScopeAndGroupNames().contains(scope)) continue;
                            this.appendError(ApiMessageKey.oauth_client_mgmt_exclusive_scope_invalid, ClientPaths.getExclusiveScopes(), scope);
                        }
                    }
                }
                if (this.client.isAllowedAuthorizationDetailTypes()) {
                    if (this.client.getGrantTypes().size() == 1 && this.client.getGrantTypes().contains("password")) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_authorization_detail_not_supported_by_password, ClientPaths.getAuthorizationDetailTypes(), new Object[0]);
                    } else {
                        List authorizationDetailTypes = this.client.getAuthorizationDetailTypes();
                        if (authorizationDetailTypes == null || authorizationDetailTypes.isEmpty()) {
                            this.appendError(ApiMessageKey.oauth_client_mgmt_authorization_detail_type_at_least_one, ClientPaths.getAuthorizationDetailTypes(), new Object[0]);
                        } else {
                            Set configuredAuthorizationDetailTypes = MgmtFactory.getAuthorizationDetailTypesManager().getTypes();
                            authorizationDetailTypes.forEach(type -> {
                                if (!configuredAuthorizationDetailTypes.contains(type)) {
                                    this.appendError(ApiMessageKey.oauth_client_mgmt_authorization_detail_type_invalid, ClientPaths.getAuthorizationDetailTypes(), type);
                                }
                            });
                        }
                    }
                }
                if (this.client.isRestrictResponseTypes() && this.client.getRestrictedResponseTypes().isEmpty()) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_response_type_at_least_one, ClientPaths.getRestrictedResponseTypes(), new Object[0]);
                }
                if (this.client.getRestrictedResponseTypes() != null && this.client.getRestrictedResponseTypes().size() > 0) {
                    ArrayList<ResponseType> alreadyAddedResponseTypes = new ArrayList<ResponseType>();
                    ArrayList invalidResponseTypes = new ArrayList();
                    for (String responseTypeStr : this.client.getRestrictedResponseTypes()) {
                        ResponseType responseType = new ResponseType(responseTypeStr, null);
                        if (!responseType.isValidResponseType()) {
                            invalidResponseTypes.add(responseTypeStr);
                            continue;
                        }
                        if (alreadyAddedResponseTypes.stream().anyMatch(respType -> respType.hasExactly(responseType.getParts()))) {
                            this.appendError(ApiMessageKey.oauth_client_mgmt_grant_type_duplicate_response_type, ClientPaths.getRestrictedResponseTypes(), responseTypeStr);
                            continue;
                        }
                        alreadyAddedResponseTypes.add(responseType);
                        if (!Stream.of(responseType.getImpliedGrantTypes()).anyMatch(grantType -> !this.client.isGrantTypeAllowed(grantType))) continue;
                        this.appendError(ApiMessageKey.oauth_client_mgmt_grant_type_response_type_invalid, ClientPaths.getRestrictedResponseTypes(), this.client.getGrantTypes().stream().map(grantTypeId -> "'" + this.getFriendlyName((String)grantTypeId) + "'").collect(Collectors.joining(", ")), "'" + responseTypeStr + "'");
                    }
                    if (invalidResponseTypes.size() > 0) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_response_types_invalid, ClientPaths.getRestrictedResponseTypes(), invalidResponseTypes.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", ")));
                    }
                    if (this.client.getGrantTypes().contains("authorization_code") && alreadyAddedResponseTypes.stream().noneMatch(respType -> respType.has("code"))) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_auth_code_grant_type_missing_response_types, ClientPaths.getRestrictedResponseTypes(), new Object[0]);
                    }
                    if (this.client.getGrantTypes().contains("implicit") && alreadyAddedResponseTypes.stream().noneMatch(respType -> respType.hasAny(new String[]{"id_token", "token"}))) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_implicit_grant_type_missing_response_types, ClientPaths.getRestrictedResponseTypes(), new Object[0]);
                    }
                }
                if (StringUtils.isBlank((String)this.client.getName())) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_name_required, ClientPaths.getName(), new Object[0]);
                } else if (this.client.getName().length() > 128) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_name_length, ClientPaths.getName(), 128);
                }
                this.validateJwksValues();
                this.validateClientAuthentication();
                Set grantTypes = this.client.getGrantTypes();
                if (grantTypes.isEmpty()) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_granttype_required, ClientPaths.getGrantTypes(), new Object[0]);
                }
                for (String grant : this.client.getGrantTypes()) {
                    if (GrantTypes.isValidGrant((String)grant)) continue;
                    this.appendError(ApiMessageKey.oauth_client_mgmt_granttype_invalid, ClientPaths.getGrantTypes(), grant);
                }
                if ((grantTypes.contains("authorization_code") || grantTypes.contains("implicit")) && this.client.getRedirectUris().size() == 0 && !this.client.getAllowAuthenticationApiInit()) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_uri_required, ClientPaths.getRedirectUris(), "authorization_code", "implicit");
                }
                if (!(!grantTypes.contains("refresh_token") || grantTypes.contains("password") || grantTypes.contains("authorization_code") || grantTypes.contains("urn:ietf:params:oauth:grant-type:device_code") || grantTypes.contains("urn:openid:params:grant-type:ciba") || grantTypes.contains("urn:ietf:params:oauth:grant-type:token-exchange"))) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_refreshtoken_usage, ClientPaths.getGrantTypes(), new Object[0]);
                }
                if (this.client.getClientAuthnType() == ClientAuthenticationType.NONE) {
                    if (grantTypes.contains("client_credentials")) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_client_auth_required_for_client_grant, ClientPaths.getClientAuth(), new Object[0]);
                    }
                    if (this.client.isGrantAccessSessionRevocationApi()) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_client_auth_required_for_revocation_api, ClientPaths.getClientAuth(), new Object[0]);
                    }
                    if (this.client.isGrantAccessSessionManagementApi()) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_client_auth_required_for_session_mgmt_api, ClientPaths.getClientAuth(), new Object[0]);
                    }
                }
                if (this.client.getRedirectUris().size() > 0) {
                    this.validateUriList(this.client.getRedirectUris(), "Redirect URI", ClientPaths.getRedirectUris());
                }
                if ("OVERRIDE_SERVER_DEFAULT".equals(this.client.getPersistentGrantExpirationType()) && ((time = this.client.getPersistentGrantExpirationTime()) == null || time <= 0L || time >= 1000L)) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_grant_exp_range, ClientPaths.getPersistentGrantExpirationTime(), 0, 1000);
                }
                if ("OVERRIDE_SERVER_DEFAULT".equals(this.client.getPersistentGrantIdleTimeoutType()) && ((idleTimeout = this.client.getPersistentGrantIdleTimeout()) == null || (Long)idleTimeout <= 0L || (Long)idleTimeout >= 1000L)) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_grant_idle_timeout, ClientPaths.getPersistentGrantIdleTimeout(), 0, 1000);
                }
                if (PersistentGrantLifetimeHelper.isInvalidLocalIdleTimeoutSetting((String)this.getClientPersistentGrantExpirationType(this.client), (String)this.getClientPersistentGrantExpiration(this.client), (String)this.client.getPersistentGrantExpirationTimeUnit(), (String)this.getClientPersistentGrantIdleTimeoutType(this.client), (String)this.getClientPersistentGrantIdleTimeout(this.client), (String)this.client.getPersistentGrantIdleTimeoutTimeUnit())) {
                    if ("SERVER_DEFAULT".equals(this.client.getPersistentGrantExpirationType())) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_grant_idle_timeout_greater_than_global_max_lifetime, ClientPaths.getPersistentGrantIdleTimeout(), new Object[0]);
                    } else {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_grant_idle_timeout_greater_than_max_lifetime, ClientPaths.getPersistentGrantIdleTimeout(), new Object[0]);
                    }
                }
                if (this.client.isOverrideReusePersistentGrantType()) {
                    for (String grant : this.client.getPersistentGrantReuseGrantTypes()) {
                        if (VALID_REUSE_PERSISTENT_GRANT_TYPES.contains(grant)) continue;
                        this.appendError(ApiMessageKey.oauth_client_mgmt_reuse_existing_persistent_grant_type_invalid, ClientPaths.getPersistentGrantReuseGrantTypes(), grant);
                    }
                }
                connectPolicyManager = (OpenIdConnectProviderPolicyManager)GlobalRegistry.getService(OpenIdConnectProviderPolicyManager.class);
                String idTokenSigningAlgorithm = this.client.getIdTokenSigningAlgorithm(this.useDefaultIdTokenSigningAlgo);
                if (StringUtils.isNotBlank((String)idTokenSigningAlgorithm) && !(supportedSigningAlgs2 = OpenIdConnectProviderInfo.idTokenSigningAlgMapSupportedWithNoneHmac().keySet()).contains(idTokenSigningAlgorithm)) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_signing_alg_invalid, ClientPaths.getIdTokenSignedResponseAlg(), "ID Token", supportedSigningAlgs2);
                }
                if (StringUtils.isNotBlank((String)this.client.getIdTokenEncryptionAlgorithm())) {
                    AlgorithmFactoryFactory aff = AlgorithmFactoryFactory.getInstance();
                    try {
                        String jweAlgoName = this.client.getIdTokenEncryptionAlgorithm();
                        if (!StringUtils.isNotBlank((String)jweAlgoName)) break block98;
                        String encAlgName = this.client.getIdTokenContentEncryptionAlgorithm();
                        List encryptionAlgList = OpenIdConnectProviderInfo.getEncryptionAlgorithms();
                        List contentEncryptionAlgList = OpenIdConnectProviderInfo.getContentEncryptionAlgorithms();
                        if (StringUtils.isBlank((String)encAlgName)) {
                            this.appendError(ApiMessageKey.oauth_client_mgmt_enc_alg_required, ClientPaths.getIdTokenContentEncryptionAlg(), "ID Token Content Encryption Algorithm", "ID Token Key Management Encryption Algorithm");
                        } else {
                            AlgorithmFactory jweContentEncryptionAlgorithmFactory = aff.getJweContentEncryptionAlgorithmFactory();
                            if (!jweContentEncryptionAlgorithmFactory.isAvailable(encAlgName)) {
                                this.appendError(ApiMessageKey.oauth_client_mgmt_alg_not_available, ClientPaths.getIdTokenContentEncryptionAlg(), "ID Token Content Encryption Algorithm", encAlgName, contentEncryptionAlgList);
                            }
                        }
                        AlgorithmFactory jweKeyManagementAlgorithmFactory = aff.getJweKeyManagementAlgorithmFactory();
                        if (!jweKeyManagementAlgorithmFactory.isAvailable(jweAlgoName)) {
                            this.appendError(ApiMessageKey.oauth_client_mgmt_alg_not_available, ClientPaths.getIdTokenEncryptionAlg(), "ID Token Encryption Algorithm", jweAlgoName, encryptionAlgList);
                            break block98;
                        }
                        KeyManagementAlgorithm jweAlgo = (KeyManagementAlgorithm)jweKeyManagementAlgorithmFactory.getAlgorithm(jweAlgoName);
                        switch (jweAlgo.getKeyPersuasion()) {
                            case ASYMMETRIC: {
                                this.validateJwks(ApiMessageKey.oauth_client_mgmt_jwks_url_or_jwks_required);
                                break;
                            }
                            case SYMMETRIC: {
                                break;
                            }
                        }
                    }
                    catch (JoseException e) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_problem_lookingup_keys, ClientPaths.getIdTokenEncryptionAlg(), new Object[0]);
                    }
                } else if (StringUtils.isNotBlank((String)this.client.getIdTokenContentEncryptionAlgorithm())) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_enc_alg_required, ClientPaths.getIdTokenContentEncryptionAlg(), "ID Token Key Management Encryption Algorithm", "ID Token Content Encryption Algorithm");
                }
            }
            if (StringUtils.isNotBlank((String)(userInfoSigningAlgorithm = this.client.getUserInfoResponseSigningAlgorithm())) && !(supportedSigningAlgs = OpenIdConnectProviderInfo.jwtSigningAlgorithmSetWithHmacWithoutNone()).contains(userInfoSigningAlgorithm)) {
                this.appendError(ApiMessageKey.oauth_client_mgmt_signing_alg_invalid, ClientPaths.getUserInfoResponseSignedResponseAlg(), "UserInfo Response", supportedSigningAlgs);
            }
            if (StringUtils.isNotBlank((String)this.client.getUserInfoResponseEncryptionAlgorithm())) {
                if (StringUtils.isBlank((String)userInfoSigningAlgorithm)) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_signing_alg_required, ClientPaths.getUserInfoResponseSignedResponseAlg(), "UserInfo Response Signing Algorithm", "UserInfo Response Key Management Encryption Algorithm");
                }
                AlgorithmFactoryFactory aff = AlgorithmFactoryFactory.getInstance();
                try {
                    AlgorithmFactory jweKeyManagementAlgorithmFactory;
                    AlgorithmFactory jweContentEncryptionAlgorithmFactory;
                    String userInfoEncryptionAlgName = this.client.getUserInfoResponseEncryptionAlgorithm();
                    if (!StringUtils.isNotBlank((String)userInfoEncryptionAlgName)) break block99;
                    String userInfoContentEncryptionAlgName = this.client.getUserInfoResponseContentEncryptionAlgorithm();
                    List encryptionAlgList = OpenIdConnectProviderInfo.getEncryptionAlgorithms();
                    List contentEncryptionAlgList = OpenIdConnectProviderInfo.getContentEncryptionAlgorithms();
                    if (StringUtils.isNotBlank((String)userInfoContentEncryptionAlgName) && !(jweContentEncryptionAlgorithmFactory = aff.getJweContentEncryptionAlgorithmFactory()).isAvailable(userInfoContentEncryptionAlgName)) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_alg_not_available, ClientPaths.getUserInfoResponseContentEncryptionAlg(), "UserInfo Response Content Encryption Algorithm", userInfoContentEncryptionAlgName, contentEncryptionAlgList);
                    }
                    if (!(jweKeyManagementAlgorithmFactory = aff.getJweKeyManagementAlgorithmFactory()).isAvailable(userInfoEncryptionAlgName)) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_alg_not_available, ClientPaths.getUserInfoResponseEncryptionAlg(), "UserInfo Response Key Management Encryption Algorithm", userInfoEncryptionAlgName, encryptionAlgList);
                        break block99;
                    }
                    KeyManagementAlgorithm jweAlgo = (KeyManagementAlgorithm)jweKeyManagementAlgorithmFactory.getAlgorithm(userInfoEncryptionAlgName);
                    switch (jweAlgo.getKeyPersuasion()) {
                        case ASYMMETRIC: {
                            this.validateJwks(ApiMessageKey.oauth_client_mgmt_jwks_url_or_jwks_required);
                            break;
                        }
                        case SYMMETRIC: {
                            break;
                        }
                    }
                }
                catch (JoseException e) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_problem_lookingup_keys, ClientPaths.getUserInfoResponseEncryptionAlg(), new Object[0]);
                }
            } else if (StringUtils.isNotBlank((String)this.client.getUserInfoResponseContentEncryptionAlgorithm())) {
                this.appendError(ApiMessageKey.oauth_client_mgmt_enc_alg_required, ClientPaths.getUserInfoResponseContentEncryptionAlg(), "UserInfo Response Key Management Encryption Algorithm", "UserInfo Response Content Encryption Algorithm");
            }
        }
        if (StringUtils.isNotEmpty((String)(policyGroupId = this.client.getPolicyGroupId())) && !(policyGroups = (policy = connectPolicyManager.getPolicy()).getPolicyGroups()).containsKey(policyGroupId)) {
            this.appendError(ApiMessageKey.oauth_client_mgmt_group_policy_invalid, ClientPaths.getPolicyGroup(), "Connect Policy Group ID");
        }
        if (this.isReversibleSecretInvalid(this.client)) {
            this.appendError(ApiMessageKey.oauth_client_mgmt_secret_required, ClientPaths.getClientId() + ", " + ClientPaths.getSecret(), new Object[0]);
        }
        this.validateSymmetricKey(this.client);
        if (this.client.getLogoutMode() == ClientLogoutMode.PING_FRONT_CHANNEL && !this.client.isPingAccessLogoutCapable() && this.client.getLogoutUris().isEmpty()) {
            this.appendError(ApiMessageKey.oauth_client_mgmt_logout_uri_required, ClientPaths.getLogoutUris(), this.client.getLogoutMode().getDisplayName());
        }
        if (this.client.getLogoutMode() == ClientLogoutMode.OIDC_BACK_CHANNEL && this.client.getBackChannelLogoutUri() == null) {
            this.appendError(ApiMessageKey.oauth_client_mgmt_back_channel_logout_uri_required, ClientPaths.getBackChannelLogoutUri(), this.client.getLogoutMode().getDisplayName());
        }
        if (this.client.getLogoutUris().size() > 0) {
            this.validateUriList(this.client.getLogoutUris(), "Front-Channel Logout URI", ClientPaths.getLogoutUris());
        }
        if (this.client.getBackChannelLogoutUri() != null) {
            this.validateUri(this.client.getBackChannelLogoutUri(), "Back-Channel Logout URI", ClientPaths.getBackChannelLogoutUri());
        }
        this.validateOidcFrontChannelUris();
        if (this.client.getPostLogoutRedirectUris().size() > 0) {
            this.validateUriList(this.client.getPostLogoutRedirectUris(), "Post-Logout Redirect URI", ClientPaths.getPostLogoutRedirectUris());
        }
        if (this.client.getDefaultAccessTokenManagerId() != null && (instance = (BearerAccessTokenMgmtPluginInstance)MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstance(this.client.getDefaultAccessTokenManagerId())) == null) {
            this.appendError(ApiMessageKey.oauth_client_mgmt_default_token_manager_id_invalid, ClientPaths.getDefaultAccessTokenManagerId(), this.client.getDefaultAccessTokenManagerId());
        }
        Set<String> acceptedAlgorithms = OpenIdConnectProviderInfo.getSupportedAsymmetricSignatureVerificationAlgorithms().keySet();
        Set<String> tokenEndpointAcceptedAlgorithms = this.client.isClientSecretJwtAuthn() ? OpenIdConnectProviderInfo.getSupportedSymmetricSignatureVerificationAlgorithms().keySet() : OpenIdConnectProviderInfo.getSupportedAsymmetricSignatureVerificationAlgorithms().keySet();
        this.validateSigningAlgorithm("Request Object", this.client.getRequestObjectSigningAlgorithm(), ClientPaths.getRequestObjectSigningAlgorithm(), acceptedAlgorithms);
        this.validateSigningAlgorithm("Token Endpoint", this.client.getTokenEndpointAuthSigningAlgorithm(), ClientPaths.getTokenEndpointAuthSigningAlgorithm(), tokenEndpointAcceptedAlgorithms);
        this.validateSigningAlgorithm("CIBA Request Object", this.client.getCibaRequestObjectSigningAlgorithm(), ClientPaths.getCibaRequestObjectSigningAlgorithm(), acceptedAlgorithms);
        if (this.client.isPairwiseUserType()) {
            HashSet<String> redirectUriHosts = new HashSet<String>();
            for (String redirectUri : this.client.getRedirectUris()) {
                try {
                    URI uri = new URI(redirectUri);
                    redirectUriHosts.add(uri.getHost());
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            if (this.client.getRedirectUris().isEmpty()) {
                this.appendError(ApiMessageKey.field_required, ClientPaths.getRedirectUris(), "Redirect URIs");
            } else if (redirectUriHosts.size() > 1 && StringUtils.isEmpty((String)this.client.getSectorIdentifierUri())) {
                this.appendError(ApiMessageKey.oauth_client_mgmt_sector_identifier_uri_required, ClientPaths.getSectorIdentifierUri(), "Sector Identifier URI");
            } else if (StringUtils.isNotEmpty((String)this.client.getSectorIdentifierUri()) && !ValidationUtil.isValidHttpsUrl((String)this.client.getSectorIdentifierUri())) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.malformed_https_url, ClientPaths.getSectorIdentifierUri(), new Object[]{"Sector Identifier URI"}));
            }
            if (this.client.getGrantTypes().contains("urn:openid:params:grant-type:ciba")) {
                if (StringUtils.isEmpty((String)this.client.getJwksUrl())) {
                    this.appendError(ApiMessageKey.field_required, ClientPaths.getJwksUriPath(), "JWKS URL");
                } else if (!this.client.isCibaRequireSignedRequests().booleanValue() && this.client.getSpecifiedClientAuthnType() != ClientAuthenticationType.PRIVATE_KEY_JWT && this.client.getSpecifiedClientAuthnType() != ClientAuthenticationType.CLIENT_CERT) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_pairwise_validation_error, ClientPaths.getPairwiseIdentifierUserType(), new Object[0]);
                }
            }
            this.validateSectorIdentifierUri();
        } else if (StringUtils.isNotEmpty((String)this.client.getSectorIdentifierUri())) {
            this.appendError(ApiMessageKey.field_not_required, ClientPaths.getSectorIdentifierUri(), "Sector Identifier URI");
        }
        this.validateDeviceFlowOverrideFields();
        this.validateCIBA();
        this.validateTokenExchange();
        this.validateRefreshTokenRollingGracePeriod();
        this.validateTokenIntrospectionSettings();
        this.validateJwtSecuredAuthorizationResponseModeSettings();
        this.validateLockoutMaxMaliciousActions();
        return !this.hasErrors();
    }

    private void validateSymmetricKey(Client client) {
        byte[] rawKeyValue;
        if (client.isClientSecretJwtAuthn() && client.hasSecret() && (rawKeyValue = client.getSecretAsUtf8Bytes()) != null && rawKeyValue.length * 8 < 128) {
            this.appendError(ApiMessageKey.oauth_client_mgmt_secret_key_length_invalid, ClientPaths.getClientId() + ", " + ClientPaths.getSecret(), client.getClientId(), rawKeyValue.length * 8, 128);
        }
    }

    private void validateSectorIdentifierUri() {
        if (!this.validateSectorIdentifierUri || StringUtils.isBlank((String)this.client.getSectorIdentifierUri()) || super.hasErrors()) {
            return;
        }
        String endpoint = this.client.getSectorIdentifierUri();
        try {
            HttpGet request = new HttpGet(endpoint);
            logger.info("Connecting to Sector Identifier URI:" + request.getRequestLine());
            String responseBody = HttpConnectionPoolingManager.getInstance().doRequest((HttpRequestBase)request);
            ObjectMapper mapper = ObjectMapperFactory.buildObjectMapper();
            Set sectorUris = (Set)mapper.readValue(responseBody, Set.class);
            for (String redirectUri : this.client.getRedirectUris()) {
                if (sectorUris.contains(redirectUri)) continue;
                this.appendError(ApiMessageKey.oauth_client_mgmt_uri_not_included_sector_uri, ClientPaths.getSectorIdentifierUri(), "Redirect URI", redirectUri);
            }
            if (this.client.getGrantTypes().contains("urn:openid:params:grant-type:ciba") && !sectorUris.contains(this.client.getJwksUrl())) {
                this.appendError(ApiMessageKey.oauth_client_mgmt_uri_not_included_sector_uri, ClientPaths.getSectorIdentifierUri(), "JWKS URL", this.client.getJwksUrl());
            }
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                String trace = ExceptionUtil.toStringWithCauses((Throwable)e);
                logger.debug(trace);
            }
            this.appendError(ApiMessageKey.oauth_client_mgmt_connecting_sector_uri, ClientPaths.getSectorIdentifierUri(), new Object[0]);
        }
    }

    private void validateSigningAlgorithm(String name, String value, String path, Set<String> acceptedAlgorithms) {
        if (StringUtils.isNotBlank((String)value) && !acceptedAlgorithms.contains(value)) {
            this.appendError(ApiMessageKey.oauth_client_mgmt_general_signing_alg_invalid, path, name, acceptedAlgorithms);
        }
    }

    private boolean errorExists(String error) {
        return this.getErrors().stream().anyMatch(err -> err.getErrorId() != null && err.getErrorId().equals(error));
    }

    private void validateDeviceFlowOverrideFields() {
        IntegerValidator devicePollingIntervalOverrideValdator;
        String devicePollingIntervalOverride;
        IntegerValidator pendingAuthorizationTimeoutOverrideValidator;
        String pendingAuthzTimeoutOverride;
        String deviceFlowSettingTypePath;
        String deviceFlowSettingType = this.client.getDeviceFlowSettingType();
        NotBlankValidator deviceFlowSettingNotBlankValidator = new NotBlankValidator(deviceFlowSettingType, "Device Flow Setting", deviceFlowSettingTypePath = ClientPaths.getDeviceFlowSettingTypePath());
        if (!deviceFlowSettingNotBlankValidator.validate()) {
            this.appendErrors(deviceFlowSettingNotBlankValidator.getErrors());
        } else if (DeviceFlowSettingType.getType(deviceFlowSettingType) == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_client_mgmt_device_flow_setting_type_invalid, deviceFlowSettingTypePath));
        }
        String userAuthzUrlOverride = this.client.getUserAuthzUrlOverride();
        if (StringUtils.isNotBlank((String)userAuthzUrlOverride)) {
            String path = ClientPaths.getUserAuthorizationUrlOverridePath();
            if (!ValidationUtil.isValidHttpOrHttpsUrl((String)userAuthzUrlOverride)) {
                this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.malformed_url, path, new Object[]{userAuthzUrlOverride}));
            }
        }
        if (StringUtils.isNotBlank((String)(pendingAuthzTimeoutOverride = this.client.getPendingAuthzTimeoutOverride())) && !(pendingAuthorizationTimeoutOverrideValidator = new IntegerValidator(pendingAuthzTimeoutOverride, "Pending Authorization Timeout Override", ClientPaths.getPendingAuthorizationTimeoutOverridePath(), false, 1, 3600)).validate()) {
            this.appendErrors(pendingAuthorizationTimeoutOverrideValidator.getErrors());
        }
        if (StringUtils.isNotBlank((String)(devicePollingIntervalOverride = this.client.getDevicePollingIntervalOverride())) && !(devicePollingIntervalOverrideValdator = new IntegerValidator(this.client.getDevicePollingIntervalOverride(), "Device Polling Interval Override", ClientPaths.getDevicePollingIntervalOverride(), false, 1, 3600)).validate()) {
            this.appendErrors(devicePollingIntervalOverrideValdator.getErrors());
        }
        Boolean bypassActivationConfirmationOverride = this.client.getBypassActivationCodeConfirmationOverride();
        if (DeviceFlowSettingType.OVERRIDE_SERVER_DEFAULT.equals((Object)DeviceFlowSettingType.getType(deviceFlowSettingType)) && StringUtils.isBlank((String)userAuthzUrlOverride) && StringUtils.isBlank((String)pendingAuthzTimeoutOverride) && StringUtils.isBlank((String)devicePollingIntervalOverride) && bypassActivationConfirmationOverride == null) {
            this.appendError(ValidationErrorFactory.getInstance().create(ApiMessageKey.oauth_client_mgmt_device_flow_setting_type_require_override, deviceFlowSettingTypePath));
        }
    }

    private String getFriendlyName(String grantTypeId) {
        String name = this.isStateUIValidation() ? GRANT_TYPE_FRIENDLY_NAMES.get(grantTypeId) : GrantType.getType((String)grantTypeId).name();
        return name == null ? grantTypeId : name;
    }

    private void validateJwksValues() {
        if (StringUtils.isNotBlank((String)this.client.getJwks()) || StringUtils.isNotBlank((String)this.client.getJwksUrl())) {
            String jwks;
            String jwksUri;
            block6: {
                jwksUri = this.client.getJwksUrl();
                jwks = this.client.getJwks();
                if (StringUtils.isNotEmpty((String)jwks)) {
                    try {
                        JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(jwks);
                        List keys = jsonWebKeySet.getJsonWebKeys();
                        if ((keys == null || keys.isEmpty()) && !this.errorExists(ApiMessageKey.oauth_client_mgmt_no_key_jwks.toString())) {
                            this.appendError(ApiMessageKey.oauth_client_mgmt_no_key_jwks, ClientPaths.getJwksPath(), new Object[0]);
                        }
                    }
                    catch (ClassCastException | JoseException e) {
                        if (this.errorExists(ApiMessageKey.oauth_client_mgmt_invalid_jwks.toString())) break block6;
                        this.appendError(ApiMessageKey.oauth_client_mgmt_invalid_jwks, ClientPaths.getJwksPath(), new Object[0]);
                    }
                }
            }
            if (!StringUtils.isBlank((String)jwks) && StringUtils.isNotBlank((String)jwksUri) && !this.errorExists(ApiMessageKey.oauth_client_mgmt_jwks_url_or_jwks.toString())) {
                this.appendError(ApiMessageKey.oauth_client_mgmt_jwks_url_or_jwks, ClientPaths.getJwksPath(), new Object[0]);
            }
        }
    }

    private void validateJwks(ApiMessageKey errorMsgKey) {
        if (StringUtils.isBlank((String)this.client.getJwksUrl()) && StringUtils.isBlank((String)this.client.getJwks())) {
            if (ApiMessageKey.oauth_client_mgmt_jwks_url_or_jwks_required_for_ciba_signed_requests == errorMsgKey) {
                this.appendError(errorMsgKey, ClientPaths.getJwksPath(), new Object[0]);
            } else if (!this.errorExists(errorMsgKey.toString())) {
                this.appendError(errorMsgKey, ClientPaths.getJwksPath(), new Object[0]);
            }
        }
    }

    private void validateUriList(List<String> uris, String uriType, String fieldPathBase) {
        ArrayList<String> urisSeen = new ArrayList<String>();
        int i = 0;
        for (String uriInList : uris) {
            String path = fieldPathBase + "[" + i + "]";
            if (urisSeen.contains(uriInList)) {
                this.appendError(ApiMessageKey.oauth_client_mgmt_uri_duplicate, path, new Object[0]);
            } else {
                urisSeen.add(uriInList);
                this.validateUri(uriInList, uriType, path);
            }
            ++i;
        }
    }

    private void validateUri(String uriString, String uriType, String path) {
        if (StringUtils.isEmpty((String)uriString)) {
            this.appendError(ApiMessageKey.oauth_client_mgmt_uri_invalid, path, uriType, ": URI cannot be empty");
        } else {
            try {
                URI uri = new URI(uriString);
                if (!uri.isAbsolute()) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_uri_absolute, path, uriType);
                }
                if (uri.getFragment() != null) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_uri_fragment, path, uriType);
                }
                if (explicitDisallowUris.contains(uriString)) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_uri_invalid, path, uriType, ": " + uriString);
                }
            }
            catch (URISyntaxException e) {
                this.appendError(ApiMessageKey.oauth_client_mgmt_uri_invalid, path, uriType, ": " + e.getMessage());
            }
        }
    }

    private void appendError(ApiMessageKey errorId, String fieldPath, Object ... params) {
        this.appendError(ValidationErrorFactory.getInstance().create(errorId, fieldPath, params));
    }

    private void validateClientAuthentication() {
        String clientCertSubjectDn = this.client.getClientCertSubjectDn();
        String clientCertIssuerDn = this.client.getClientCertIssuerDn();
        this.validateClientAuthType();
        if (this.client.getClientAuthnType() == null || this.client.getClientAuthnType() == ClientAuthenticationType.NONE || this.client.getClientAuthnType() == ClientAuthenticationType.CLIENT_CERT) {
            this.validateClientCertDN(clientCertSubjectDn, clientCertIssuerDn);
        }
        if (this.client.isJwtAuthn() || this.client.isRequireSignedRequests()) {
            this.validateJwks(ApiMessageKey.oauth_client_mgmt_jwks_url_or_jwks_required);
        }
        if (BooleanUtils.isTrue((Boolean)this.client.isCibaRequireSignedRequests())) {
            this.validateJwks(ApiMessageKey.oauth_client_mgmt_jwks_url_or_jwks_required_for_ciba_signed_requests);
        }
    }

    private void validateClientCertDN(String clientCertSubjectDn, String clientCertIssuerDn) {
        if (StringUtils.isNotBlank((String)clientCertIssuerDn)) {
            if (clientCertIssuerDn.contains("*")) {
                this.appendError(ApiMessageKey.oauth_client_mgmt_clientauth_asterisk, ClientPaths.getClientCertIssuerDn(), CLIENT_ISSUER_DN_LABEL);
            }
            if (!"Trust Any".equals(clientCertIssuerDn)) {
                try {
                    new LdapName(clientCertIssuerDn);
                    if (!OAuthClientValidator.hasMatchingTrustedCAs(this.client)) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_clientauth_match_dn, ClientPaths.getClientCertIssuerDn(), clientCertIssuerDn);
                    }
                }
                catch (InvalidNameException e) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_clientauth_invalid_format, ClientPaths.getClientCertIssuerDn(), CLIENT_ISSUER_DN_LABEL);
                }
            }
        }
        if (StringUtils.isNotBlank((String)clientCertSubjectDn)) {
            try {
                new LdapName(clientCertSubjectDn);
            }
            catch (InvalidNameException e) {
                this.appendError(ApiMessageKey.oauth_client_mgmt_clientauth_invalid_format, ClientPaths.getClientCertSubjectDn(), CLIENT_SUBJECT_DN_LABEL);
            }
        }
        if (StringUtils.isNotBlank((String)clientCertSubjectDn) && StringUtils.isBlank((String)clientCertIssuerDn)) {
            if (this.client instanceof DynamicOAuthClient) {
                this.appendError(ApiMessageKey.oauth_client_mgmt_authn_method_disabled_field_not_required, ClientPaths.getClientCertIssuerDn(), CLIENT_SUBJECT_DN_LABEL, ClientAuthenticationType.toClientAuthnType((ClientAuthenticationType)ClientAuthenticationType.CLIENT_CERT));
            } else {
                this.appendError(ApiMessageKey.oauth_client_mgmt_clientauth_required, ClientPaths.getClientCertIssuerDn(), CLIENT_ISSUER_DN_LABEL);
            }
        } else if (StringUtils.isBlank((String)clientCertSubjectDn) && StringUtils.isNotBlank((String)clientCertIssuerDn)) {
            this.appendError(ApiMessageKey.oauth_client_mgmt_clientauth_required, ClientPaths.getClientCertSubjectDn(), CLIENT_SUBJECT_DN_LABEL);
        }
    }

    private void validateClientAuthType() {
        ClientAuthenticationType authnType = this.client.getClientAuthnType();
        String encodedSecret = this.client.getEncodedSecret();
        String certIssuerDn = this.client.getClientCertIssuerDn();
        String certSubjectDn = this.client.getClientCertSubjectDn();
        if (ClientAuthenticationType.CLIENT_CERT == authnType) {
            if (StringUtils.isBlank((String)certIssuerDn)) {
                if (this.client instanceof DynamicOAuthClient) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_authn_method_disabled, ClientPaths.getClientCertIssuerDn(), ClientAuthenticationType.toClientAuthnType((ClientAuthenticationType)ClientAuthenticationType.CLIENT_CERT));
                } else {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_field_required_for_authn_type, ClientPaths.getClientCertIssuerDn(), "Issuer", "Client Certificate");
                }
            }
            if (StringUtils.isBlank((String)certSubjectDn)) {
                this.appendError(ApiMessageKey.oauth_client_mgmt_field_required_for_authn_type, ClientPaths.getClientCertSubjectDn(), "Subject DN", "Client Certificate");
            }
        } else if ((ClientAuthenticationType.SECRET == authnType || this.client.isClientSecretJwtAuthn()) && StringUtils.isBlank((String)encodedSecret)) {
            this.appendError(ApiMessageKey.oauth_client_mgmt_field_required_for_authn_type, ClientPaths.getSecret(), "Secret", ClientAuthenticationType.toClientAuthnType((ClientAuthenticationType)this.client.getClientAuthnType()));
        }
    }

    private static boolean hasMatchingTrustedCAs(Client client) {
        TrustedCAsManager mgr = MgmtFactory.getTrustedCAsManager();
        for (X509Certificate trustedCert : mgr.getTrustedCaX509s()) {
            X500Principal configuredIssuerDn = new X500Principal(client.getClientCertIssuerDn());
            if (!X500Util.equals((X500Principal)trustedCert.getSubjectX500Principal(), (X500Principal)configuredIssuerDn)) continue;
            return true;
        }
        return false;
    }

    public void setStateUIValidation(boolean stateValidation) {
        this.stateUIValidation = stateValidation;
    }

    public boolean isStateUIValidation() {
        return this.stateUIValidation;
    }

    public void setUseDefaultIdTokenSigningAlgo(boolean useDefaultIdTokenSigningAlgo) {
        this.useDefaultIdTokenSigningAlgo = useDefaultIdTokenSigningAlgo;
    }

    private void validateCIBA() {
        boolean cibaGrantTypeExist = this.client.getGrantTypes().contains("urn:openid:params:grant-type:ciba");
        String ciba_notification_endpoint = "CIBA Notification Endpoint";
        String ciba_token_delivery_mode = "CIBA Token Delivery Mode";
        String ciba_policy_id = "CIBA Policy Id";
        String ciba_polling_interval = "CIBA Polling Interval";
        String ciba_require_signed_requests = "CIBA Require Signed Requests";
        String ciba_user_code_supported = "CIBA User Code Supported";
        if (cibaGrantTypeExist) {
            CibaServerPolicy policy;
            Map policyGroups;
            String cibaPolicyId;
            CibaDeliveryMode mode = this.client.getCibaTokenDeliveryMode();
            if (mode == null) {
                this.appendError(ApiMessageKey.field_required, ClientPaths.getCibaDeliveryMode(), "CIBA Token Delivery Mode");
            } else if (CibaDeliveryMode.ping == mode) {
                if (StringUtils.isEmpty((String)this.client.getCibaNotificationEndpoint())) {
                    this.appendError(ApiMessageKey.field_required, ClientPaths.getCibaNotificationEndpoint(), "CIBA Notification Endpoint");
                } else if (!ValidationUtil.isValidHttpsUrl((String)this.client.getCibaNotificationEndpoint())) {
                    this.appendError(ApiMessageKey.malformed_https_url, ClientPaths.getCibaNotificationEndpoint(), "CIBA Notification Endpoint");
                }
            } else if (StringUtils.isNotEmpty((String)this.client.getCibaNotificationEndpoint())) {
                this.appendError(ApiMessageKey.field_not_required, ClientPaths.getCibaNotificationEndpoint(), "CIBA Notification Endpoint");
            }
            Integer cibaPollingInterval = this.client.getCibaPollingInterval();
            if (cibaPollingInterval == null || cibaPollingInterval < 1 || cibaPollingInterval > 3600) {
                this.appendError(ApiMessageKey.integer_value_not_in_range, ClientPaths.getCibaPollingInterval(), "CIBA Polling Interval", 1, 3600);
            }
            if (StringUtils.isNotEmpty((String)(cibaPolicyId = this.client.getCibaPolicyId())) && !(policyGroups = (policy = MgmtFactory.getCibaServerPolicyManager().getCibaServerPolicy()).getRequestHandlingPolicies()).containsKey(cibaPolicyId)) {
                this.appendError(ApiMessageKey.oauth_client_mgmt_group_policy_invalid, ClientPaths.getCibaRequestPolicy(), "CIBA Policy ID");
            }
        } else {
            if (this.client.getCibaTokenDeliveryMode() != null) {
                this.appendError(ApiMessageKey.field_not_required, ClientPaths.getCibaDeliveryMode(), "CIBA Token Delivery Mode");
            }
            if (StringUtils.isNotEmpty((String)this.client.getCibaNotificationEndpoint())) {
                this.appendError(ApiMessageKey.field_not_required, ClientPaths.getCibaNotificationEndpoint(), "CIBA Notification Endpoint");
            }
            if (StringUtils.isNotEmpty((String)this.client.getCibaPolicyId())) {
                this.appendError(ApiMessageKey.field_not_required, ClientPaths.getCibaRequestPolicy(), "CIBA Policy Id");
            }
            if (this.client.getCibaPollingInterval() != null) {
                this.appendError(ApiMessageKey.field_not_required, ClientPaths.getCibaPollingInterval(), "CIBA Polling Interval");
            }
            if (this.client.isCibaRequireSignedRequests() != null) {
                this.appendError(ApiMessageKey.field_not_required, ClientPaths.getCibaRequireSignedRequests(), "CIBA Require Signed Requests");
            }
            if (this.client.isCibaUserCodeSupported() != null) {
                this.appendError(ApiMessageKey.field_not_required, ClientPaths.getCibaUserCodeSupported(), "CIBA User Code Supported");
            }
            if (this.client.getCibaRequestObjectSigningAlgorithm() != null) {
                this.appendError(ApiMessageKey.field_not_required, ClientPaths.getCibaRequestObjectSigningAlgorithm(), "CIBA Request Object Signing Algorithm");
            }
        }
    }

    private void validateTokenExchange() {
        String token_exchange_processor_policy_id = "Token Exchange Processor Policy ID";
        if (this.client.getGrantTypes().contains("urn:ietf:params:oauth:grant-type:token-exchange")) {
            TokenExchangeProcessorPolicies policies;
            String tokenExchangeProcessorPolicyId = this.client.getTokenExchangeProcessorPolicyId();
            if (StringUtils.isNotEmpty((String)tokenExchangeProcessorPolicyId) && !(policies = MgmtFactory.getTokenExchangeProcessorPolicyManager().getTokenExchangeProcessorPolicies()).containsInstance(tokenExchangeProcessorPolicyId)) {
                this.appendError(ApiMessageKey.oauth_client_mgmt_group_policy_invalid, ClientPaths.getTokenExchangeProcessorPolicy(), "Token Exchange Processor Policy ID");
            }
        } else if (StringUtils.isNotEmpty((String)this.client.getTokenExchangeProcessorPolicyId())) {
            this.appendError(ApiMessageKey.field_not_required, ClientPaths.getTokenExchangeProcessorPolicy(), "Token Exchange Processor Policy ID");
        }
    }

    private void validateRefreshTokenRollingGracePeriod() {
        RefreshTokenRollingGracePeriodValidator validator = RefreshTokenRollingGracePeriodValidator.newInstance(this.client);
        if (!validator.validate()) {
            this.appendErrors(validator.getErrors());
        }
    }

    public void setValidateSectorIdentifierUri(boolean validateSectorIdentifierUri) {
        this.validateSectorIdentifierUri = validateSectorIdentifierUri;
    }

    protected boolean isReversibleSecretInvalid(Client client) {
        return client.needReversibleSecret() && client.getSecretAsUtf8Bytes() == null;
    }

    private void validateTokenIntrospectionSettings() {
        block13: {
            Set supportedSigningAlgs = OpenIdConnectProviderInfo.jwtSigningAlgorithmSetWithHmacWithoutNone();
            this.validateSigningAlgorithm("Token Introspection", this.client.getIntrospectionSigningAlgorithm(), ClientPaths.getTokenIntrospectionSigningAlgorithmPath(), supportedSigningAlgs);
            if (StringUtils.isNotBlank((String)this.client.getIntrospectionEncryptionAlgorithm())) {
                AlgorithmFactoryFactory aff = AlgorithmFactoryFactory.getInstance();
                try {
                    String jweAlgoName = this.client.getIntrospectionEncryptionAlgorithm();
                    if (!StringUtils.isNotBlank((String)jweAlgoName)) break block13;
                    String encAlgName = this.client.getIntrospectionContentEncryptionAlgorithm();
                    List encryptionAlgList = OpenIdConnectProviderInfo.getEncryptionAlgorithms();
                    List contentEncryptionAlgList = OpenIdConnectProviderInfo.getContentEncryptionAlgorithms();
                    if (StringUtils.isBlank((String)encAlgName)) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_enc_alg_required, ClientPaths.getTokenIntrospectionContentEncryptionAlgorithmPath(), "Token Introspection Content Encryption Algorithm", "Token Introspection Key Management Encryption Algorithm");
                    } else {
                        AlgorithmFactory jweContentEncryptionAlgorithmFactory = aff.getJweContentEncryptionAlgorithmFactory();
                        if (!jweContentEncryptionAlgorithmFactory.isAvailable(encAlgName)) {
                            this.appendError(ApiMessageKey.oauth_client_mgmt_alg_not_available, ClientPaths.getTokenIntrospectionContentEncryptionAlgorithmPath(), "Token Introspection Content Encryption Algorithm", encAlgName, contentEncryptionAlgList);
                        }
                    }
                    AlgorithmFactory jweKeyManagementAlgorithmFactory = aff.getJweKeyManagementAlgorithmFactory();
                    if (!jweKeyManagementAlgorithmFactory.isAvailable(jweAlgoName)) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_alg_not_available, ClientPaths.getTokenIntrospectionEncryptionAlgorithmPath(), "Token Introspection Encryption Algorithm", jweAlgoName, encryptionAlgList);
                        break block13;
                    }
                    KeyManagementAlgorithm jweAlgo = (KeyManagementAlgorithm)jweKeyManagementAlgorithmFactory.getAlgorithm(jweAlgoName);
                    switch (jweAlgo.getKeyPersuasion()) {
                        case ASYMMETRIC: {
                            this.validateJwks(ApiMessageKey.oauth_client_mgmt_jwks_url_or_jwks_required);
                            break;
                        }
                        case SYMMETRIC: {
                            break;
                        }
                    }
                }
                catch (JoseException e) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_problem_lookingup_keys, ClientPaths.getTokenIntrospectionEncryptionAlgorithmPath(), new Object[0]);
                }
            } else if (StringUtils.isNotBlank((String)this.client.getIntrospectionContentEncryptionAlgorithm())) {
                this.appendError(ApiMessageKey.oauth_client_mgmt_enc_alg_required, ClientPaths.getTokenIntrospectionContentEncryptionAlgorithmPath(), "Token Introspection Key Management Encryption Algorithm", "Token Introspection Content Encryption Algorithm");
            }
        }
    }

    private void validateJwtSecuredAuthorizationResponseModeSettings() {
        block13: {
            Set supportedSigningAlgs = OpenIdConnectProviderInfo.jwtSigningAlgorithmSetWithHmacWithoutNone();
            this.validateSigningAlgorithm("JWT Secured Authorization Response mode", this.client.getAuthorizationResponseSigningAlgorithm(), ClientPaths.getJwtSecuredAuthorizationResponseModeSigningAlgorithmPath(), supportedSigningAlgs);
            if (StringUtils.isNotBlank((String)this.client.getAuthorizationResponseEncryptionAlgorithm())) {
                AlgorithmFactoryFactory aff = AlgorithmFactoryFactory.getInstance();
                try {
                    String jweAlgoName = this.client.getAuthorizationResponseEncryptionAlgorithm();
                    if (!StringUtils.isNotBlank((String)jweAlgoName)) break block13;
                    String encAlgName = this.client.getAuthorizationResponseContentEncryptionAlgorithm();
                    List encryptionAlgList = OpenIdConnectProviderInfo.getEncryptionAlgorithms();
                    List contentEncryptionAlgList = OpenIdConnectProviderInfo.getContentEncryptionAlgorithms();
                    if (StringUtils.isBlank((String)encAlgName)) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_enc_alg_required, ClientPaths.getJwtSecuredAuthorizationResponseModeContentEncryptionAlgorithmPath(), "JWT Secured Authorization Response mode Content Encryption Algorithm", "JWT Secured Authorization Response mode Key Management Encryption Algorithm");
                    } else {
                        AlgorithmFactory jweContentEncryptionAlgorithmFactory = aff.getJweContentEncryptionAlgorithmFactory();
                        if (!jweContentEncryptionAlgorithmFactory.isAvailable(encAlgName)) {
                            this.appendError(ApiMessageKey.oauth_client_mgmt_alg_not_available, ClientPaths.getJwtSecuredAuthorizationResponseModeContentEncryptionAlgorithmPath(), "JWT Secured Authorization Response mode Content Encryption Algorithm", encAlgName, contentEncryptionAlgList);
                        }
                    }
                    AlgorithmFactory jweKeyManagementAlgorithmFactory = aff.getJweKeyManagementAlgorithmFactory();
                    if (!jweKeyManagementAlgorithmFactory.isAvailable(jweAlgoName)) {
                        this.appendError(ApiMessageKey.oauth_client_mgmt_alg_not_available, ClientPaths.getJwtSecuredAuthorizationResponseModeEncryptionAlgorithmPath(), "JWT Secured Authorization Response mode Encryption Algorithm", jweAlgoName, encryptionAlgList);
                        break block13;
                    }
                    KeyManagementAlgorithm jweAlgo = (KeyManagementAlgorithm)jweKeyManagementAlgorithmFactory.getAlgorithm(jweAlgoName);
                    switch (jweAlgo.getKeyPersuasion()) {
                        case ASYMMETRIC: {
                            this.validateJwks(ApiMessageKey.oauth_client_mgmt_jwks_url_or_jwks_required);
                            break;
                        }
                        case SYMMETRIC: {
                            break;
                        }
                    }
                }
                catch (JoseException e) {
                    this.appendError(ApiMessageKey.oauth_client_mgmt_problem_lookingup_keys, ClientPaths.getJwtSecuredAuthorizationResponseModeEncryptionAlgorithmPath(), new Object[0]);
                }
            } else if (StringUtils.isNotBlank((String)this.client.getAuthorizationResponseContentEncryptionAlgorithm())) {
                this.appendError(ApiMessageKey.oauth_client_mgmt_enc_alg_required, ClientPaths.getJwtSecuredAuthorizationResponseModeContentEncryptionAlgorithmPath(), "JWT Secured Authorization Response mode Key Management Encryption Algorithm", "JWT Secured Authorization Response mode Content Encryption Algorithm");
            }
        }
    }

    private void validateOidcFrontChannelUris() {
        if (this.client.getLogoutMode() != ClientLogoutMode.OIDC_FRONT_CHANNEL) {
            return;
        }
        if (this.client.getLogoutUris().size() != 1) {
            this.appendError(ApiMessageKey.oauth_client_mgmt_one_front_channel_logout_uri_required, ClientPaths.getLogoutUris(), this.client.getLogoutMode().getDisplayName());
        }
        if (!this.client.getLogoutUris().isEmpty() && !this.client.getRedirectUris().isEmpty()) {
            Set redirectUriSet = this.client.getRedirectUris().stream().map(redirectUri -> {
                try {
                    URI uri = new URI((String)redirectUri);
                    return new ImmutableTriple((Object)uri.getScheme(), (Object)uri.getHost(), (Object)uri.getPort());
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            for (int ix = 0; ix < this.client.getLogoutUris().size(); ++ix) {
                try {
                    URI uri = new URI((String)this.client.getLogoutUris().get(ix));
                    ImmutableTriple triple = new ImmutableTriple((Object)uri.getScheme(), (Object)uri.getHost(), (Object)uri.getPort());
                    if (redirectUriSet.contains(triple)) continue;
                    String fieldPath = ClientPaths.getLogoutUri(ix);
                    this.appendError(ApiMessageKey.oauth_client_mgmt_front_channel_logout_uri_invalid, fieldPath, this.client.getLogoutMode().getDisplayName());
                    continue;
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
    }

    private void validateLockoutMaxMaliciousActions() {
        String lockoutMaxMaliciousActionsStr;
        String lockoutMaxMaliciousActionsType = this.client.getLockoutMaxMaliciousActionsType();
        LockoutMaxMaliciousActionsValidator validator = LockoutMaxMaliciousActionsValidator.newInstance(lockoutMaxMaliciousActionsType, lockoutMaxMaliciousActionsStr = this.client.getLockoutMaxMaliciousActions() != null ? String.valueOf(this.client.getLockoutMaxMaliciousActions()) : null, ClientPaths.getLockoutMaxMaliciousActionsTypePath(), ClientPaths.getLockoutMaxMaliciousActionsPath());
        if (!validator.validate()) {
            this.appendErrors(validator.getErrors());
        }
    }

    static {
        ClientUtil.RESPONSE_TYPES.forEach(responseType -> responseTypesList.add(ClientUtil.getResponseTypes((String)responseType)));
        explicitDisallowUris = new HashSet<String>(Arrays.asList("http:/", "https:/"));
    }

    public static interface UniqueIdChecker {
        public boolean isUnique(String var1);
    }
}

